/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import org.apache.commons.collections.CollectionUtils;

public class NontaxService {
    private static Log logger = LogFactory.getLog(NontaxService.class);
    private static BigDecimal WB_W = new BigDecimal("5000000");
    private static BigDecimal TWO_THOUSAND_W = new BigDecimal("20000000");

    public static void handleSummaryMiddle(List<DynamicObject> summaryList, String type, String fieldName, int size, int beginSeq, String entityName) {
        NontaxService.handleSummaryMiddle(summaryList, type, fieldName, size, false, beginSeq, entityName);
    }

    public static void handleSummaryMiddle(List<DynamicObject> summaryList, String type, String fieldName, int size, boolean combine, int beginSeq, String entityName) {
        List<DynamicObject> list = NontaxService.getHandleSummaryMiddleResult(summaryList, type, fieldName, 0, combine, beginSeq, entityName);
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static List<DynamicObject> getHandleSummaryMiddleResult(List<DynamicObject> summaryList, String type, String fieldName, int size, int beginSeq, String entityName) {
        return NontaxService.getHandleSummaryMiddleResult(summaryList, type, fieldName, size, false, beginSeq, entityName);
    }

    public static List<DynamicObject> getHandleSummaryMiddleResult(List<DynamicObject> summaryList, String type, String fieldName, int size, boolean combine, int beginSeq, String entityName) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : summaryList) {
            DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)NontaxService.getObjectRuleId(dynamicObject), (String)"tccit_preferential_item");
            DynamicObject item = rule.getDynamicObject("itemchoicename");
            Long itemId = item.getLong("id");
            String itemName = item.getString("name");
            if (combine && item.getInt("level") == 3) {
                itemId = item.getDynamicObject("parent").getLong("id");
                itemName = item.getDynamicObject("parent").getString("name");
            }
            BigDecimal nontaxtotal = dynamicObject.getBigDecimal(fieldName);
            DynamicObject temp = map.getOrDefault(itemId, NontaxService.getDynObj(dynamicObject, type, itemName, itemId, entityName));
            temp.set("nontaxtotal", (Object)BigDecimalUtil.addObject((Object)temp.getBigDecimal("nontaxtotal"), (Object)nontaxtotal));
            map.put(itemId, temp);
        }
        List<DynamicObject> list = NontaxService.createList(map);
        int seq = beginSeq;
        for (DynamicObject summary : list) {
            summary.set("serialno", (Object)seq);
            ++seq;
        }
        return list;
    }

    private static Long getObjectRuleId(DynamicObject dynamicObject) {
        Long ruleId = 0L;
        DynamicObject rule = dynamicObject.getDynamicObject("rule");
        if (rule != null) {
            ruleId = rule.containsProperty("id") ? Long.valueOf(rule.getLong("id")) : (Long)dynamicObject.get("rule");
        }
        return ruleId;
    }

    private static List<DynamicObject> createList(Map<Long, DynamicObject> map) {
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(1);
        map.forEach((key, object) -> {
            String discounttype = object.getString("discounttype");
            BigDecimal nontaxtotal = object.getBigDecimal("nontaxtotal");
            if ("10".equals(discounttype)) {
                NontaxService.calAmount(object, nontaxtotal, WB_W);
                object.set("rulename", (Object)ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u4e00\u822c\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u6240\u5f97\u51cf\u514d\u7d2f\u8ba1\u6570", (String)"NontaxService_0", (String)"taxc-tccit", (Object[])new Object[0]));
            } else if ("12".equals(discounttype)) {
                NontaxService.calAmount(object, nontaxtotal, TWO_THOUSAND_W);
                object.set("rulename", (Object)ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u4e2d\u5173\u6751\u56fd\u5bb6\u81ea\u4e3b\u521b\u65b0\u793a\u8303\u533a\u7279\u5b9a\u533a\u57df\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u6240\u5f97\u51cf\u514d\u7d2f\u8ba1\u6570", (String)"NontaxService_1", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            summaryList.add((DynamicObject)object);
        });
        summaryList.removeIf(s -> s.getBigDecimal("nontaxtotal").compareTo(BigDecimal.ZERO) == 0);
        if (CollectionUtils.isNotEmpty(summaryList)) {
            return summaryList.stream().sorted((rule1, rule2) -> {
                BigDecimal number1 = rule1.getBigDecimal("nontaxtotal");
                BigDecimal number2 = rule2.getBigDecimal("nontaxtotal");
                return number2.compareTo(number1);
            }).collect(Collectors.toList());
        }
        return summaryList;
    }

    private static void calAmount(DynamicObject dynamicObject, BigDecimal nontaxtotal, BigDecimal compareAmount) {
        if (nontaxtotal.compareTo(compareAmount) > 0) {
            nontaxtotal = BigDecimalUtil.divideObject((Object)nontaxtotal.add(compareAmount), (Object)BigDecimal.valueOf(2L), (int)2);
            dynamicObject.set("nontaxtotal", (Object)nontaxtotal);
        }
    }

    private static DynamicObject getDynObj(DynamicObject dynamicObject, String type, String itemName, Long itemId, String entityName) {
        DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        summary.set("org", (Object)NontaxService.getOrgId(dynamicObject));
        summary.set("type", (Object)type);
        summary.set("skssqq", (Object)dynamicObject.getDate("skssqq"));
        summary.set("skssqz", (Object)dynamicObject.getDate("skssqz"));
        summary.set("rulename", (Object)itemName);
        summary.set("discounttype", (Object)dynamicObject.getString("discounttype"));
        summary.set("ruleid", (Object)itemId);
        summary.set("item", (Object)itemId);
        return summary;
    }

    private static Long getOrgId(DynamicObject dynamicObject) {
        if (dynamicObject.get("org") instanceof Long) {
            return dynamicObject.getLong("org");
        }
        if (dynamicObject.get("org") instanceof DynamicObject) {
            return dynamicObject.getDynamicObject("org").getLong("id");
        }
        return 0L;
    }
}

