/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class OpenDraftService {
    private static Map<String, String> pages = new HashMap<String, String>();

    public static Map<String, String> getPages() {
        return pages;
    }

    public static void openDraftPage(IFormView view, String number) {
        Map params = view.getFormShowParameter().getCustomParams();
        FormShowParameter formShowParameter = new FormShowParameter();
        Object category = params.get("category");
        if (number == null && "qrlr".equals(category)) {
            number = "A100000-1";
        } else if (number == null && "sdstz".equals(category)) {
            number = "A100000-2";
        } else if (number == null && "sejs".equals(category)) {
            number = "A100000-3";
        }
        params.put("sheetname", number);
        String orgid = (String)params.get("orgid");
        String skssqq = (String)params.get("skssqq");
        String skssqz = (String)params.get("skssqz");
        Integer currentStatus = Integer.valueOf(DeclareStepsUtils.getStatus((Map)params, (String)orgid, (String)skssqq, (String)skssqz));
        int reqStep = Integer.parseInt((String)params.get("focuspage"));
        if (currentStatus < reqStep && reqStep == 2) {
            params.put("refresh", "true");
            DeclareStepsUtils.updateStatus((Map)params, (String)orgid, (String)skssqq, (String)skssqz, (IFormView)view);
        } else {
            params.put("refresh", "false");
        }
        params.put("needwarn", "true");
        params.put("needremark", "true");
        params.put("ParentCache", "true");
        params.put("changedsave", "false");
        params.put("templatetype", "qysdsnb_dg");
        formShowParameter.setCustomParams(params);
        String page = pages.get(number);
        if (page != null) {
            formShowParameter.setFormId(page);
        } else {
            formShowParameter.setFormId("bdtaxr_declare_old");
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap2");
        String pageid = formShowParameter.getPageId();
        IPageCache parCache = (IPageCache)view.getParentView().getService(IPageCache.class);
        parCache.put("declarepageid", pageid);
        view.showForm(formShowParameter);
    }

    public static void getPolicyCustomer(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter startDateFilter = new QFilter("startdate", ">=", (Object)skssqq);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)DateUtils.getDayLast((Date)skssqz));
        DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache((String)"tccit_policy_confirm", (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter});
        customParams.put("policy", policy);
    }

    static {
        pages.put("B105014-1", "tccit_salary_tz_list");
        pages.put("B105014-2", "tccit_b105014_list");
        pages.put("B105014-3", "tccit_b105014_3_list");
        pages.put("B105014-4", "tccit_edufull_list");
        pages.put("B105035", "tccit_qt_salary_list");
        pages.put("A105000-3", "tccit_thinkof_sell_list");
        pages.put("B105024", "tccit_beforetax_deduct_l");
        pages.put("B105025", "tccit_period_tz_list");
        pages.put("B105016", "tccit_advert_script_l");
        pages.put("B105015", "tccit_ywzdf_tz_list");
        pages.put("B105026", "tccit_assets_reserve_list");
        pages.put("B105030", "tccit_hhqyhhr_list");
        pages.put("B105018", "tccit_interest_tz_list");
        pages.put("B105023-1", "tccit_insurance_list");
        pages.put("B105023-2", "tccit_commission_list");
        pages.put("B105090_1", "tccit_deduct_other_list");
        pages.put("B105040", "tccit_zc_ohter_list");
        pages.put("B105080", "tccit_zctz_expense_list");
        pages.put("B105041", "tccit_spec_other_list");
        pages.put("A202050300", "tccit_spec_dksszbjtz_list");
        pages.put("B105045", "tccit_other_spec_list");
        pages.put("B105044", "tccit_other_other_list");
        pages.put("B105046", "tccit_zczjtx_list");
        pages.put("B105046-1", "tccit_zczjtx_list");
        pages.put("B105100", "tccit_qyczjdyns_tz_list");
        pages.put("A100000-1", "tccit_dg_a100000_1_list");
        pages.put("A104000", "tccit_profit_fees_list");
        pages.put("A102010", "tccit_profit_cost_list");
        pages.put("A102020", "tccit_dg_a102020_list");
        pages.put("A101010", "tccit_profit_income_list");
        pages.put("A101020", "tccit_dg_a101020_list");
        pages.put("A103000", "tccit_dg_a103000_list");
        pages.put("A105000-10", "tccit_hzdg_tssxtz_list");
        pages.put("A105000-1-1", "tccit_hzdg_qttz_list");
        pages.put("A105000-11", "tccit_hzdg_msjj_list");
        pages.put("B105047", "tccit_assets_loss_list");
        pages.put("A100000-3", "tccit_setz_sejs_list");
        pages.put("A100000-4", "tccit_getreduce_list");
        pages.put("B105050", "tccit_getredu_list");
        pages.put("B105051", "tccit_getredu_list");
        pages.put("A109000", "tccit_seft_hznsqy_list");
        pages.put("A109010", "tccit_seft_fzjg_list");
        pages.put("A109011", "tccit_setz_jmyhhz_list");
        pages.put("A109011-1", "tccit_small_list");
        pages.put("A109011-3", "tccit_soft_ic_dg_list");
        pages.put("B105021", "tccit_b105021_list");
        pages.put("B105020", "tccit_b105020_list");
        pages.put("B105019", "tccit_b105019_list");
        pages.put("B105037", "tccit_dg_b105037_list");
        pages.put("B105038", "tccit_dg_b105038_list");
        pages.put("B105039", "tccit_dev_jjkc_list");
        pages.put("A100000-0", "tccit_a100000_0_list");
        pages.put("B105060", "tccit_b105060_list");
        pages.put("A301010200", "tccit_dg_a301010200_list");
        pages.put("A301010201", "tccit_dg_a301010201_list");
        pages.put("A100000-7", "tccit_dg_a100000_7_list");
        pages.put("A100000-2", "tccit_domestic_adjust_lis");
        pages.put("A105000-9", "tccit_income_adjust_list");
        pages.put("A105000-2", "tccit_deduct_adjust_list");
        pages.put("A105000-4", "tccit_asset_adjust_list");
        pages.put("B105048", "tccit_zero_rating_list");
        pages.put("B105036", "tccit_dg_b105036_list");
        pages.put("B105034", "tccit_asset_dispose_list");
        pages.put("B105033", "tccit_income_ohter_list");
        pages.put("B105032", "tccit_gyjzbdsy_list");
        pages.put("B105027", "tccit_a105020_list");
        pages.put("B105028", "tccit_sale_zkzrth_list");
        pages.put("B105029", "tccit_invest_profit_list");
        pages.put("B105031", "tccit_tzzccscbtz_list");
        pages.put("B105093", "tccit_dg_b105093_list");
        pages.put("A109011-4", "tccit_jmyhhz_dg_list");
        pages.put("A109020", "tccit_yh_taxcredit_list");
    }
}

