/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.declare.servicehelper.TaxDeclareServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PeriodService {
    public static List<String> getPeriodList(Date skssqq, Date skssqz) {
        ArrayList<String> list = new ArrayList<String>();
        if (DateUtils.formatMonth((Date)skssqq).equals(DateUtils.formatMonth((Date)skssqz))) {
            list.add(DateUtils.formatMonth((Date)skssqq));
        } else {
            while (skssqq.compareTo(skssqz) <= 0) {
                list.add(DateUtils.formatMonth((Date)skssqq));
                skssqq = DateUtils.addMonth((Date)skssqq, (int)1);
            }
        }
        return list;
    }

    public static DynamicObject loadTaxMain(String orgId) {
        return (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
    }

    public static TaxResult<DynamicObject> queryTaxcMainByOrgId(String orgId) {
        return TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
    }

    public static List<Date> getRealDates(List<String> realZone, Date queryStart, Date queryEnd) {
        ArrayList<Date> result = new ArrayList<Date>();
        if (realZone.isEmpty()) {
            return result;
        }
        List<String> queryList = PeriodService.getPeriodList(queryStart, queryEnd);
        List<String> realList = PeriodService.getPeriodList(DateUtils.stringToDate((String)realZone.get(0)), DateUtils.stringToDate((String)realZone.get(1)));
        queryList.retainAll(realList);
        Collections.sort(queryList);
        if (queryList.isEmpty()) {
            return result;
        }
        result.add(DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)queryList.get(0), (String)"yyyy-MM")));
        result.add(DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)queryList.get(queryList.size() - 1), (String)"yyyy-MM")));
        return result;
    }

    public static boolean isValidSeasonalDates(Date startdate, Date enddate) {
        int enddateMonth;
        int enddateYear;
        int startdateYear = DateUtils.getYearOfDate((Date)startdate);
        if (startdateYear != (enddateYear = DateUtils.getYearOfDate((Date)enddate))) {
            return false;
        }
        int startdateMonth = DateUtils.getMonthOfDate((Date)startdate);
        if (startdateMonth != (enddateMonth = DateUtils.getMonthOfDate((Date)enddate)) - 2) {
            return false;
        }
        if (startdateMonth != 1 && startdateMonth != 4 && startdateMonth != 7 && startdateMonth != 10) {
            return false;
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)startdate);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)enddate);
        return DateUtils.format((Date)firstDateOfMonth).equals(DateUtils.format((Date)startdate)) && DateUtils.format((Date)lastDateOfMonth).equals(DateUtils.format((Date)enddate));
    }

    public static String getTaxPeriod(String date) {
        if (StringUtils.isNotBlank((CharSequence)date) && date.length() > 7) {
            return date.substring(0, 7);
        }
        return date;
    }

    private static Date getBeforeSeasonLastMonth(Date currentMonth) {
        Date first = DateUtils.getFirstDateOfSeason((Date)currentMonth);
        return DateUtils.addMonth((Date)first, (int)-1);
    }

    public static boolean isSameSeason(Date startMonth, Date endMonth) {
        if (DateUtils.getYearOfDate((Date)startMonth) != DateUtils.getYearOfDate((Date)endMonth)) {
            return false;
        }
        ArrayList month = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
        List partitions = Lists.partition((List)month, (int)3);
        int c = DateUtils.getMonthOfDate((Date)startMonth);
        int l = DateUtils.getMonthOfDate((Date)endMonth);
        List list = partitions.stream().filter(s -> s.contains(c) && s.contains(l)).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(list);
    }

    public static Map<String, Date> getPreTaxPeriod(String draftPurpose, String orgId, Date now) {
        if ("sjjt".equals(draftPurpose)) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), now);
            return PeriodService.preProvisionPeriod(now, cycle);
        }
        return PeriodService.preTaxPeriod(orgId, now);
    }

    public static Map<String, Date> getNowTaxPeriod(String draftPurpose, String orgId, Date now) {
        if ("sjjt".equals(draftPurpose)) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), now);
            return PeriodService.nowProvisionPeriod(now, cycle);
        }
        return PeriodService.nowTaxPeriod(orgId, now);
    }

    public static String getCycleByProvisionPlan(List<Long> orgIds, Date now) {
        TaxResult listTaxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(orgIds, (Long)BaseTaxCategory.QYSDS, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)now, (Date)now);
        List data = (List)listTaxResult.getData();
        if (listTaxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)data)) {
            DynamicObject provisionPlan = (DynamicObject)data.get(0);
            return provisionPlan.getString("ruleentity.rule.cycle");
        }
        return null;
    }

    private static Map<String, Date> sjjtTaxPeriod(Date now, String cycle) {
        return DateUtils.getPrePeriodByTaxLimit((Date)now, (String)cycle);
    }

    public static Map<String, Date> preProvisionPeriod(Date now, String cycle) {
        return PeriodService.provisionPeriod(now, cycle, PeriodService::sjjtTaxPeriod);
    }

    public static Map<String, Date> nowProvisionPeriod(Date now, String cycle) {
        return PeriodService.provisionPeriod(now, cycle, DateUtils::getPeriodByTaxLimit);
    }

    public static Map<String, Date> provisionPeriod(Date now, String cycle, BiFunction<Date, String, Map<String, Date>> function) {
        HashMap<String, Date> result = new HashMap<String, Date>();
        if (StringUtils.isBlank((CharSequence)cycle) || now == null) {
            result.put("startDate", null);
            result.put("endDate", null);
            return result;
        }
        return function.apply(now, cycle);
    }

    public static Map<String, Date> preTaxPeriod(String orgId, Date now) {
        Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
        Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        HashMap<String, Date> result = new HashMap<String, Date>();
        if (StringUtils.isBlank((CharSequence)orgId) || now == null) {
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            return result;
        }
        Date lastMonth = DateUtils.addMonth((Date)now, (int)-1);
        boolean exists = false;
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(orgId)));
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            exists = EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"));
        }
        if (!exists) {
            startDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.getFirstDateOfSeason((Date)lastMonth));
            endDate = DateUtils.getLastDateOfSeason((Date)DateUtils.getLastDateOfSeason((Date)lastMonth));
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            return result;
        }
        Date currentMonth = now;
        String deadline = TaxDeclareServiceHelper.getOrgLimit(Long.parseLong(orgId));
        if (deadline == null) {
            deadline = TaxDeclareServiceHelper.getOrgLimit(Long.parseLong(orgId));
        }
        if ("aysb".equals(deadline)) {
            startDate = DateUtils.getFirstDateOfMonth((Date)lastMonth);
            endDate = DateUtils.getLastDateOfMonth((Date)lastMonth);
        } else if ("ajsb".equals(deadline)) {
            if (PeriodService.isSameSeason(currentMonth, lastMonth)) {
                Date seasonLastMonth = PeriodService.getBeforeSeasonLastMonth(currentMonth);
                deadline = TaxDeclareServiceHelper.getOrgLimit(Long.parseLong(orgId));
                if ("aysb".equals(deadline)) {
                    startDate = DateUtils.getFirstDateOfMonth((Date)seasonLastMonth);
                    endDate = DateUtils.getLastDateOfMonth((Date)seasonLastMonth);
                } else {
                    startDate = DateUtils.getFirstDateOfSeason((Date)seasonLastMonth);
                    endDate = DateUtils.getLastDateOfSeason((Date)seasonLastMonth);
                }
            } else {
                startDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.getFirstDateOfSeason((Date)lastMonth));
                endDate = DateUtils.getLastDateOfSeason((Date)DateUtils.getLastDateOfSeason((Date)lastMonth));
            }
        }
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        return result;
    }

    public static Map<String, Date> nowTaxPeriod(String orgId, Date now) {
        Date startDate = DateUtils.getFirstDateOfMonth((Date)new Date());
        Date endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        HashMap<String, Date> result = new HashMap<String, Date>();
        if (StringUtils.isBlank((CharSequence)orgId) || now == null) {
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            return result;
        }
        boolean exists = false;
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(orgId)));
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            exists = EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"));
        }
        if (!exists) {
            startDate = DateUtils.getFirstDateOfSeason((Date)now);
            endDate = DateUtils.getLastDateOfSeason((Date)now);
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            return result;
        }
        String deadline = TaxDeclareServiceHelper.getOrgLimit(Long.parseLong(orgId));
        if (deadline == null) {
            deadline = TaxDeclareServiceHelper.getOrgLimit(Long.parseLong(orgId));
        }
        if ("aysb".equals(deadline)) {
            startDate = DateUtils.getFirstDateOfMonth((Date)now);
            endDate = DateUtils.getLastDateOfMonth((Date)now);
        } else if ("ajsb".equals(deadline)) {
            startDate = DateUtils.getFirstDateOfSeason((Date)DateUtils.getFirstDateOfSeason((Date)now));
            endDate = DateUtils.getLastDateOfSeason((Date)DateUtils.getLastDateOfSeason((Date)now));
        }
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        return result;
    }
}

