/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeMiddService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.common.utils.DateRangeUtils;
import kd.taxc.tccit.common.utils.DraftEntityUtils;
import org.apache.commons.lang3.StringUtils;

public class SeasonalCalcSummaryPageService
implements IDraftTypeObserver {
    private static final Log LOGGER = LogFactory.getLog(SeasonalCalcSummaryPageService.class);
    private static final String ITEM_NO = "itemno";
    private static final String SUM_AMOUNT = "sumamount";
    private static final String IS_SMALL_TYPE = "matchsmall";
    private static final String SBBID = "sbbid";
    private static final String EWBLXH = "ewblxh";
    private static final String TCCIT_QYSDS_JDTBXX = "tccit_qysds_jdtbxx";
    private static final ArrayList<String> SPECIAL_EXTENDS = Lists.newArrayList((Object[])new String[]{"12(1)", "12(2)", "12(3)", "12(4)", "12(5)"});
    public static final String TYPE_HEAD = "1";
    public static final String TYPE_BRANCH = "2";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
    private Map<String, List<String>> dynamicItemTypeMap = new HashMap<String, List<String>>(32);

    public Map<String, List<String>> getDynamicItemTypeMap() {
        return this.dynamicItemTypeMap;
    }

    public String getBusinesstype(String orgId, String startDate, String endDate, String draftpurpose) {
        DynamicObject policy = SeasonalPolicyService.getPolicy(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), draftpurpose);
        if (policy == null) {
            return "";
        }
        String declareCompanyType = policy.getString("declaretype");
        if ("100".equals(declareCompanyType) || "220".equals(declareCompanyType) || "230".equals(declareCompanyType)) {
            return TYPE_HEAD;
        }
        if ("210".equals(declareCompanyType)) {
            Boolean smallType = DeclareCompanyTypeService.isSmallType(orgId, startDate, endDate, Boolean.FALSE);
            return smallType != false ? TYPE_HEAD : TYPE_BRANCH;
        }
        if ("311".equals(declareCompanyType)) {
            return "3";
        }
        return "";
    }

    private void setJtynse(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, DynamicObject sub, String row, String entity) {
        Optional<DynamicObject> rowOptional = entryEntity.stream().filter(s -> s.getString(ITEM_NO).equals(row)).findFirst();
        BigDecimal sumAmount = BigDecimal.ZERO;
        if (rowOptional.isPresent()) {
            DynamicObject rowDyo = rowOptional.get();
            sumAmount = rowDyo.getBigDecimal(SUM_AMOUNT);
        }
        sub.set("bqybtse", (Object)sumAmount);
        if ("tccit_sjjt_list".equals(entity)) {
            dynamicObject.set("jtynsesum", (Object)sumAmount);
        }
    }

    private void setFieldValueByRow(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, DynamicObject sub, String row, String entity, String fieldName) {
        Optional<DynamicObject> rowOptional = entryEntity.stream().filter(s -> s.getString(ITEM_NO).equals(row)).findFirst();
        BigDecimal sumAmount = BigDecimal.ZERO;
        if (rowOptional.isPresent()) {
            DynamicObject rowDyo = rowOptional.get();
            sumAmount = rowDyo.getBigDecimal(SUM_AMOUNT);
        }
        sub.set(fieldName, (Object)sumAmount);
    }

    public void updateSeasonalDraftData(Long orgid, Date skssqq, Date skssqz, Map<String, Object> customParams) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        String levytype = (String)customParams.getOrDefault("levytype", "czzs");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        String entity = DraftEntityUtils.getEntityByDraftPurpose((String)customParams.get("draftpurpose"));
        DynamicObject bill = StatusUtils.queryOne((String)"draft_qysdsjb", (String)String.valueOf(orgid), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (String)draftpurpose);
        if (bill != null) {
            DynamicObject sub;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)bill.get("id"), (String)entity);
            String orgId = (String)customParams.get("orgid");
            String startdate = (String)customParams.get("skssqq");
            String enddate = (String)customParams.get("skssqz");
            String businesstype = this.getBusinesstype(orgId, startdate, enddate, draftpurpose);
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
            QFilter typeFilter = new QFilter("type", "=", (Object)(Lists.newArrayList((Object[])new String[]{TYPE_HEAD, TYPE_BRANCH}).contains(businesstype) ? TYPE_HEAD : TYPE_BRANCH));
            DynamicObjectCollection entryEntity = QueryServiceHelper.query((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (String)" * ", (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObject dynamicObject2 = sub = CollectionUtils.isEmpty((Collection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            if ("hdzs".equals(levytype)) {
                this.setJtynse(dynamicObject, entryEntity, sub, "14", entity);
                if ("tccit_sjjt_list".equals(entity)) {
                    this.setFieldValueByRow(dynamicObject, entryEntity, sub, "11", entity, "bqyjtsdse");
                }
            } else {
                this.setJtynse(dynamicObject, entryEntity, sub, "22", entity);
                if ("tccit_sjjt_list".equals(entity)) {
                    this.setFieldValueByRow(dynamicObject, entryEntity, sub, "15", entity, "bqyjtsdse");
                }
                if (TYPE_HEAD.equals(businesstype) || TYPE_BRANCH.equals(businesstype)) {
                    BigDecimal profitamount = entryEntity.stream().filter(s -> s.getString(ITEM_NO).equals("3")).map(s -> s.getBigDecimal(SUM_AMOUNT)).findFirst().orElseGet(() -> BigDecimal.ZERO);
                    sub.set("profitamount", (Object)profitamount);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private String getSbbid(QFilter[] qFilterArr) {
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)" * ", (QFilter[])qFilterArr);
        if (null != temp && temp.size() > 0) {
            return ((DynamicObject)temp.get(0)).getString("id");
        }
        return "";
    }

    private BigDecimal getSum(String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal(alias);
        return result;
    }

    private BigDecimal getAvg(QFilter[] qFilters, String flag, List<String> itemNos) {
        QFilter sbbIdFilter = new QFilter(SBBID, "=", (Object)this.getSbbid(qFilters));
        QFilter itemFilter = new QFilter(EWBLXH, "in", itemNos);
        String field = flag.equals("people") ? "cyrs" : "zcze";
        return this.getSum(TCCIT_QYSDS_JDTBXX, "sum(" + field + ") as " + field + "", new QFilter[]{sbbIdFilter, itemFilter}, field);
    }

    private BigDecimal getCurrentAvg(String orgid, String skssqq, String skssqz, String flag, Map<String, Object> customParams) {
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        if (flag.equals("people")) {
            DynamicObject dynamicObject = SeasonalPolicyService.getPolicy(Long.valueOf(orgid), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), (String)customParams.getOrDefault("draftpurpose", "nssb"));
            BigDecimal result = BigDecimal.ZERO;
            if (dynamicObject == null) {
                return result;
            }
            result = dynamicObject.getBigDecimal("sospersonnum").add(dynamicObject.getBigDecimal("eospersonnum"));
            return result;
        }
        if (flag.equals("assets")) {
            QFilter q1 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
            QFilter q2 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
            QFilter q3 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
            DynamicObjectCollection assetsSummary = QueryServiceHelper.query((String)draftTypeObjectVo.getYjAssets().getNumber(), (String)"bqamount,bjamount", (QFilter[])new QFilter[]{q1, q2, q3});
            BigDecimal result = BigDecimal.ZERO;
            if (CollectionUtils.isEmpty((Collection)assetsSummary)) {
                return result;
            }
            result = assetsSummary.stream().map(s -> s.getBigDecimal("bjamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            return result;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal initAvg(String orgid, String skssqq, String skssqz, String flag, Map<String, Object> customParams) {
        BigDecimal result = BigDecimal.ZERO;
        String quarter = DateRangeUtils.getQuarter(skssqq, skssqz);
        BigDecimal currentAvg = this.getCurrentAvg(orgid, skssqq, skssqz, flag, customParams);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsjb");
        String year = skssqq.substring(0, 4);
        String busRegistrationQuarter = this.getBusRegistrationQuarter(orgid, year);
        if ("quarter1".equals(quarter)) {
            result = currentAvg.divide(new BigDecimal(TYPE_BRANCH), 2, 4);
        } else if ("quarter2".equals(quarter)) {
            BigDecimal sbbAvg = BigDecimal.ZERO;
            BigDecimal divide = new BigDecimal("4");
            if (quarter.equals(busRegistrationQuarter)) {
                divide = new BigDecimal(TYPE_BRANCH);
            } else {
                sbbAvg = this.getAvg(new QFilter[]{orgFilter, DateRangeUtils.getDateQFilter(quarter, year), typeFilter}, flag, DateRangeUtils.getEwblxh(quarter));
            }
            result = sbbAvg.add(currentAvg).divide(divide, 2, 4);
        } else if ("quarter3".equals(quarter)) {
            BigDecimal sbbAvg = BigDecimal.ZERO;
            BigDecimal divide = new BigDecimal("6");
            if (quarter.equals(busRegistrationQuarter)) {
                divide = new BigDecimal(TYPE_BRANCH);
            } else if ("quarter2".equals(busRegistrationQuarter)) {
                sbbAvg = this.getAvg(new QFilter[]{orgFilter, DateRangeUtils.getDateQFilter(quarter, year), typeFilter}, flag, DateRangeUtils.getEwblxh(quarter, busRegistrationQuarter));
                divide = new BigDecimal("4");
            } else {
                sbbAvg = this.getAvg(new QFilter[]{orgFilter, DateRangeUtils.getDateQFilter(quarter, year), typeFilter}, flag, DateRangeUtils.getEwblxh(quarter));
            }
            result = sbbAvg.add(currentAvg).divide(divide, 2, 4);
        } else if ("quarter4".equals(quarter)) {
            BigDecimal sbbAvg = BigDecimal.ZERO;
            BigDecimal divide = new BigDecimal("8");
            if (quarter.equals(busRegistrationQuarter)) {
                divide = new BigDecimal(TYPE_BRANCH);
            } else if ("quarter3".equals(busRegistrationQuarter)) {
                sbbAvg = this.getAvg(new QFilter[]{orgFilter, DateRangeUtils.getDateQFilter(quarter, year), typeFilter}, flag, DateRangeUtils.getEwblxh(quarter, busRegistrationQuarter));
                divide = new BigDecimal("4");
            } else if ("quarter2".equals(busRegistrationQuarter)) {
                sbbAvg = this.getAvg(new QFilter[]{orgFilter, DateRangeUtils.getDateQFilter(quarter, year), typeFilter}, flag, DateRangeUtils.getEwblxh(quarter, busRegistrationQuarter));
                divide = new BigDecimal("6");
            } else {
                sbbAvg = this.getAvg(new QFilter[]{orgFilter, DateRangeUtils.getDateQFilter(quarter, year), typeFilter}, flag, DateRangeUtils.getEwblxh(quarter));
            }
            result = sbbAvg.add(currentAvg).divide(divide, 2, 4);
        }
        return result;
    }

    private String getBusRegistrationQuarter(String orgid, String year) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgid));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            Date registertime = ((DynamicObject)result.getData()).getDate("registertime");
            int yearOfDate = DateUtils.getYearOfDate((Date)registertime);
            if (yearOfDate == Integer.parseInt(year)) {
                return DateRangeUtils.getQuarter(DateUtils.format((Date)registertime), DateUtils.format((Date)registertime));
            }
        } else {
            LOGGER.info("\u83b7\u53d6\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + result.getMessage());
        }
        return "";
    }

    private BigDecimal getProfitSummary(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, QFilter typeFilter, DraftTypeObjectVo draftTypeObjectVo) {
        DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)draftTypeObjectVo.getYjProfits().getNumber(), (String)"id,type,bqfse,bqlje", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, typeFilter});
        return dynamicObjects == null ? BigDecimal.ZERO : dynamicObjects.getBigDecimal("bqlje");
    }

    private BigDecimal getSumCurYearAmount(List<String> rows, String columnType, Long orgid, Date skssqq, Date skssqz, String businesstype, Map<String, Object> customParams) {
        if (CollectionUtils.isEmpty(rows)) {
            return BigDecimal.ZERO;
        }
        rows.stream().map(rowType -> this.getOrElseCalc((String)rowType, columnType, orgid, skssqq, skssqz, businesstype, customParams)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return rows.stream().map(s -> this.dataMap.getOrDefault(this.getKey((String)s, columnType), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    public BigDecimal putDataMap(String rowType, String columnType, BigDecimal amount) {
        if (!"10".equals(rowType) && amount != null) {
            amount = amount.setScale(2, 4);
        }
        this.dataMap.put(this.getKey(rowType, columnType), amount);
        return amount;
    }

    private BigDecimal getOrElseCalc(String rowType, String columnType, Long orgid, Date skssqq, Date skssqz, String businesstype, Map<String, Object> customParams) {
        if (this.dataMap.get(this.getKey(rowType, columnType)) != null || this.dataMap.containsKey(this.getKey(rowType, columnType))) {
            return this.dataMap.get(this.getKey(rowType, columnType));
        }
        return this.getSumAmount(rowType, columnType, orgid, skssqq, skssqz, businesstype, customParams);
    }

    private DynamicObject getSeasonalCalcDet(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, QFilter typeFilter, String type, DraftTypeObjectVo draftTypeObjectVo) {
        QFilter filter = new QFilter("type", "=", (Object)type);
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (String)"id,itemno,itemtype,sumamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, typeFilter, filter});
        return dynamicObjects;
    }

    public void updateData(QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter, String itemNo, BigDecimal amount, String type, DraftTypeObjectVo draftTypeObjectVo) {
        DynamicObject object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)itemNo), type, draftTypeObjectVo);
        if (object != null) {
            object.set(SUM_AMOUNT, (Object)amount);
            SaveServiceHelper.update((DynamicObject)object);
            this.putDataMap(itemNo, SUM_AMOUNT, amount);
        }
    }

    private BigDecimal getApportionSummary(Long orgid, Date skssqq, Date skssqz, DraftTypeObjectVo draftTypeObjectVo) {
        BigDecimal result = BigDecimal.ZERO;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter yearFilter = new QFilter("year", "=", (Object)0);
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter taxorgnameFilter = new QFilter("taxorgname", "like", (Object)ResManager.loadKDString((String)"%\u72ec\u7acb\u751f\u4ea7%", (String)"SeasonalCalcSummaryPageService_0", (String)"taxc-tccit", (Object[])new Object[0]));
        QFilter[] filter = new QFilter[]{orgFilter, yearFilter, startFilter, endFilter, taxorgnameFilter};
        DynamicObject[] summaries = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getApportion().getNumber(), (String)"id,taxorg,taxorgname,taxorgname1,rate", (QFilter[])filter);
        if (summaries != null && summaries.length > 0) {
            result = summaries[0].getBigDecimal("rate");
            result = result.setScale(10, 4);
        }
        return result;
    }

    private String getIndustry(Long fid) {
        DynamicObject industryChild = QueryServiceHelper.queryOne((String)"tpo_tcvat_industrycode", (String)"number,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fid)});
        String number = "";
        if (industryChild.getLong("parent") != 0L) {
            number = this.getIndustry(industryChild.getLong("parent"));
        }
        if (StringUtils.isEmpty((CharSequence)number)) {
            return industryChild.getString("number");
        }
        return number;
    }

    private void saveDataToMidForm(Long orgid, Date skssqq, Date skssqz, String itemName, Long item, String deductiontype, BigDecimal nontaxtotal, DraftTypeObjectVo draftTypeObjectVo) {
        String table = draftTypeObjectVo.getNontaxSummaryM().getNumber();
        DeleteServiceHelper.delete((String)table, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz), new QFilter("ruleid", "=", (Object)Long.parseLong(deductiontype))});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)table, (String)"*", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz), new QFilter("type", "in", (Object)new String[]{TYPE_HEAD, TYPE_BRANCH}), new QFilter("serialno", "in", (Object)new String[]{TYPE_HEAD, TYPE_BRANCH, "3", "4", "5", "21", "22", "23", "24", "25"})});
        DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)table));
        summary.set("org", (Object)orgid);
        summary.set("type", (Object)TYPE_HEAD);
        summary.set("skssqq", (Object)skssqq);
        summary.set("skssqz", (Object)skssqz);
        summary.set("rulename", (Object)itemName);
        summary.set("discounttype", (Object)deductiontype);
        summary.set("ruleid", (Object)deductiontype);
        summary.set("nontaxtotal", (Object)nontaxtotal);
        summary.set("item", (Object)item);
        int size = dynamicObjects.size();
        if (dynamicObjects.size() < 5) {
            summary.set("serialno", (Object)(size + 1));
        } else {
            summary.set("serialno", (Object)(size + 16));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{summary});
    }

    private BigDecimal getDecuctionTotal(Long orgid, Date skssqq, Date skssqz, String declaretype, String deductiontype, Map<String, Object> customParams) {
        Date firstDateOfYearStart = DateUtils.getFirstDateOfYear((Date)skssqq);
        Date firstDateOfYearEnd = DateUtils.getFirstDateOfYear((Date)skssqz);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObject moneyObject = QueryServiceHelper.queryOne((String)"tccit_develop_jjkc", (String)"bndyffyjjkcze,ismanufacturerate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("year", "=", (Object)firstDateOfYearStart), new QFilter("year", "=", (Object)firstDateOfYearEnd), new QFilter("declaretype", "=", (Object)declaretype), new QFilter("deductiontype", "=", (Object)deductiontype)});
        if (moneyObject == null) {
            return BigDecimal.ZERO;
        }
        String industry = "";
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            Long codeandname = ((DynamicObject)result.getData()).getLong("codeandname.id");
            industry = this.getIndustry(codeandname);
        }
        String ismanufacturerate = moneyObject.getString("ismanufacturerate");
        String itemName = "";
        Long item = 0L;
        if (TYPE_HEAD.equals(deductiontype)) {
            if ("C".equals(industry) && TYPE_HEAD.equals(ismanufacturerate)) {
                itemName = ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\uff08\u5236\u9020\u4e1a\u6309 100%\u52a0\u8ba1 \u6263\u9664\uff09", (String)"SeasonalCalcSummaryPageService_1", (String)"taxc-tccit", (Object[])new Object[0]);
                item = 1315279067611882497L;
            } else {
                itemName = ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\uff08\u975e\u5236\u9020\u4e1a\u6309 75%\u52a0 \u8ba1\u6263\u9664\uff09", (String)"SeasonalCalcSummaryPageService_2", (String)"taxc-tccit", (Object[])new Object[0]);
                item = 1315279067611882498L;
            }
        }
        if (TYPE_BRANCH.equals(deductiontype)) {
            itemName = ResManager.loadKDString((String)"\u4f01\u4e1a\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\uff08\u79d1\u6280\u578b\u4e2d\u5c0f\u4f01\u4e1a\u6309100%\u52a0\u8ba1\u6263\u9664\uff09", (String)"SeasonalCalcSummaryPageService_3", (String)"taxc-tccit", (Object[])new Object[0]);
            item = 1554965487501560832L;
        }
        if ("3".equals(deductiontype)) {
            if ("C".equals(industry) && TYPE_HEAD.equals(ismanufacturerate)) {
                itemName = ResManager.loadKDString((String)"\u4f01\u4e1a\u4e3a\u83b7\u5f97\u521b\u65b0\u6027\u3001\u521b\u610f\u6027\u3001\u7a81\u7834\u6027\u7684\u4ea7\u54c1\u8fdb\u884c\u521b\u610f\u8bbe\u8ba1\u6d3b\u52a8\u53d1\u751f\u7684\u76f8\u5173\u8d39\u7528\u52a0\u8ba1\u6263 \u9664\uff08\u5236\u9020\u4e1a\u6309 100%\u52a0\u8ba1\u6263\u9664\uff09", (String)"SeasonalCalcSummaryPageService_4", (String)"taxc-tccit", (Object[])new Object[0]);
                item = 1315279067611882499L;
            } else {
                itemName = ResManager.loadKDString((String)"\u4f01\u4e1a\u4e3a\u83b7\u5f97\u521b\u65b0\u6027\u3001\u521b\u610f\u6027\u3001\u7a81\u7834\u6027\u7684\u4ea7\u54c1\u8fdb\u884c\u521b\u610f\u8bbe\u8ba1\u6d3b\u52a8\u53d1\u751f\u7684\u76f8\u5173\u8d39\u7528\u52a0\u8ba1\u6263 \u9664\uff08\u975e\u5236\u9020\u4e1a\u6309 75%\u52a0\u8ba1\u6263\u9664\uff09", (String)"SeasonalCalcSummaryPageService_5", (String)"taxc-tccit", (Object[])new Object[0]);
                item = 1315279067611882500L;
            }
        }
        this.saveDataToMidForm(orgid, skssqq, skssqz, itemName, item, deductiontype, moneyObject.getBigDecimal("bndyffyjjkcze"), draftTypeObjectVo);
        return moneyObject.getBigDecimal("bndyffyjjkcze");
    }

    private BigDecimal getOne(String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = object != null ? object.getBigDecimal(alias) : BigDecimal.ZERO;
        return result;
    }

    private BigDecimal getRate(String orgId, String code, Date year) {
        String lastDateOfYear;
        String firstDateOfYear = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)year));
        List deductionRateList = AssistService.queryAssistParams((String)code, (String)orgId, (String)firstDateOfYear, (String)(lastDateOfYear = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)year))));
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }

    private BigDecimal getSumFz24(Long orgid, QFilter dateFilter, QFilter typeFilter, QFilter paystatusFilter, String enddate) {
        DynamicObjectCollection collection = OrgGroupService.queryOrgGroupDetailForCollectedOrg("qysds", String.valueOf(orgid), enddate);
        if (collection == null || collection.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List fzOrgIds = collection.stream().map(s -> s.getLong("orgid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "in", fzOrgIds);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter, paystatusFilter});
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return BigDecimal.ZERO;
        }
        QFilter sbbidFilter = new QFilter(SBBID, "in", objects.stream().map(s -> s.getString("id")).collect(Collectors.toList()));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tccit_qysds_zb", (String)"sjyyjsdse,ybtsdse,fsjybsdse", (QFilter[])new QFilter[]{sbbidFilter});
        if (CollectionUtils.isEmpty((Collection)results)) {
            return BigDecimal.ZERO;
        }
        return results.stream().map(s -> s.getBigDecimal("fsjybsdse")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getFpbl(Long orgid, Date skssqq, Date skssqz, String field, Map<String, Object> customParams) {
        DynamicObject policy = SeasonalPolicyService.getPolicy(orgid, skssqq, skssqz, (String)customParams.getOrDefault("draftpurpose", "nssb"));
        return policy != null ? policy.getBigDecimal(field) : BigDecimal.ZERO;
    }

    public DynamicObject findMiddApitude(String itemType, Long orgid, Date skssqq, Date skssqz, String entityName) {
        QFilter typeFilter = new QFilter(ITEM_NO, "=", (Object)String.valueOf(Integer.parseInt(itemType.substring(3, 4))));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        DynamicObject genericObject = QueryServiceHelper.queryOne((String)entityName, (String)"itemname,sumamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, typeFilter});
        return genericObject;
    }

    private Boolean initSmallType(String orgid, String skssqq, String skssqz, BigDecimal row9, Map<String, Object> customParams) {
        BigDecimal people = this.initAvg(orgid, skssqq, skssqz, "people", customParams).setScale(0, 4);
        BigDecimal assets = this.initAvg(orgid, skssqq, skssqz, "assets", customParams).multiply(new BigDecimal("10000"));
        DynamicObject policy = SeasonalPolicyService.getPolicy(Long.parseLong(orgid), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), (String)customParams.getOrDefault("draftpurpose", "nssb"));
        boolean isNotLimit = policy != null ? Boolean.FALSE.equals(policy.getBoolean("illegal")) : false;
        Boolean matchSmallType = isNotLimit && people.compareTo(new BigDecimal("300")) <= 0 && assets.compareTo(new BigDecimal("50000000")) <= 0 && row9.compareTo(new BigDecimal("3000000")) <= 0;
        return matchSmallType;
    }

    public BigDecimal getSumAmount(String rowType, String columnType, Long orgid, Date skssqq, Date skssqz, String businesstype, Map<String, Object> customParams) {
        BigDecimal rowe_1;
        BigDecimal row15;
        BigDecimal row152;
        DynamicObject branchData;
        BigDecimal row17;
        BigDecimal amount;
        BigDecimal amount2;
        Object object;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        ApitudeMiddService apitudeMiddService = new ApitudeMiddService(draftTypeObjectVo);
        if (TYPE_HEAD.equals(rowType)) {
            BigDecimal income = this.getProfitSummary(orgFilter, skssqqFilter, skssqzFilter, new QFilter("type", "=", (Object)"income"), draftTypeObjectVo);
            return this.putDataMap(rowType, columnType, income);
        }
        if (TYPE_BRANCH.equals(rowType)) {
            BigDecimal jcost = this.getProfitSummary(orgFilter, skssqqFilter, skssqzFilter, new QFilter("type", "=", (Object)"jcost"), draftTypeObjectVo);
            return this.putDataMap(rowType, columnType, jcost);
        }
        if ("3".equals(rowType)) {
            BigDecimal profit = this.getProfitSummary(orgFilter, skssqqFilter, skssqzFilter, new QFilter("type", "=", (Object)"profit"), draftTypeObjectVo);
            return this.putDataMap(rowType, columnType, profit);
        }
        if ("4".equals(rowType)) {
            QFilter numberFilter = new QFilter("itemnumber", "=", (Object)"009");
            DynamicObject object2 = QueryServiceHelper.queryOne((String)draftTypeObjectVo.getFdctdywNstz().getNumber(), (String)"sum(bnljje) as bnljje", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, numberFilter});
            return this.putDataMap(rowType, columnType, object2 != null ? object2.getBigDecimal("bnljje") : BigDecimal.ZERO);
        }
        if ("5".equals(rowType) && (object = QueryServiceHelper.queryOne((String)draftTypeObjectVo.getZeroratingin().getNumber(), (String)"sum(zeroratinginamount) as zeroratinginamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter})) != null) {
            return this.putDataMap(rowType, columnType, object.getBigDecimal("zeroratinginamount"));
        }
        if ("6".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(Lists.newArrayList((Object[])new String[]{"6a", "6b", "6c", "6d", "6e"}), columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("6a".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(this.dynamicItemTypeMap.get("6a(X)"), columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("6b".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(this.dynamicItemTypeMap.get("6b(X)"), columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("6c".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(this.dynamicItemTypeMap.get("6c(X)"), columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("6d".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(this.dynamicItemTypeMap.get("6d(X)"), columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("7".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(this.dynamicItemTypeMap.get("7(X)"), columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("8".equals(rowType)) {
            QFilter lineFilter = new QFilter("item", "=", (Object)"item9");
            BigDecimal one = this.getOne(draftTypeObjectVo.getRecoupDeficit().getNumber(), "amount", new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, lineFilter}, "amount");
            this.putDataMap(rowType, columnType, one);
            return one;
        }
        if ("9".equals(rowType)) {
            BigDecimal row3 = this.getOrElseCalc("3", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row4 = this.getOrElseCalc("4", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row5 = this.getOrElseCalc("5", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row6 = this.getOrElseCalc("6", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row7 = this.getOrElseCalc("7", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row8 = this.getOrElseCalc("8", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row9 = row3.add(row4).subtract(row5).subtract(row6).subtract(row7).subtract(row8);
            Boolean type = this.initSmallType(String.valueOf(orgid), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), row9, customParams);
            customParams.put(IS_SMALL_TYPE, type.toString());
            return this.putDataMap(rowType, columnType, row9);
        }
        if ("10".equals(rowType)) {
            BigDecimal rate = new BigDecimal("0.25");
            return this.putDataMap(rowType, columnType, rate);
        }
        if ("11".equals(rowType)) {
            BigDecimal row9 = this.getOrElseCalc("9", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row11 = row9.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row9.multiply(new BigDecimal("0.25"));
            return this.putDataMap(rowType, columnType, row11);
        }
        if ("12".equals(rowType)) {
            amount2 = this.getSumCurYearAmount(SPECIAL_EXTENDS, columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, amount2);
        }
        if ("12(X)".equals(rowType)) {
            Boolean smallType;
            Boolean bl = smallType = customParams.get(IS_SMALL_TYPE) == null ? Boolean.FALSE : Boolean.valueOf(customParams.get(IS_SMALL_TYPE).toString());
            if (!smallType.booleanValue()) {
                QFilter q1 = new QFilter("startdate", "=", (Object)skssqq);
                QFilter q2 = new QFilter("enddate", "=", (Object)skssqz);
                QFilter q3 = new QFilter("orgid", "=", (Object)orgid);
                QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", customParams.getOrDefault("draftpurpose", "nssb"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tccit_seasonal_policy", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
                if (dynamicObject == null) {
                    return BigDecimal.ZERO;
                }
                DynamicObject object3 = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tccit_seasonal_policy"));
                String suittype = object3 == null ? "" : object3.getString("suittype");
                DynamicObjectCollection apitudeEntryEntity = object3 == null ? new DynamicObjectCollection() : object3.getDynamicObjectCollection("apitudeentryentity");
                BigDecimal row9 = this.getOrElseCalc("9", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row10 = this.getOrElseCalc("10", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row11 = this.getOrElseCalc("11", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                if (!CollectionUtils.isEmpty((Collection)apitudeEntryEntity)) {
                    DynamicObjectCollection middApitudeTable = apitudeMiddService.createMiddApitudeTable(skssqq, skssqz, String.valueOf(orgid), apitudeEntryEntity, suittype, row9, row10, row11);
                    if (!CollectionUtils.isEmpty((Collection)middApitudeTable)) {
                        middApitudeTable.stream().forEach(s -> this.putDataMap("12(" + (s.getInt(ITEM_NO) + 1) + ")", SUM_AMOUNT, s.getBigDecimal(SUM_AMOUNT)));
                    }
                } else {
                    apitudeMiddService.clearMiddApitude(orgid, skssqq, skssqz);
                }
            } else {
                amount = BigDecimal.ZERO;
                BigDecimal row9 = this.getOrElseCalc("9", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal xxwRate = this.getRate(String.valueOf(orgid), "XXWQYYHSL", skssqq);
                BigDecimal xwRate = this.getRate(String.valueOf(orgid), "XWQYYHSL", skssqq);
                if (smallType.booleanValue() && row9.compareTo(BigDecimal.ZERO) > 0 && row9.compareTo(new BigDecimal("3000000")) <= 0) {
                    amount = row9.compareTo(new BigDecimal("1000000")) < 0 ? row9.multiply(new BigDecimal("0.25").subtract(xxwRate)).setScale(2, 4) : row9.multiply(new BigDecimal("0.25")).subtract(row9.subtract(new BigDecimal("1000000")).multiply(xwRate)).subtract(new BigDecimal("1000000").multiply(xxwRate)).setScale(2, 4);
                }
                apitudeMiddService.createMiddApitudeTable(skssqq, skssqz, String.valueOf(orgid), amount);
            }
        }
        if (SPECIAL_EXTENDS.contains(rowType)) {
            DynamicObject middApitude = this.findMiddApitude(rowType, orgid, skssqq, skssqz, draftTypeObjectVo.getJmsdMiddApitude().getNumber());
            BigDecimal sumamount = BigDecimal.ZERO;
            if (middApitude != null) {
                sumamount = middApitude.getBigDecimal(SUM_AMOUNT);
            }
            return this.putDataMap(rowType, columnType, sumamount);
        }
        if ("13".equals(rowType)) {
            object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)rowType), TYPE_HEAD, draftTypeObjectVo);
            if (object == null) {
                if ("nssb".equals(draftpurpose)) {
                    QFilter paystatusFilter;
                    QFilter typeFilter;
                    if (DateUtils.format((Date)skssqq).equals(DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)skssqq)))) {
                        return this.putDataMap(rowType, columnType, BigDecimal.ZERO);
                    }
                    List dateList = DateUtils.getPreDate((Date)skssqq, (Date)skssqz);
                    QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)((Date)dateList.get(0))))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)((Date)dateList.get(1))))));
                    DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter = new QFilter("type", "=", (Object)"qysdsjb"), paystatusFilter = new QFilter("paystatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"paid", "nopay"}))});
                    if (CollectionUtils.isEmpty((Collection)objects)) {
                        return this.putDataMap(rowType, columnType, BigDecimal.ZERO);
                    }
                    QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)((DynamicObject)objects.get(0)).getString("id"));
                    DynamicObjectCollection results = QueryServiceHelper.query((String)"tccit_qysds_zb", (String)"sjyyjsdse,ybtsdse,fsjybsdse", (QFilter[])new QFilter[]{sbbidFilter});
                    if (CollectionUtils.isEmpty((Collection)results)) {
                        return this.putDataMap(rowType, columnType, BigDecimal.ZERO);
                    }
                    BigDecimal row13 = ((DynamicObject)results.get(0)).getBigDecimal("sjyyjsdse");
                    BigDecimal row153 = ((DynamicObject)results.get(0)).getBigDecimal("ybtsdse");
                    return this.putDataMap(rowType, columnType, row13.add(row153));
                }
                skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfYear((Date)skssqq));
                int monthDiff = DateUtils.getMonthDiff((Date)skssqz, (Date)skssqq) + 1;
                skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)skssqz, (int)(-monthDiff))));
                DynamicObject sumUpToNow = QueryServiceHelper.queryOne((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (String)"sum(sumamount) as totalamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)"15"), new QFilter("type", "=", (Object)TYPE_HEAD)});
                DynamicObject bddgObj = QueryServiceHelper.queryOne((String)"tccit_citrta_query", (String)"sum(entryentity.btsehj) as totalamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, new QFilter("skssqz", "<", (Object)skssqq), new QFilter("templatetype", "=", (Object)"CITRTA")});
                BigDecimal btse = BigDecimal.ZERO;
                if (bddgObj != null) {
                    btse = bddgObj.getBigDecimal("totalamount");
                }
                if (sumUpToNow == null) {
                    return this.putDataMap(rowType, columnType, BigDecimal.ZERO.add(btse));
                }
                return this.putDataMap(rowType, columnType, sumUpToNow.getBigDecimal("totalamount").add(btse));
            }
            return this.putDataMap(rowType, columnType, object.getBigDecimal(SUM_AMOUNT));
        }
        if (Lists.newArrayList((Object[])new String[]{"14"}).contains(rowType) && (object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)rowType), TYPE_HEAD, draftTypeObjectVo)) != null) {
            amount = object != null ? object.getBigDecimal(SUM_AMOUNT) : BigDecimal.ZERO;
            return this.putDataMap(rowType, columnType, amount);
        }
        if ("15".equals(rowType)) {
            BigDecimal row11 = this.getOrElseCalc("11", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row12 = this.getOrElseCalc("12", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row13 = this.getOrElseCalc("13", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row14 = this.getOrElseCalc("14", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row154 = row11.subtract(row12).subtract(row13).subtract(row14);
            if ("nssb".equals(draftpurpose)) {
                row154 = row154.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : row154;
            }
            return this.putDataMap(rowType, columnType, row154);
        }
        if ("16".equals(rowType)) {
            BigDecimal row16 = BigDecimal.ZERO;
            if (TYPE_BRANCH.equals(businesstype)) {
                BigDecimal row172 = this.getOrElseCalc("17", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row18 = this.getOrElseCalc("18", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row19 = this.getOrElseCalc("19", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                row16 = row172.add(row18).add(row19);
            }
            return this.putDataMap(rowType, columnType, row16);
        }
        if ("17".equals(rowType)) {
            row17 = BigDecimal.ZERO;
            if (TYPE_BRANCH.equals(businesstype)) {
                branchData = this.getGroupScheme(orgid, skssqq);
                row152 = this.getOrElseCalc("15", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                if (null != branchData && branchData.getBoolean("participation")) {
                    row17 = row152.multiply(this.getTotalOrgRate(orgid, draftTypeObjectVo, orgFilter, skssqqFilter, skssqzFilter));
                } else {
                    BigDecimal row17_1 = this.getOrElseCalc("17(1)", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                    row17 = row152.multiply(row17_1);
                }
            }
            return this.putDataMap(rowType, columnType, row17);
        }
        if ("17(1)".equals(rowType)) {
            object = this.getFpbl(orgid, skssqq, skssqz, "zjgftbl", customParams);
            return this.putDataMap(rowType, columnType, (BigDecimal)object);
        }
        if ("18".equals(rowType)) {
            row17 = BigDecimal.ZERO;
            if (TYPE_BRANCH.equals(businesstype)) {
                row15 = this.getOrElseCalc("15", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row18_1 = this.getOrElseCalc("18(1)", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                row17 = row15.multiply(row18_1);
            }
            return this.putDataMap(rowType, columnType, row17);
        }
        if ("18(1)".equals(rowType)) {
            object = this.getFpbl(orgid, skssqq, skssqz, "czjzfpbl", customParams);
            return this.putDataMap(rowType, columnType, (BigDecimal)object);
        }
        if ("19".equals(rowType)) {
            BigDecimal row19 = BigDecimal.ZERO;
            if (TYPE_BRANCH.equals(businesstype)) {
                branchData = this.getGroupScheme(orgid, skssqq);
                row152 = this.getOrElseCalc("15", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal apportionSummary = this.getApportionSummary(orgid, skssqq, skssqz, draftTypeObjectVo);
                if (null != branchData && branchData.getBoolean("participation")) {
                    row19 = row152.multiply(apportionSummary);
                } else {
                    BigDecimal row19_1 = this.getOrElseCalc("19(1)", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                    row19 = row152.multiply(row19_1).multiply(apportionSummary);
                }
            }
            return this.putDataMap(rowType, columnType, row19);
        }
        if ("19(1)".equals(rowType)) {
            object = this.getFpbl(orgid, skssqq, skssqz, "qbfzjgftbl", customParams);
            return this.putDataMap(rowType, columnType, (BigDecimal)object);
        }
        if ("19(2)".equals(rowType)) {
            BigDecimal row19_2 = BigDecimal.ZERO;
            if (TYPE_BRANCH.equals(businesstype)) {
                BigDecimal apportionSummary;
                row19_2 = apportionSummary = this.getApportionSummary(orgid, skssqq, skssqz, draftTypeObjectVo);
            }
            return this.putDataMap(rowType, columnType, row19_2);
        }
        if ("20".equals(rowType)) {
            object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)rowType), TYPE_HEAD, draftTypeObjectVo);
            if (object == null) {
                QFilter typeFilter = new QFilter("entryentity.project", "=", (Object)1117362391177236484L);
                Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqq);
                Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)skssqq);
                QFilter yearFilter = new QFilter("year", ">=", (Object)firstDateOfYear).and(new QFilter("year", "<=", (Object)lastDateOfYear));
                DynamicObject dyo = QueryServiceHelper.queryOne((String)"tccit_other_deductions", (String)"entryentity.jmbl", (QFilter[])new QFilter[]{orgFilter, typeFilter, yearFilter});
                BigDecimal decimal = BigDecimal.ZERO;
                if (dyo != null && dyo.getBigDecimal("entryentity.jmbl") != null) {
                    decimal = dyo.getBigDecimal("entryentity.jmbl");
                }
                return this.putDataMap(rowType, columnType, decimal);
            }
            return this.putDataMap(rowType, columnType, object.getBigDecimal(SUM_AMOUNT));
        }
        if ("21".equals(rowType)) {
            BigDecimal row21 = BigDecimal.ZERO;
            row15 = this.getOrElseCalc("15", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row16 = this.getOrElseCalc("16", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row173 = this.getOrElseCalc("17", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row19 = this.getOrElseCalc("19", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row20 = this.getOrElseCalc("20", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            if (TYPE_HEAD.equals(businesstype)) {
                row21 = row15.multiply(new BigDecimal("0.4")).multiply(row20);
            } else if (TYPE_BRANCH.equals(businesstype)) {
                row21 = row173.add(row19).multiply(new BigDecimal("0.4")).multiply(row20);
            }
            return this.putDataMap(rowType, columnType, row21);
        }
        if ("22".equals(rowType)) {
            BigDecimal row21;
            BigDecimal row22 = BigDecimal.ZERO;
            if (TYPE_HEAD.equals(businesstype)) {
                row15 = this.getOrElseCalc("15", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                row21 = this.getOrElseCalc("21", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                row22 = row15.subtract(row21);
            } else if (TYPE_BRANCH.equals(businesstype)) {
                BigDecimal row16 = this.getOrElseCalc("16", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                row21 = this.getOrElseCalc("21", columnType, orgid, skssqq, skssqz, businesstype, customParams);
                row22 = row16.subtract(row21);
            }
            return this.putDataMap(rowType, columnType, row22);
        }
        if ("6e(1)".equals(rowType)) {
            rowe_1 = this.getDecuctionTotal(orgid, skssqq, skssqz, TYPE_HEAD, TYPE_HEAD, customParams);
            return this.putDataMap(rowType, columnType, rowe_1);
        }
        if ("6e(2)".equals(rowType)) {
            BigDecimal rowe_2 = this.getDecuctionTotal(orgid, skssqq, skssqz, TYPE_HEAD, "3", customParams);
            return this.putDataMap(rowType, columnType, rowe_2);
        }
        if ("6e(3)".equals(rowType)) {
            BigDecimal rowe_3 = this.getDecuctionTotal(orgid, skssqq, skssqz, TYPE_HEAD, TYPE_BRANCH, customParams);
            return this.putDataMap(rowType, columnType, rowe_3);
        }
        if ("6e".equals(rowType)) {
            rowe_1 = this.getOrElseCalc("6e(1)", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal rowe_2 = this.getOrElseCalc("6e(2)", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal rowe_3 = this.getOrElseCalc("6e(3)", columnType, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, columnType, rowe_1.add(rowe_2).add(rowe_3));
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getTotalOrgRate(Long orgid, DraftTypeObjectVo draftTypeObjectVo, QFilter orgFilter, QFilter skssqqFilter, QFilter skssqzFilter) {
        QFilter yearFilter = new QFilter("year", "=", (Object)0);
        QFilter taxorgFilter = new QFilter("taxorg", "=", (Object)orgid);
        DynamicObject rateObj = QueryServiceHelper.queryOne((String)draftTypeObjectVo.getApportion().getNumber(), (String)"rate", (QFilter[])new QFilter[]{orgFilter, yearFilter, skssqqFilter, skssqzFilter, taxorgFilter});
        return rateObj == null ? BigDecimal.ZERO : rateObj.getBigDecimal("rate");
    }

    private DynamicObject getGroupScheme(Long orgid, Date skssqq) {
        Date startyear = DateUtils.getFirstDateOfYear((Date)skssqq);
        Date endyear = DateUtils.getLastDateOfYear((Date)skssqq);
        QFilter filter = QFilter.of((String)"org.id = ? and period >= ? and period <= ? and declaration = ?", (Object[])new Object[]{orgid, startyear, endyear, TYPE_BRANCH});
        return QueryServiceHelper.queryOne((String)"tccit_branch_share_bill", (String)"participation", (QFilter[])new QFilter[]{filter});
    }

    public BigDecimal hdzsCalc(String rowType, Long orgid, Date skssqq, Date skssqz, DraftTypeObjectVo draftTypeObjectVo, String businesstype, Map<String, Object> customParams) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter startdateFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter enddateFilter = new QFilter("enddate", "=", (Object)skssqz);
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        if (TYPE_HEAD.equals(rowType)) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjProfits().getNumber(), (String)"id,type,bqfse,bqlje", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, new QFilter("type", "=", (Object)"grossincome")});
            BigDecimal bqlje = Arrays.stream(dynamicObjects).map(e -> e.getBigDecimal("bqlje")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            return this.putDataMap(rowType, SUM_AMOUNT, bqlje);
        }
        if (TYPE_BRANCH.equals(rowType)) {
            DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_zeroratingin_sum", (String)"sum(zeroratinginamount) as zeroratinginamount", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
            if (object != null) {
                return this.putDataMap(rowType, SUM_AMOUNT, object.getBigDecimal("zeroratinginamount"));
            }
            return this.putDataMap(rowType, SUM_AMOUNT, BigDecimal.ZERO);
        }
        if ("3".equals(rowType)) {
            BigDecimal row3 = this.getSumCurYearAmount(this.dynamicItemTypeMap.get("3.X"), SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, SUM_AMOUNT, row3);
        }
        DynamicObject policyObject = QueryServiceHelper.queryOne((String)"tccit_seasonal_policy", (String)"checkcollectway,taxableincomerate", (QFilter[])new QFilter[]{orgidFilter, startdateFilter, enddateFilter, draftpurposeFilter});
        if ("4".equals(rowType) && Objects.nonNull(policyObject)) {
            if ("rate-income".equals(policyObject.getString("checkcollectway"))) {
                BigDecimal row1 = this.getOrElseCalc(TYPE_HEAD, SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row2 = this.getOrElseCalc(TYPE_BRANCH, SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row3 = this.getOrElseCalc("3", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
                return this.putDataMap(rowType, SUM_AMOUNT, row1.subtract(row2).subtract(row3));
            }
            if ("rate-cost".equals(policyObject.getString("checkcollectway"))) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjProfits().getNumber(), (String)"id,type,bqfse,bqlje", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, new QFilter("type", "=", (Object)"totalcost")});
                BigDecimal bqlje = Arrays.stream(dynamicObjects).map(e -> e.getBigDecimal("bqlje")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                return this.putDataMap(rowType, SUM_AMOUNT, bqlje);
            }
        }
        if ("5".equals(rowType)) {
            return this.putDataMap(rowType, SUM_AMOUNT, Objects.nonNull(policyObject) ? policyObject.getBigDecimal("taxableincomerate") : BigDecimal.ZERO);
        }
        if ("6".equals(rowType)) {
            BigDecimal row6 = BigDecimal.ZERO;
            if (Objects.nonNull(policyObject)) {
                BigDecimal row4 = this.getOrElseCalc("4", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
                BigDecimal row5 = this.getOrElseCalc("5", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
                if ("rate-income".equals(policyObject.getString("checkcollectway"))) {
                    row6 = row4.multiply(row5);
                }
                if ("rate-cost".equals(policyObject.getString("checkcollectway"))) {
                    row6 = row4.divide(BigDecimal.ONE.subtract(row5), 2, RoundingMode.HALF_UP).multiply(row5);
                }
            }
            Boolean type = this.initSmallType(String.valueOf(orgid), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), row6, customParams);
            customParams.put(IS_SMALL_TYPE, type.toString());
            return this.putDataMap(rowType, SUM_AMOUNT, row6);
        }
        if ("7".equals(rowType)) {
            String rate = this.getSmallRate(skssqq, skssqz, "SYSL");
            BigDecimal row7 = new BigDecimal(rate).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
            return this.putDataMap(rowType, SUM_AMOUNT, row7);
        }
        if ("8".equals(rowType)) {
            BigDecimal row6 = this.getOrElseCalc("6", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row7 = this.getOrElseCalc("7", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            return this.putDataMap(rowType, SUM_AMOUNT, row6.multiply(row7));
        }
        if ("9".equals(rowType)) {
            BigDecimal row6 = this.getOrElseCalc("6", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row9 = BigDecimal.ZERO;
            if (row6.compareTo(BigDecimal.ZERO) > 0 && row6.compareTo(new BigDecimal("3000000")) <= 0) {
                String xxwqyyhsl = this.getSmallRate(skssqq, skssqz, "XXWQYYHSL");
                String xwqyyhsl = this.getSmallRate(skssqq, skssqz, "XWQYYHSL");
                if (row6.compareTo(new BigDecimal("1000000")) <= 0) {
                    row9 = row6.multiply(new BigDecimal("0.25").subtract(new BigDecimal(xxwqyyhsl)));
                    return this.putDataMap(rowType, SUM_AMOUNT, row9);
                }
                row9 = row6.multiply(new BigDecimal("0.25")).subtract(row6.subtract(new BigDecimal("1000000"))).multiply(new BigDecimal(xwqyyhsl)).subtract(new BigDecimal("1000000").multiply(new BigDecimal(xxwqyyhsl)));
            }
            return this.putDataMap(rowType, SUM_AMOUNT, row9);
        }
        if ("10".equals(rowType)) {
            DynamicObject object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)rowType), TYPE_HEAD, draftTypeObjectVo);
            if (Objects.isNull(object)) {
                BigDecimal row10 = this.getLastPeriodData(orgid, skssqq, skssqz);
                return this.putDataMap(rowType, SUM_AMOUNT, row10);
            }
            return this.putDataMap(rowType, SUM_AMOUNT, object.getBigDecimal(SUM_AMOUNT));
        }
        if ("11".equals(rowType)) {
            BigDecimal row8 = this.getOrElseCalc("8", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row9 = this.getOrElseCalc("9", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row10 = this.getOrElseCalc("10", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal subtract = row8.subtract(row9).subtract(row10);
            BigDecimal row11 = subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO;
            return this.putDataMap(rowType, SUM_AMOUNT, row11);
        }
        if ("12".equals(rowType)) {
            DynamicObject object = this.getSeasonalCalcDet(orgFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)rowType), TYPE_HEAD, draftTypeObjectVo);
            if (Objects.isNull(object)) {
                return this.putDataMap(rowType, SUM_AMOUNT, BigDecimal.ZERO);
            }
            return this.putDataMap(rowType, SUM_AMOUNT, object.getBigDecimal(SUM_AMOUNT));
        }
        if ("13".equals(rowType)) {
            BigDecimal row11 = this.getOrElseCalc("11", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal row12 = this.getOrElseCalc("12", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal multiply = row11.multiply(row12).multiply(new BigDecimal("0.4"));
            return this.putDataMap(rowType, SUM_AMOUNT, multiply);
        }
        if ("14".equals(rowType)) {
            BigDecimal row13;
            BigDecimal row11 = this.getOrElseCalc("11", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams);
            BigDecimal subtract = row11.subtract(row13 = this.getOrElseCalc("13", SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams));
            return this.putDataMap(rowType, SUM_AMOUNT, subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    private String getSmallRate(Date skssqq, Date skssqz, String number) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1 as value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("entryentity.startdate", "<=", (Object)skssqq), new QFilter("entryentity.enddate", ">=", (Object)skssqz).or("entryentity.enddate", "is null", null)});
        return object.getString("value");
    }

    private BigDecimal getLastPeriodData(Long orgid, Date skssqq, Date skssqz) {
        int monthOfDate = DateUtils.getMonthOfDate((Date)skssqz);
        if (3 == monthOfDate) {
            return BigDecimal.ZERO;
        }
        Date startDate = DateUtils.addMonth((Date)skssqq, (int)-3);
        Date endDate = DateUtils.addMonth((Date)skssqz, (int)-3);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{new QFilter("skssqq", "=", (Object)startDate), new QFilter("skssqz", "=", (Object)endDate), new QFilter("org", "=", (Object)orgid), new QFilter("type", "=", (Object)"qysds_hdzs_jb"), new QFilter("paystatus", "in", Arrays.asList("paid", "nopay", "partpaid"))});
        if (Objects.isNull(object)) {
            return BigDecimal.ZERO;
        }
        String id = object.getString("id");
        DynamicObject hsqjsbbObj = QueryServiceHelper.queryOne((String)"tccit_hsqjsbb_b_2018", (String)"jsjynsd,mzzzdfqydffxbf", (QFilter[])new QFilter[]{new QFilter(SBBID, "=", (Object)id)});
        if (Objects.isNull(hsqjsbbObj)) {
            return BigDecimal.ZERO;
        }
        BigDecimal jsjynsd = hsqjsbbObj.getBigDecimal("jsjynsd");
        BigDecimal mzzzdfqydffxbf = hsqjsbbObj.getBigDecimal("mzzzdfqydffxbf");
        return jsjynsd.add(mzzzdfqydffxbf);
    }

    private BigDecimal getSumQysdsZjgxx(String sbbid, String column, String name) {
        QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)sbbid);
        QFilter nameFilter = new QFilter("fzjgmc", "=", (Object)name);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tccit_qysds_fzjgxx_dyn", (String)column, (QFilter[])new QFilter[]{sbbidFilter, nameFilter});
        return dynamicObject == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal(column);
    }

    public BigDecimal branchCalc(String rowType, String columnType, Long orgid, Date skssqq, Date skssqz, DraftTypeObjectVo draftTypeObjectVo) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)orgid);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        if (TYPE_HEAD.equals(rowType)) {
            QFilter orgFilter = new QFilter("taxorg", "=", (Object)orgid);
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)draftTypeObjectVo.getApportion().getNumber(), (String)"rate", (QFilter[])new QFilter[]{orgFilter, dateFilter});
            BigDecimal row1 = BigDecimal.ZERO;
            if (dynamicObject != null) {
                row1 = dynamicObject.getBigDecimal("rate");
            }
            return this.putDataMap(rowType, columnType, row1);
        }
        if (TYPE_BRANCH.equals(rowType)) {
            DynamicObject orgGroup = DeclareCompanyTypeService.getOrgGroup(String.valueOf(orgid), DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            if (orgGroup == null) {
                return BigDecimal.ZERO;
            }
            String parentId = orgGroup.getString("parentid");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(parentId));
            QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsjb");
            QFilter skssqqfilter = new QFilter("skssqq", "=", (Object)skssqq);
            QFilter skssqzfilter = new QFilter("skssqz", "=", (Object)skssqz);
            BigDecimal row2 = this.getSumQysdsZjgxx(this.getSbbid(new QFilter[]{orgFilter, typeFilter, skssqqfilter, skssqzfilter}), "fpse", orgGroup.getString("orgname"));
            return this.putDataMap(rowType, columnType, row2);
        }
        if ("3".equals(rowType)) {
            DynamicObject object = this.getSeasonalCalcDet(orgIdFilter, skssqqFilter, skssqzFilter, new QFilter("itemtype", "=", (Object)rowType), TYPE_BRANCH, draftTypeObjectVo);
            BigDecimal amount = object != null ? object.getBigDecimal(SUM_AMOUNT) : BigDecimal.ZERO;
            return this.putDataMap(rowType, columnType, amount);
        }
        if ("4".equals(rowType)) {
            BigDecimal row2 = this.dataMap.getOrDefault(this.getKey(TYPE_BRANCH, columnType), BigDecimal.ZERO);
            BigDecimal row3 = this.dataMap.getOrDefault(this.getKey("3", columnType), BigDecimal.ZERO);
            BigDecimal row4 = row2.multiply(new BigDecimal("0.4")).multiply(row3);
            return this.putDataMap(rowType, columnType, row4);
        }
        if ("5".equals(rowType)) {
            BigDecimal row5 = BigDecimal.ZERO;
            BigDecimal row3 = this.dataMap.getOrDefault(this.getKey("3", columnType), BigDecimal.ZERO);
            if (row3.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal row2 = this.dataMap.getOrDefault(this.getKey(TYPE_BRANCH, columnType), BigDecimal.ZERO);
                BigDecimal row4 = this.dataMap.getOrDefault(this.getKey("4", columnType), BigDecimal.ZERO);
                row5 = row2.subtract(row4);
            }
            return this.putDataMap(rowType, columnType, row5);
        }
        return BigDecimal.ZERO;
    }

    public DynamicObjectCollection getDynamicRows(String s, Map<String, Object> customParams) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        Object orgid = customParams.get("orgid");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        if (s.equals("6a(X)")) {
            QFilter filter = new QFilter("nontaxtotal", ">", (Object)0);
            DynamicObjectCollection nontaxSummary = QueryServiceHelper.query((String)draftTypeObjectVo.getYjNontax().getNumber(), (String)"rule.name as name ,nontaxtotal as total", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter});
            return nontaxSummary;
        }
        if (s.equals("6b(X)")) {
            QFilter filter = new QFilter("treducedtotal", ">", (Object)0);
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)draftTypeObjectVo.getYjTreduced().getNumber(), (String)"rule.name as name,treducedtotal as total", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter});
            return genericObjects;
        }
        if (s.equals("6c(X)")) {
            QFilter filter = new QFilter("incredtotal", ">", (Object)0);
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)draftTypeObjectVo.getYjIncred().getNumber(), (String)"rule.name as name,incredtotal as total", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter});
            return genericObjects;
        }
        if (s.equals("6d(X)")) {
            QFilter filter = new QFilter("nontaxtotal", ">", (Object)0);
            QFilter type = new QFilter("type", "=", (Object)"4");
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (String)"rulename as name,nontaxtotal as total", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter, type});
            return genericObjects;
        }
        if (s.equals("6e(X)")) {
            QFilter filter = new QFilter("nontaxtotal", ">", (Object)0);
            QFilter type = new QFilter("type", "=", (Object)"5");
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (String)"rulename as name,nontaxtotal as total", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter, type}, (String)"serialno");
            return genericObjects;
        }
        if (s.equals("7(X)")) {
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)draftTypeObjectVo.getAssertAcce().getNumber(), (String)"rule.name as name,xsjszjyhjsdzjje,zzzjje,xsjszjyhjsdzjje as total ", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong((String)orgid)), startFilter, endFilter});
            if (!CollectionUtils.isEmpty((Collection)genericObjects)) {
                genericObjects.removeIf(obj -> obj.getBigDecimal("xsjszjyhjsdzjje").subtract(obj.getBigDecimal("zzzjje")).compareTo(BigDecimal.ZERO) <= 0);
                for (DynamicObject genericObject : genericObjects) {
                    BigDecimal subtract = genericObject.getBigDecimal("xsjszjyhjsdzjje").subtract(genericObject.getBigDecimal("zzzjje"));
                    genericObject.set("total", (Object)subtract);
                }
            }
            return genericObjects;
        }
        if ("3.X".equals(s)) {
            QFilter nontaxtotal = new QFilter("nontaxtotal", ">", (Object)0);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)draftTypeObjectVo.getYjNontax().getNumber(), (String)"nontaxtotal,rule", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, nontaxtotal});
            DynamicObjectCollection collection = new DynamicObjectCollection();
            Collections.addAll(collection, load);
            return collection;
        }
        return result;
    }

    public void recordDynamicRows(String itemType, String dynamicitemtype) {
        List<String> list = this.dynamicItemTypeMap.get(itemType);
        if (CollectionUtils.isEmpty(list)) {
            this.dynamicItemTypeMap.put(itemType, Lists.newArrayList((Object[])new String[]{dynamicitemtype}));
        } else if (!list.contains(dynamicitemtype)) {
            list.add(dynamicitemtype);
            this.dynamicItemTypeMap.put(itemType, list);
        }
    }

    public DynamicObject[] queryCurrentPeriod(Map<String, Object> customParams, String type) {
        QFilter filter = this.buildQueryCurrentPeriodFilter(customParams, type);
        DynamicObjectCollection sum = this.queryCurrentPeriodCollection(customParams, filter);
        return (DynamicObject[])sum.toArray((Object[])new DynamicObject[0]);
    }

    public DynamicObjectCollection queryCurrentPeriodByItemNo(Map<String, Object> customParams, String type, String itemNO) {
        QFilter filter = this.buildQueryCurrentPeriodFilter(customParams, type);
        filter.and(new QFilter(ITEM_NO, "=", (Object)itemNO));
        return this.queryCurrentPeriodCollection(customParams, filter);
    }

    public DynamicObjectCollection queryCurrentPeriodCollection(Map<String, Object> customParams, QFilter filter) {
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        return QueryServiceHelper.query((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (String)"id,itemno,itemtype,sumamount,mypkid,myparentid,org,skssqq,skssqz,name,type,issmall", (QFilter[])new QFilter[]{filter}, (String)"mypkid");
    }

    private QFilter buildQueryCurrentPeriodFilter(Map<String, Object> customParams, String type) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter typeFilter = new QFilter("type", "=", (Object)type);
        return orgFilter.and(dateFilter).and(typeFilter);
    }

    public void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz, String entityName, String type) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        QFilter typeFilter = new QFilter("type", "=", (Object)type);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
    }
}

