/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.sbb.SbbQueryService;

public class TaxPayService {
    private static final Map<String, String> FETCH_SBB_MAP = new LinkedHashMap<String, String>();

    public static BigDecimal getBqlje(DynamicObject policy, String type, BigDecimal bqfse, BigDecimal sqlje, String draftPurpose) {
        if (policy == null) {
            return BigDecimal.ZERO;
        }
        String residenttype = policy.getString("residenttype");
        String levytype = policy.getString("levytype");
        String yjprofitslogic = policy.getString("yjprofitslogic");
        String orgId = Optional.ofNullable(policy.getString("orgid.id")).orElseGet(() -> policy.getString("orgid"));
        Date startdate = policy.getDate("startdate");
        Date enddate = policy.getDate("enddate");
        String checkcollectway = policy.getString("checkcollectway");
        if ("jmqy".equals(residenttype) && "czzs".equals(levytype)) {
            if ("bqfse".equals(yjprofitslogic)) {
                if ("nssb".equals(draftPurpose)) {
                    String lastSbbId = TaxPayService.getLastSbbId(orgId, "qysdsjb", startdate, enddate);
                    BigDecimal lrze = SbbQueryService.getQysdsZb(lastSbbId, FETCH_SBB_MAP.get(type));
                    return lrze.add(bqfse);
                }
                if ("sjjt".equals(draftPurpose)) {
                    return BigDecimalUtil.addObject((Object)bqfse, (Object)sqlje);
                }
            } else if ("bnlje".equals(yjprofitslogic)) {
                return bqfse;
            }
        } else if ("hdzs".equals(levytype)) {
            if ("bqfse".equals(yjprofitslogic)) {
                if ("nssb".equals(draftPurpose)) {
                    if ("011".equals(type)) {
                        String lastSbbId = TaxPayService.getLastSbbId(orgId, "qysds_hdzs_jb", startdate, enddate);
                        BigDecimal srze = SbbQueryService.getHdzs2018Zb(lastSbbId, "srze");
                        return srze.add(bqfse);
                    }
                    if ("012".equals(type)) {
                        if ("rate-cost".equals(checkcollectway)) {
                            String lastSbbId = TaxPayService.getLastSbbId(orgId, "qysds_hdzs_jb", startdate, enddate);
                            BigDecimal yssrecycbfyze = SbbQueryService.getHdzs2018Zb(lastSbbId, "yssrecycbfyze");
                            return yssrecycbfyze.add(bqfse);
                        }
                        return BigDecimalUtil.addObject((Object)bqfse, (Object)sqlje);
                    }
                } else if ("sjjt".equals(draftPurpose)) {
                    return BigDecimalUtil.addObject((Object)bqfse, (Object)sqlje);
                }
            } else if ("bnlje".equals(yjprofitslogic)) {
                return bqfse;
            }
        }
        return BigDecimal.ZERO;
    }

    public static String getLastSbbId(String orgid, String type, Date startdate, Date enddate) {
        int monthDiff = DateUtils.getMonthDiff((Date)startdate, (Date)enddate);
        Date skssqz = DateUtils.addDay((Date)startdate, (int)-1);
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)skssqz, (int)(-monthDiff + 1)));
        if (DateUtils.getYearOfDate((Date)startdate) != DateUtils.getYearOfDate((Date)skssqq)) {
            return "0";
        }
        return YbnsrService.queryYbnsrPre((String)orgid, (String)type, (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (int)0);
    }

    static {
        FETCH_SBB_MAP.put("011", "yysr");
        FETCH_SBB_MAP.put("012", "yycb");
        FETCH_SBB_MAP.put("013", "lrze");
    }
}

