/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.org.OrgWithFinanceService;

public class TypesProviderService {
    private static final String FIELDS_INCOME = "income1,income2,income3,income5,income6,income7,income8,income9";
    private static final String FIELDS_DEDUCT = "incomeother,deduct2,deduct3,deduct5,deduct6,deduct9,deduct10,deduct11,deduct12,deduct16,assetexpense";
    private static final String FIELDS_ASSET = "asset1,asset2,asset3";
    private static final String FIELDS_TSSX = "other1,income4,other2,deduct4,dksszbjtz,tssx1,spectz,other4";
    private static final String FIELDS_YHSX = "yhsx1,yhsx2,yhsx3,yhsx4,other5,yhsx5,taxcredit,other8";

    public static DynamicObjectCollection getTypes(DynamicObject policy, Object category, String type, String orderBys) {
        List<String> filters = TypesProviderService.getFilters(policy);
        QFilter filter = null;
        for (String f : filters) {
            if (filter == null) {
                filter = QFilter.like((String)"filter", (String)f);
                continue;
            }
            filter = filter.or(QFilter.like((String)"filter", (String)f));
        }
        QFilter mustFilter = new QFilter("filter", "=", (Object)"mustshow");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(mustFilter.or(filter));
        QFilter typeFilter = new QFilter("type", "=", (Object)type);
        list.add(typeFilter);
        if (category != null) {
            QFilter categoryFilter = new QFilter("category", "=", category);
            list.add(categoryFilter);
        }
        return QueryServiceHelper.query((String)"tpo_qysds_types", (String)"id,title,number,parent", (QFilter[])list.toArray(new QFilter[0]), (String)orderBys);
    }

    private static List<String> getFilters(DynamicObject policy) {
        ArrayList<String> filters = new ArrayList<String>();
        if (OrgWithFinanceService.isSydw(policy)) {
            filters.add("nonbizunit");
        } else if (OrgWithFinanceService.isFinance(policy)) {
            filters.add("finance");
        } else if (OrgWithFinanceService.isYbqy(policy)) {
            filters.add("general");
        }
        if (policy.getBoolean("deduct6") && policy.getDynamicObject("codeandname") != null) {
            DynamicObject codeandname = BusinessDataServiceHelper.loadSingle((Object)policy.getDynamicObject("codeandname").getLong("id"), (String)"tpo_tcvat_industrycode");
            String longnumber1 = codeandname.getString("longnumber");
            if (longnumber1 != null && longnumber1.startsWith("322.364")) {
                filters.add("codeandname-68");
            } else {
                filters.add("codeandname-!68");
            }
        }
        String declaretype = policy.getString("declaretype");
        filters.add("declaretype-" + declaretype);
        DynamicObjectCollection apitudeentryentity = policy.getDynamicObjectCollection("apitudeentryentity");
        Boolean show = ApitudeService.show(apitudeentryentity, policy.getDate("startdate"), policy.getDate("enddate"));
        if (show.booleanValue()) {
            filters.add("high-tech");
        }
        if (StringUtils.isNotBlank((CharSequence)policy.getString("softtype"))) {
            filters.add("soft-ic");
        } else {
            QFilter sheetFilter;
            QFilter dateFilter;
            QFilter orgFilter = new QFilter("orgid", "=", (Object)policy.getDynamicObject("orgid").getLong("id"));
            if (QueryServiceHelper.exists((String)"tccit_getredu_sum", (QFilter[])new QFilter[]{orgFilter, dateFilter = new QFilter("skssqq", "=", (Object)policy.getDate("startdate")).and(new QFilter("skssqz", "=", (Object)policy.getDate("enddate"))), sheetFilter = new QFilter("reducename", "in", (Object)Lists.newArrayList((Object[])new Long[]{1119507313238005760L, 1119510373058271232L, 1119510373058271233L, 1119522899774986240L}))})) {
                filters.add("soft-ic");
            }
        }
        if (policy.getBoolean("deduct1")) {
            filters.add("deduct-1");
        }
        String fields = String.join((CharSequence)",", FIELDS_INCOME, FIELDS_DEDUCT, FIELDS_ASSET, FIELDS_TSSX, FIELDS_YHSX);
        for (String field : fields.split(",")) {
            if (!policy.getBoolean(field)) continue;
            filters.add(field);
        }
        return filters;
    }
}

