/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.business.sbb.SbbQueryService;

public class YearCalcSummaryPageService {
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String CUR_YEAR_AMOUNT = "curyearamount";
    private static final String PRE_YEAR_AMOUNT = "preyearamount";
    private Map<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();

    public DynamicObjectCollection getCalcSummary(Long orgId, Date skssqq, Date skssqz) {
        QFilter q1 = new QFilter("orgid", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter q3 = new QFilter("skssqz", "=", (Object)skssqz);
        return QueryServiceHelper.query((String)"tccit_calc_summary_detail", (String)"itemno,itemtype,curyearamount,preyearamount,increase", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public Map<String, BigDecimal> getPerYearCalcSummary(Long orgId, Date startDate, Date endDate) {
        Date skssqz;
        Date skssqq = DateUtils.addYear((Date)startDate, (int)-1);
        DynamicObjectCollection calcSummary = this.getCalcSummary(orgId, skssqq, skssqz = DateUtils.addYear((Date)endDate, (int)-1));
        if (CollectionUtils.isEmpty((Collection)calcSummary)) {
            return new HashMap<String, BigDecimal>(16);
        }
        return calcSummary.stream().collect(Collectors.toMap(s -> s.getString(ITEM_NO), s -> s.getBigDecimal(CUR_YEAR_AMOUNT), (m, n) -> n));
    }

    public void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)"tccit_calc_summary_detail", (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    public void updateYearDraftData(DynamicObject[] save, Long orgid, Date skssqq, Date skssqz) {
        DynamicObject dynamicObject = DraftService.getYearDgBill(orgid, skssqq, skssqz);
        if (dynamicObject != null) {
            DynamicObject row21 = Arrays.stream(save).filter(s -> s.getString(ITEM_NO).equals("21")).findFirst().get();
            DynamicObject row22 = Arrays.stream(save).filter(s -> s.getString(ITEM_NO).equals("22")).findFirst().get();
            DynamicObject row23 = Arrays.stream(save).filter(s -> s.getString(ITEM_NO).equals("23")).findFirst().get();
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObject sub = CollectionUtils.isEmpty((Collection)entryentity) ? entryentity.addNew() : (DynamicObject)entryentity.get(0);
            sub.set("taxamount", (Object)row21.getBigDecimal(CUR_YEAR_AMOUNT));
            sub.set("sumpaytaxamount", (Object)row22.getBigDecimal(CUR_YEAR_AMOUNT));
            sub.set("bnybtsdse", (Object)row23.getBigDecimal(CUR_YEAR_AMOUNT));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private String getKey(String rowType, String columnType) {
        return rowType + "&" + columnType;
    }

    private BigDecimal getOne(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = object != null ? object.getBigDecimal(alias) : BigDecimal.ZERO;
        this.dataMap.put(this.getKey(rowType, columnType), result);
        return result;
    }

    private BigDecimal getSum(String rowType, String columnType, String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal(alias);
        this.dataMap.put(this.getKey(rowType, columnType), result);
        return result;
    }

    private BigDecimal getSumCurYearAmount(String columnType, List<String> rows) {
        return rows.stream().map(s -> this.dataMap.getOrDefault(this.getKey((String)s, columnType), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String getCurrentYearSbbid(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        return SbbQueryService.getSbbidStr(skssqq, skssqz, orgid, "qysdsnb_dg");
    }

    public BigDecimal calcCell(String rowType, String columnType, Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        BigDecimal result = BigDecimal.ZERO;
        if (PRE_YEAR_AMOUNT.equals(columnType)) {
            if ("14".equals(rowType)) {
                BigDecimal rate = new BigDecimal("0.25");
                this.dataMap.put(this.getKey(rowType, columnType), rate);
                return rate;
            }
            Map<String, BigDecimal> calcSummary = this.getPerYearCalcSummary(orgid, skssqq, skssqz);
            BigDecimal preYearCell = calcSummary.getOrDefault(rowType, BigDecimal.ZERO);
            this.dataMap.put(this.getKey(rowType, columnType), preYearCell);
            return preYearCell;
        }
        if ("1".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter qFilter = new QFilter(ITEM_TYPE, "=", (Object)"003");
            return this.getOne(rowType, columnType, "tccit_dg_a100000_1_sum", "amount", new QFilter[]{orgFilter, dateFilter, qFilter}, "amount");
        }
        if ("2".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getOne(rowType, columnType, "tccit_dg_a100000_2", "jwsdje", new QFilter[]{new QFilter("sbbid", "=", (Object)this.getCurrentYearSbbid(customParams))}, "jwsdje");
        }
        if ("3".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal income = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k"}));
            this.dataMap.put(this.getKey(rowType, columnType), income);
            return income;
        }
        if ("3a".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_thinkofsell_summary", "sum(income) as income", new QFilter[]{orgFilter, dateFilter}, "income");
        }
        if ("3b".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter qFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("001_01", "001_02", "001_03"));
            return this.getSum(rowType, columnType, "tccit_right_income_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, qFilter}, "nstzje");
        }
        if ("3c".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter qFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("002_01", "002_02", "002_03"));
            return this.getSum(rowType, columnType, "tccit_right_income_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, qFilter}, "nstzje");
        }
        if ("3d".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter qFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("003_01", "003_02", "003_03"));
            return this.getSum(rowType, columnType, "tccit_right_income_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, qFilter}, "nstzje");
        }
        if ("3e".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter qFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("cqgqtz", "jrzccstz"));
            return this.getSum(rowType, columnType, "tccit_tzzccscbtz_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, qFilter}, "nstzje");
        }
        if ("3f".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_gyjzbdsy_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("3g".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_invest_profit_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("3i".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter yearFilter = new QFilter("entryentity.year", "=", (Object)DateUtils.getYearOfDate((Date)skssqq));
            DynamicObjectCollection entrys = QueryServiceHelper.query((String)"tccit_zero_rating_summary", (String)"entryentity.incomeamount as incomeamount,entryentity.includedtaxamount as includedtaxamount ", (QFilter[])new QFilter[]{orgFilter, dateFilter, yearFilter});
            BigDecimal incomeamount = entrys.stream().map(s -> s.getBigDecimal("incomeamount")).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal("-1"));
            BigDecimal includedtaxamount = entrys.stream().map(s -> s.getBigDecimal("includedtaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sum = incomeamount.add(includedtaxamount);
            this.dataMap.put(this.getKey(rowType, columnType), sum);
            return sum;
        }
        if ("3j".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_sale_zkzrth_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("3k".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal incomeSum = this.getSum(rowType, columnType, "tccit_dg_income_adjust", "sum(amount) as amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "in", (Object)"11")}, "amount");
            BigDecimal income3 = this.getOne(rowType, columnType, "tccit_dg_income_adjust", "amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"3")}, "amount");
            BigDecimal thinkOfSellIncomeSum = this.getSum(rowType, columnType, "tccit_thinkofsell_summary", "sum(income) as income", new QFilter[]{orgFilter, dateFilter}, "income");
            BigDecimal income = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j"}));
            BigDecimal amount3k = incomeSum.subtract(income3).add(thinkOfSellIncomeSum).subtract(income);
            this.dataMap.put(this.getKey(rowType, columnType), amount3k);
            return amount3k;
        }
        if ("3h".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_asset_dispose_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("4".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"4a", "4b", "4c"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if ("4a".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"4a(1)", "4a(2)", "4a(3)", "4a(4)", "4a(5)", "4a(6)", "4a(7)", "4a(8)"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if ("4b".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"4b(1)", "4b(2)", "4b(3)", "4b(4)", "4b(5)", "4b(6)", "4b(7)", "4b(8)", "4b(9)", "4b(10)"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if ("4c".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal deduct = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"4c(1)", "4c(2)", "4c(3)", "4c(4)", "4c(5)", "4c(6)", "4c(7)", "4c(8)"}));
            this.dataMap.put(this.getKey(rowType, columnType), deduct);
            return deduct;
        }
        if ("4a(1)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)12);
            return this.getOne(rowType, columnType, "tccit_ywzdf_tz_summary", "amount", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "amount");
        }
        if ("4a(2)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"zhigong");
            return this.getOne(rowType, columnType, "tccit_deduct_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstzje");
        }
        if ("4a(3)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"tze");
            BigDecimal limit = this.getOne(rowType, columnType, "tccit_b105014_3_summary", "amount", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "amount");
            BigDecimal full = this.getOne(rowType, columnType, "tccit_edufull_summary", "amount", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "amount");
            return limit.add(full);
        }
        if ("4a(4)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"gonghui");
            return this.getOne(rowType, columnType, "tccit_deduct_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstzje");
        }
        if ("4a(5)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemNoFilter = new QFilter(ITEM_NO, "in", (Object)Lists.newArrayList((Object[])new String[]{"14", "16"}));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_b105021_sum", (String)"money", (QFilter[])new QFilter[]{orgFilter, dateFilter, itemNoFilter}, (String)"itemno asc");
            BigDecimal substract = !CollectionUtils.isEmpty((Collection)query) && query.size() == 2 ? ((DynamicObject)query.get(1)).getBigDecimal("money").subtract(((DynamicObject)query.get(0)).getBigDecimal("money")) : BigDecimal.ZERO;
            BigDecimal fgongyi = this.getSum(rowType, columnType, "tccit_dg_b105020_sum", "nstz", new QFilter[]{orgFilter, dateFilter}, "nstz");
            BigDecimal sum = substract.add(fgongyi);
            this.dataMap.put(this.getKey(rowType, columnType), sum);
            return sum;
        }
        if ("4a(6)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"005_01");
            return this.getOne(rowType, columnType, "tccit_advert_script", "money", new QFilter[]{orgFilter, dateFilter, itemtypeFilter}, "money");
        }
        if ("4a(7)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            DynamicObject nstzje2;
            DynamicObject nstzje1 = QueryServiceHelper.queryOne((String)"tccit_insurance_summary", (String)"amount", (QFilter[])new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"nstzje")});
            BigDecimal amount = BigDecimal.ZERO;
            if (Optional.ofNullable(nstzje1).isPresent()) {
                amount = amount.add(nstzje1.getBigDecimal("amount"));
            }
            if (Optional.ofNullable(nstzje2 = QueryServiceHelper.queryOne((String)"tccit_non_insurance_sum", (String)"nstzje", (QFilter[])new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"count")})).isPresent()) {
                amount = amount.add(nstzje2.getBigDecimal("nstzje"));
            }
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("4a(8)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"dangfei");
            return this.getOne(rowType, columnType, "tccit_deduct_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstzje");
        }
        if ("4b(1)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"tze");
            return this.getOne(rowType, columnType, "tccit_qt_salary_summary", "amount", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "amount");
        }
        if ("4b(2)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_dg_b105019_sum", "nstz", new QFilter[]{orgFilter, dateFilter}, "nstz");
        }
        if ("4b(3)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)1);
            return this.getOne(rowType, columnType, "tccit_beforetax_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4b(4)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)2);
            return this.getSum(rowType, columnType, "tccit_beforetax_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4b(5)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter yearFilter = new QFilter("entryentity.year", "=", (Object)DateUtils.getYearOfDate((Date)skssqq));
            return this.getSum(rowType, columnType, "tccit_zero_rating_summary", "sum(entryentity.expensingamount) as expensingamount", new QFilter[]{orgFilter, dateFilter, yearFilter}, "expensingamount");
        }
        if ("4b(6)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)3);
            return this.getOne(rowType, columnType, "tccit_beforetax_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4b(7)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)4);
            return this.getOne(rowType, columnType, "tccit_beforetax_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4b(8)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)5);
            return this.getOne(rowType, columnType, "tccit_beforetax_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4b(9)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)6);
            return this.getOne(rowType, columnType, "tccit_beforetax_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4b(10)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)7);
            return this.getOne(rowType, columnType, "tccit_beforetax_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "nstzje");
        }
        if ("4c(1)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_thinkofsell_summary", (String)"sum(cost) as cost", (QFilter[])new QFilter[]{orgFilter, dateFilter});
            BigDecimal amount = query == null || query.size() == 0 ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("cost");
            amount = amount.multiply(new BigDecimal("-1"));
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("4c(2)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"salary");
            return this.getOne(rowType, columnType, "tccit_salary_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstzje");
        }
        if ("4c(3)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"stock");
            return this.getOne(rowType, columnType, "tccit_salary_summary", "nstzje", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstzje");
        }
        if ("4c(4)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter ruleIdFilter = new QFilter("ruleid", "=", (Object)0L);
            return this.getOne(rowType, columnType, "tccit_period_summary", "adjustamount", new QFilter[]{orgFilter, dateFilter, ruleIdFilter}, "adjustamount");
        }
        if ("4c(5)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter filter = new QFilter(ITEM_TYPE, "=", (Object)"7010502");
            return this.getSum(rowType, columnType, "tccit_zctz_expense_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, filter}, "nstzje");
        }
        if ("4c(6)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter filter = new QFilter(ITEM_TYPE, "=", (Object)"7010501");
            return this.getSum(rowType, columnType, "tccit_zctz_expense_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, filter}, "nstzje");
        }
        if ("4c(7)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal decuctSum = this.getOne(rowType, columnType, "tccit_deduct_other_sum", "nstzje", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"count")}, "nstzje");
            this.dataMap.put(this.getKey(rowType, columnType), decuctSum);
            return decuctSum;
        }
        if ("4c(8)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal decuctSum = this.getOne(rowType, columnType, "tccit_dg_deduct_adjust", "amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"31")}, "amount");
            BigDecimal income3 = this.getOne(rowType, columnType, "tccit_dg_income_adjust", "amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"3")}, "amount");
            BigDecimal thinkOfSellCost = this.getSum(rowType, columnType, "tccit_thinkofsell_summary", "sum(cost) as cost", new QFilter[]{orgFilter, dateFilter}, "cost");
            BigDecimal amount4c = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"4c(1)", "4c(2)", "4c(3)", "4c(4)", "4c(5)", "4c(6)", "4c(7)"}));
            BigDecimal amount4ab = this.calcCell("4a", columnType, customParams).add(this.calcCell("4b", columnType, customParams));
            BigDecimal amount4c7 = decuctSum.add(income3).subtract(thinkOfSellCost).subtract(amount4c).subtract(amount4ab);
            this.dataMap.put(this.getKey(rowType, columnType), amount4c7);
            return amount4c7;
        }
        if ("5".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal asset = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"5a", "5b", "5c", "5d"}));
            this.dataMap.put(this.getKey(rowType, columnType), asset);
            return asset;
        }
        if ("5a".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter sheetNameFilter = new QFilter("sheetname", "=", (Object)"B105046");
            return this.getSum(rowType, columnType, "tccit_zczjtx_summary", "sum(nstz) as nstz", new QFilter[]{orgFilter, dateFilter, sheetNameFilter}, "nstz");
        }
        if ("5a(1)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("701020101", "701020102", "701020103", "701020104", "701020105", "701020106"));
            return this.getSum(rowType, columnType, "tccit_zczjtx_summary", "sum(nstz) as nstz", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstz");
        }
        if ("5a(2)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter sheetNameFilter = new QFilter("sheetname", "=", (Object)"B105046-1");
            return this.getSum(rowType, columnType, "tccit_zczjtx_summary", "sum(jszjtxtxtje) as jszjtxtxtje", new QFilter[]{orgFilter, dateFilter, sheetNameFilter}, "jszjtxtxtje");
        }
        if ("5a(3)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308"));
            return this.getSum(rowType, columnType, "tccit_zczjtx_summary", "sum(nstz) as nstz", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstz");
        }
        if ("5a(4)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemTypeFilter = new QFilter(ITEM_TYPE, "in", Arrays.asList("701020401", "701020402", "701020403", "701020404", "701020405"));
            return this.getSum(rowType, columnType, "tccit_zczjtx_summary", "sum(nstz) as nstz", new QFilter[]{orgFilter, dateFilter, itemTypeFilter}, "nstz");
        }
        if ("5b".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal asset = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"5b(1)"}));
            this.dataMap.put(this.getKey(rowType, columnType), asset);
            return asset;
        }
        if ("5b(1)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_assets_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("5c".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_assets_loss_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("5d".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter filter = new QFilter(ITEM_TYPE, "=", (Object)"4");
            return this.getSum(rowType, columnType, "tccit_dg_asset_adjust", "amount", new QFilter[]{orgFilter, dateFilter, filter}, "amount");
        }
        if ("5d(1)".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter filter = new QFilter(ITEM_TYPE, "=", (Object)"count");
            return this.getSum(rowType, columnType, "tccit_zc_other_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, filter}, "nstzje");
        }
        if ("6".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal other = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"6a", "6b", "6c", "6d", "6e", "6f"}));
            this.dataMap.put(this.getKey(rowType, columnType), other);
            return other;
        }
        if ("6a".endsWith(rowType) && CUR_YEAR_AMOUNT.endsWith(columnType)) {
            QFilter ruleIdFilter = new QFilter("ruleid", "=", (Object)0);
            return this.getSum(rowType, columnType, "tccit_qyczjdyns_summary", "sum(nstzhjje) as nstzje", new QFilter[]{orgFilter, dateFilter, ruleIdFilter}, "nstzje");
        }
        if ("6b".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter ewblxhFilter = new QFilter(ITEM_TYPE, "=", (Object)"10");
            result = this.getSum(rowType, columnType, "tccit_dksszbj_sum", "sum(nstzje) as nstzje", new QFilter[]{ewblxhFilter}, "nstzje");
            this.dataMap.put(this.getKey(rowType, columnType), result);
            return result;
        }
        if ("6c".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter ewblxhFilter = new QFilter(ITEM_TYPE, "=", (Object)"003");
            result = this.getSum(rowType, columnType, "tccit_dg_b105093nstz_sum", "sum(amount) as amount", new QFilter[]{orgFilter, dateFilter, ewblxhFilter}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), result);
            return result;
        }
        if ("6d".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_hhqyhhr_summary", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter}, "nstzje");
        }
        if ("6e".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_other_spec_sum", "sum(nstzje) as nstzje", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"count")}, "nstzje");
        }
        if ("6f".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal tssxSum = this.getOne(rowType, columnType, "tccit_hzdg_tssxtz_sum", "amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"10")}, "amount");
            BigDecimal qtSum = this.getOne(rowType, columnType, "tccit_hzdg_qttz_sum", "amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"3")}, "amount");
            BigDecimal other = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"6a", "6b", "6c", "6d", "6e"}));
            BigDecimal amount6f = tssxSum.add(qtSum).subtract(other);
            this.dataMap.put(this.getKey(rowType, columnType), amount6f);
            return amount6f;
        }
        if ("7".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal reduction = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"7a", "7b", "7c", "7d", "7e", "7f"}));
            this.dataMap.put(this.getKey(rowType, columnType), reduction);
            return reduction;
        }
        if ("7a".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter investtypeFilter = new QFilter("investtype", "=", (Object)ResManager.loadKDString((String)"\u56fd\u503a", (String)"YearCalcSummaryPageService_0", (String)"taxc-tccit", (Object[])new Object[0]));
            BigDecimal reduction = this.getSum(rowType, columnType, "tccit_dg_b105037_sum", "sum(qddbtzzc) as qddbtzzc", new QFilter[]{orgFilter, dateFilter, investtypeFilter}, "qddbtzzc");
            return reduction;
        }
        if ("7b".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter investtypeFilter = new QFilter("investtype", "in", (Object)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u76f4\u63a5\u6295\u8d44\u5c45\u6c11\u4f01\u4e1a", (String)"YearCalcSummaryPageService_1", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u80a1\u7968\u6295\u8d44 (\u4e0d\u542bH\u80a1)", (String)"YearCalcSummaryPageService_2", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u80a1\u7968\u6295\u8d44 (\u6caa\u6e2f\u901aH\u80a1\u6295\u8d44)", (String)"YearCalcSummaryPageService_3", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u80a1\u7968\u6295\u8d44 (\u6df1\u6e2f\u901aH\u80a1\u6295\u8d44)", (String)"YearCalcSummaryPageService_4", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u65b0\u4f01\u4e1aCDR", (String)"YearCalcSummaryPageService_5", (String)"taxc-tccit", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c38\u7eed\u503a (\u6743\u76ca\u6027)", (String)"YearCalcSummaryPageService_6", (String)"taxc-tccit", (Object[])new Object[0])}));
            BigDecimal reduction = this.getSum(rowType, columnType, "tccit_dg_b105037_sum", "sum(qddbtzzc) as qddbtzzc", new QFilter[]{orgFilter, dateFilter, investtypeFilter}, "qddbtzzc");
            return reduction;
        }
        if ("7c".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter investtypeFilter = new QFilter("investtype", "=", (Object)ResManager.loadKDString((String)"\u8bc1\u5238\u6295\u8d44\u57fa\u91d1", (String)"YearCalcSummaryPageService_7", (String)"taxc-tccit", (Object[])new Object[0]));
            BigDecimal reduction = this.getSum(rowType, columnType, "tccit_dg_b105037_sum", "sum(qddbtzzc) as qddbtzzc", new QFilter[]{orgFilter, dateFilter, investtypeFilter}, "qddbtzzc");
            return reduction;
        }
        if ("7d".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemtypeFilter = new QFilter(ITEM_TYPE, "=", (Object)"bndyffyjjkcze");
            BigDecimal reduction = this.getOne(rowType, columnType, "tccit_dev_jjkc_summary", "amount", new QFilter[]{orgFilter, dateFilter, itemtypeFilter}, "amount");
            return reduction;
        }
        if ("7e".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemnoFilter = new QFilter(ITEM_NO, "=", (Object)"3.2");
            BigDecimal reduction = this.getOne(rowType, columnType, "tccit_dg_b105038_sum", "ssyhje", new QFilter[]{orgFilter, dateFilter, itemnoFilter}, "ssyhje");
            return reduction;
        }
        if ("8".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getOne(rowType, columnType, "tccit_dg_a100000_2", "jwyssddjjnks", new QFilter[]{new QFilter("sbbid", "=", (Object)this.getCurrentYearSbbid(customParams))}, "jwyssddjjnks");
        }
        if ("9".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemType = new QFilter(ITEM_TYPE, "=", (Object)"9");
            return this.getOne(rowType, columnType, "tccit_domestic_adjust", "amount", new QFilter[]{orgFilter, dateFilter, itemType}, "amount");
        }
        if ("10".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getOne(rowType, columnType, "tccit_dg_a100000_4_sum", "jsdjm", new QFilter[]{orgFilter, dateFilter}, "jsdjm");
        }
        if ("11".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            return this.getSum(rowType, columnType, "tccit_dg_b105060_sum", "sum(syjnsdmb) as syjnsdmb", new QFilter[]{orgFilter, dateFilter}, "syjnsdmb");
        }
        if ("12".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemType = new QFilter(ITEM_TYPE, "=", (Object)"0");
            return this.getOne(rowType, columnType, "tccit_dg_a100000_7_sum", "wsscurrent", new QFilter[]{orgFilter, dateFilter, itemType}, "wsscurrent");
        }
        if ("13".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemType = new QFilter(ITEM_TYPE, "=", (Object)"1");
            return this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "amount", new QFilter[]{orgFilter, dateFilter, itemType}, "amount");
        }
        if ("14".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal rate = new BigDecimal("0.25");
            this.dataMap.put(this.getKey(rowType, columnType), rate);
            return rate;
        }
        if ("15".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            QFilter itemType = new QFilter(ITEM_TYPE, "=", (Object)"3");
            return this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "amount", new QFilter[]{orgFilter, dateFilter, itemType}, "amount");
        }
        if ("16".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal reduction = this.getSumCurYearAmount(columnType, Lists.newArrayList((Object[])new String[]{"16a", "16b"}));
            this.dataMap.put(this.getKey(rowType, columnType), reduction);
            return reduction;
        }
        if ("16a".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = BigDecimal.ZERO;
            ArrayList items = Lists.newArrayList((Object[])new String[]{"4", "5", "6"});
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_setz_jmyhhz_summary", (String)" * ", (QFilter[])new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "in", (Object)items)});
            if (EmptyCheckUtils.isNotEmpty((Object)query)) {
                Map<String, DynamicObject> collect = query.stream().collect(Collectors.toMap(a -> a.getString(ITEM_TYPE), r -> r, (v1, v2) -> v1));
                BigDecimal bigDecimal4 = collect.get("4") == null ? BigDecimal.ZERO : collect.get("4").getBigDecimal("amountorratio");
                BigDecimal bigDecimal5 = collect.get("5") == null ? BigDecimal.ZERO : collect.get("5").getBigDecimal("amountorratio");
                BigDecimal bigDecimal6 = collect.get("6") == null ? BigDecimal.ZERO : collect.get("6").getBigDecimal("amountorratio");
                bigDecimal4 = bigDecimal4 == null ? BigDecimal.ZERO : bigDecimal4;
                bigDecimal5 = bigDecimal5 == null ? BigDecimal.ZERO : bigDecimal5;
                bigDecimal6 = bigDecimal6 == null ? BigDecimal.ZERO : bigDecimal6;
                amount = bigDecimal4.subtract(bigDecimal5).add(bigDecimal6);
            }
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("16b".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = BigDecimal.ZERO;
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_setz_jmyhhz_summary", (String)" * ", (QFilter[])new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"5")});
            if (EmptyCheckUtils.isNotEmpty((Object)query)) {
                Map<String, DynamicObject> collect = query.stream().collect(Collectors.toMap(a -> a.getString(ITEM_TYPE), r -> r, (v1, v2) -> v1));
                BigDecimal bigDecimal5 = collect.get("5") == null ? BigDecimal.ZERO : collect.get("5").getBigDecimal("amountorratio");
                amount = bigDecimal5 == null ? BigDecimal.ZERO : bigDecimal5;
            }
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("17".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"5")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("18".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"6")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("19".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"7")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("20".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"8")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("21".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"9")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("22".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"10")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("23".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"11")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        if ("24".equals(rowType) && CUR_YEAR_AMOUNT.equals(columnType)) {
            BigDecimal amount = this.getOne(rowType, columnType, "tccit_setz_sejs_sum", "itemtype,amount", new QFilter[]{orgFilter, dateFilter, new QFilter(ITEM_TYPE, "=", (Object)"12")}, "amount");
            this.dataMap.put(this.getKey(rowType, columnType), amount);
            return amount;
        }
        this.dataMap.put(this.getKey(rowType, columnType), result);
        return result;
    }
}

