/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tccit.business.pojo.DataQfilterDto;
import kd.taxc.tccit.business.pojo.DraftDataVo;
import kd.taxc.tccit.common.enums.YearDraftSummaryEnum;

public class YearDraftCollectService {
    private static Log logger = LogFactory.getLog(YearDraftCollectService.class);

    public Map<String, DynamicObjectCollection> batchQuery(List<YearDraftSummaryEnum> draftSummaryEnums, DataQfilterDto qFilterDto) {
        List list = draftSummaryEnums.stream().map(this.getYearDraftSummaryEnumFutureFunction(qFilterDto)).collect(Collectors.toList());
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
        list.stream().forEach(objectFuture -> this.getFutureResult((Map<String, DynamicObjectCollection>)result, (Future<Object>)objectFuture));
        return result;
    }

    public Function<YearDraftSummaryEnum, Future<Object>> getYearDraftSummaryEnumFutureFunction(DataQfilterDto qFilterDto) {
        return summaryEnum -> ThreadPoolsService.getInstance().submitFutrue(() -> {
            HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
            result.put(summaryEnum.getEntityName(), QueryServiceHelper.query((String)summaryEnum.getEntityName(), (String)MetadataUtil.getAllFieldToQuery((String)summaryEnum.getEntityName()), (QFilter[])summaryEnum.getQfilter(qFilterDto)));
            return result;
        });
    }

    public void getFutureResult(Map<String, DynamicObjectCollection> result, Future<Object> objectFuture) {
        try {
            result.putAll((Map)objectFuture.get(10L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            logger.error("\u5e74\u62a5\u5e95\u7a3f\u67e5\u8be2\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
    }

    public DraftDataVo getDraftDataByQfilter(DataQfilterDto qFilterDto) {
        DraftDataVo draftDataVo = new DraftDataVo();
        Map<String, DynamicObjectCollection> dataLists = this.batchQuery(Arrays.stream(YearDraftSummaryEnum.values()).collect(Collectors.toList()), qFilterDto);
        dataLists.forEach((key, value) -> this.calcData(draftDataVo, (String)key, (DynamicObjectCollection)value));
        return draftDataVo;
    }

    public void calcData(DraftDataVo draftDataVo, String key, DynamicObjectCollection values) {
        if (key.equals(YearDraftSummaryEnum.tccit_dg_a100000_1_sum.name())) {
            BigDecimal lrze = values.stream().filter(s -> "003".equals(s.getString("itemtype"))).map(s -> s.getBigDecimal("amount")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setLrze(lrze);
        }
        if (key.equals(YearDraftSummaryEnum.tccit_domestic_adjust.name())) {
            BigDecimal nstzzje = values.stream().filter(a -> Lists.newArrayList((Object[])new String[]{"2", "3", "4", "5", "6", "7"}).contains(a.getString("itemtype"))).filter(s -> s.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0).map(s -> s.getBigDecimal("amount")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setNstzzje(nstzzje);
            BigDecimal nstzjse = values.stream().filter(a -> Lists.newArrayList((Object[])new String[]{"2", "3", "4", "5", "6", "7"}).contains(a.getString("itemtype"))).filter(s -> s.getBigDecimal("amount").compareTo(BigDecimal.ZERO) < 0).map(s -> s.getBigDecimal("amount")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setNstzjse(nstzjse);
            BigDecimal msjjjjkc = values.stream().filter(s -> "8".equals(s.getString("itemtype"))).map(s -> s.getBigDecimal("amount")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setMsjjjjkc(msjjjjkc);
        }
        if (key.equals(YearDraftSummaryEnum.tccit_dg_a100000_4_sum.name())) {
            BigDecimal sdjm = values.stream().map(s -> s.getBigDecimal("jsdjm")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setSdjm(sdjm);
        }
        if (key.equals(YearDraftSummaryEnum.tccit_dg_b105060_sum.name())) {
            BigDecimal mbyqndks = values.stream().map(s -> s.getBigDecimal("syjnsdmb")).reduce(BigDecimal.ZERO, BigDecimal::add);
            draftDataVo.setMbyqndks(mbyqndks);
        }
        if (key.equals(YearDraftSummaryEnum.tccit_dg_a100000_7_sum.name())) {
            BigDecimal dkynssde = values.stream().filter(s -> "0".equals(s.getString("itemtype"))).map(s -> s.getBigDecimal("wsscurrent")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setDkynssde(dkynssde);
        }
        if (key.equals(YearDraftSummaryEnum.tccit_setz_sejs_sum.name())) {
            BigDecimal dmsdse = values.stream().filter(s -> "5".equals(s.getString("itemtype"))).map(s -> s.getBigDecimal("amount")).findFirst().orElseGet(() -> BigDecimal.ZERO);
            draftDataVo.setDmsdse(dmsdse);
        }
    }
}

