/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.dynamicrow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class AbstractCitrtaDynamicRowListFetchPlugin
extends AbstractDynamicListBasePlugin {
    private Long ID;
    private String DRAFTDETAIL;
    private String DECLAREDYNROW;
    private String ITEMKEY;
    private String JTJEKEY;
    private String SBJEKEY;
    private QFilter DRAFTQFILTER;
    private String DRAFTORGFIELDNAME;
    private String DRAFTITEMFIELDNAME;
    private String AMOUNTFIELDNAME = "nontaxtotal";

    protected Long getId() {
        return this.ID;
    }

    protected String getDrafDetail() {
        return this.DRAFTDETAIL;
    }

    protected String getDeclareDynrow() {
        return this.DECLAREDYNROW;
    }

    protected String getItemKey() {
        return this.ITEMKEY;
    }

    protected String getJtjeKey() {
        return this.JTJEKEY;
    }

    protected String getSbjeKey() {
        return this.SBJEKEY;
    }

    protected QFilter getDraftQfilter() {
        return this.DRAFTQFILTER;
    }

    protected String getDraftOrgFieldName() {
        return this.DRAFTORGFIELDNAME;
    }

    protected String getDraftItemFieldName() {
        return this.DRAFTITEMFIELDNAME;
    }

    protected String getAmountFieldName() {
        return this.AMOUNTFIELDNAME;
    }

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        DynamicObject[] nontaxSummary;
        String draftItemFieldName;
        String draftOrgFieldName;
        String orgId = bussinessParamsVo.getOrgId();
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        Long orgid = Long.valueOf(orgId);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter startDateFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter endDateFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsjb");
        QFilter statusFilter = new QFilter("declarestatus", "=", (Object)"declared");
        DynamicObject declareMain = QueryServiceHelper.queryOne((String)"tccit_query_report", (String)"id", (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter, typeFilter, statusFilter});
        String itemKey = this.getItemKey();
        String jtjeKey = this.getJtjeKey();
        String sbjeKey = this.getSbjeKey();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (declareMain != null) {
            DynamicObjectCollection yhsxCollection;
            String sbbid = declareMain.getString("id");
            QFilter sbbFilter = new QFilter("sbbid", "=", (Object)sbbid);
            Long parentItemId = this.getId();
            if (parentItemId != null) {
                QFilter mssrFilter = new QFilter("parent", "=", (Object)this.getId());
                DynamicObjectCollection allMssrCollection = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"id", (QFilter[])new QFilter[]{mssrFilter});
                List allMssrList = allMssrCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                QFilter itemFilter = new QFilter("item", "in", allMssrList);
                sbbFilter.and(itemFilter);
            }
            if (CollectionUtils.isNotEmpty((Collection)(yhsxCollection = QueryServiceHelper.query((String)this.getDeclareDynrow(), (String)"item,itemamount", (QFilter[])new QFilter[]{sbbFilter})))) {
                yhsxCollection.forEach(e -> {
                    Long item = e.getLong("item");
                    if (item != null && item != 0L) {
                        HashMap<String, Number> map = new HashMap<String, Number>(16);
                        map.put(itemKey, item);
                        map.put(jtjeKey, BigDecimal.ZERO);
                        map.put(sbjeKey, e.getBigDecimal("itemamount"));
                        result.add(map);
                    }
                });
            }
        }
        if (StringUtil.isNotBlank((CharSequence)(draftOrgFieldName = this.getDraftOrgFieldName()))) {
            orgFilter = new QFilter(draftOrgFieldName, "=", (Object)orgid);
        }
        String amountFieldName = this.getAmountFieldName();
        Date skssqq = DateUtils.stringToDate((String)((String)bussinessParamsVo.getExtendParams().get("latestSkssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)bussinessParamsVo.getExtendParams().get("latestSkssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter filter = new QFilter(amountFieldName, ">", (Object)0);
        QFilter draftQfilter = this.getDraftQfilter();
        if (draftQfilter != null) {
            filter.and(draftQfilter);
        }
        if (StringUtil.isBlank((CharSequence)(draftItemFieldName = this.getDraftItemFieldName()))) {
            draftItemFieldName = "rule.itemchoicename";
        }
        if ((nontaxSummary = BusinessDataServiceHelper.load((String)this.getDrafDetail(), (String)(amountFieldName + "," + draftItemFieldName), (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter})) != null) {
            for (DynamicObject obj : nontaxSummary) {
                String item = obj.getDynamicObject(draftItemFieldName).getString("id");
                if (StringUtil.isBlank((CharSequence)item) || item.equals("0")) continue;
                HashMap<String, Object> map = result.stream().filter(e -> String.valueOf(e.get(itemKey)).equals(item)).findFirst().orElse(null);
                if (map == null) {
                    map = new HashMap<String, Object>(16);
                    map.put(itemKey, item);
                    map.put(jtjeKey, obj.getBigDecimal(amountFieldName));
                    map.put(sbjeKey, BigDecimal.ZERO);
                    result.add(map);
                    continue;
                }
                BigDecimal dgmount = ((BigDecimal)map.get(jtjeKey)).add(obj.getBigDecimal(amountFieldName));
                map.put(jtjeKey, dgmount);
            }
        }
        return result;
    }
}

