/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.dynamicrow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tccit.business.dynamicrow.AbstractCitrtaDynamicRowListFetchPlugin;

public class SdjmDynamicRowListFetchPlugin
extends AbstractCitrtaDynamicRowListFetchPlugin {
    private Long ID = 1251290476204538880L;
    private String DRAFTDETAIL = "tccit_incred_sum_sjjt";
    private String DECLAREDYNROW = "tccit_qysds_ext_dyn2";
    private String JSZRDG_DETAIL = "tccit_nontax_sum_m_sjjt";
    private String ITEMKEY = "nszlbd_81#jmssrjjsrjjkc";
    private String JTJEKEY = "nszlbd_81#nszlb_jtje";
    private String SBJEKEY = "nszlbd_81#nszlb_sbje";

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String orgId = bussinessParamsVo.getOrgId();
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        QFilter startDateFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter endDateFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsjb");
        QFilter statusFilter = new QFilter("declarestatus", "=", (Object)"declared");
        DynamicObject declareMain = QueryServiceHelper.queryOne((String)"tccit_query_report", (String)"id", (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter, typeFilter, statusFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (declareMain != null) {
            QFilter mssrFilter = new QFilter("parent", "=", (Object)this.ID);
            DynamicObjectCollection allMssrCollection = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"id", (QFilter[])new QFilter[]{mssrFilter});
            List allMssrList = allMssrCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            String sbbid = declareMain.getString("id");
            QFilter sbbFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter itemFilter = new QFilter("item", "in", allMssrList);
            DynamicObjectCollection yhsxCollection = QueryServiceHelper.query((String)this.DECLAREDYNROW, (String)"item,itemamount", (QFilter[])new QFilter[]{sbbFilter, itemFilter});
            if (CollectionUtils.isNotEmpty((Collection)yhsxCollection)) {
                yhsxCollection.forEach(e -> {
                    HashMap<String, Number> map = new HashMap<String, Number>(16);
                    map.put(this.ITEMKEY, e.getLong("item"));
                    map.put(this.JTJEKEY, BigDecimal.ZERO);
                    map.put(this.SBJEKEY, e.getBigDecimal("itemamount"));
                    result.add(map);
                });
            }
        }
        Date skssqq = DateUtils.stringToDate((String)((String)bussinessParamsVo.getExtendParams().get("latestSkssqq")));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)bussinessParamsVo.getExtendParams().get("latestSkssqz")));
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter filter1 = new QFilter("incredtotal", ">", (Object)0);
        DynamicObject[] nontaxSummary = BusinessDataServiceHelper.load((String)this.DRAFTDETAIL, (String)"incredtotal,rule.itemchoicename", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter1});
        QFilter filter2 = new QFilter("nontaxtotal", ">", (Object)0).and(new QFilter("type", "=", (Object)"4"));
        DynamicObject[] jszrSummary = BusinessDataServiceHelper.load((String)this.JSZRDG_DETAIL, (String)"nontaxtotal,ruleid", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, filter2});
        this.setValue(nontaxSummary, result, "incredtotal");
        this.setValue(jszrSummary, result, "nontaxtotal");
        return result;
    }

    private void setValue(DynamicObject[] dynamicObjects, List<Map<String, Object>> result, String amountFieldName) {
        if (dynamicObjects != null) {
            for (DynamicObject obj : dynamicObjects) {
                String item = "nontaxtotal".equals(amountFieldName) ? obj.getString("ruleid") : obj.getDynamicObject("rule.itemchoicename").getString("id");
                HashMap<String, Object> map = result.stream().filter(e -> String.valueOf(e.get(this.ITEMKEY)).equals(item)).findFirst().orElse(null);
                if (map == null) {
                    map = new HashMap<String, Object>(16);
                    map.put(this.ITEMKEY, item);
                    map.put(this.JTJEKEY, obj.getBigDecimal(amountFieldName));
                    map.put(this.SBJEKEY, BigDecimal.ZERO);
                    result.add(map);
                    continue;
                }
                BigDecimal dgmount = ((BigDecimal)map.get(this.JTJEKEY)).add(obj.getBigDecimal(amountFieldName));
                map.put(this.JTJEKEY, dgmount);
            }
        }
    }
}

