/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.AccountingCaliberService;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class BranchTaxpayEngine
implements IEngine {
    private static final String ENTITY_SUMMARY = "tccit_profit_summary";
    private static final String PAGE_DETAIL = "tccit_yj_profits_accdet";
    private static final String ADJUST_DETAIL = "tccit_adjust_detail";
    private final List<String> TYPES = Arrays.asList("income", "jcost", "profit");
    public static final Log LOGGER = LogFactory.getLog(BranchTaxpayEngine.class);
    private final List<String> exAdjustAcountList = Arrays.asList("2021-SWTZ-ZFJGSYS-0001", "2021-SWTZ-ZFJGSYS-0001_", "2021-SWTZ-ZFJGSYS-0002", "2021-SWTZ-ZFJGSYS-0002_", "2021-SWTZ-ZFJGSYS-0003", "2021-SWTZ-ZFJGSYS-0003_");
    private final Map<String, String> MAP = new LinkedHashMap<String, String>(){
        {
            this.put("income", "011");
            this.put("jcost", "012");
            this.put("profit", "013");
        }
    };

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter q2 = new QFilter("skssqq", "=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q3 = new QFilter("skssqz", "=", (Object)endDate);
        QFilter q4 = new QFilter("itemnumber", "not in", this.exAdjustAcountList);
        DeleteServiceHelper.delete((String)ENTITY_SUMMARY, (QFilter[])new QFilter[]{q1, q2, q3});
        DeleteServiceHelper.delete((String)PAGE_DETAIL, (QFilter[])new QFilter[]{q1, q2, q3});
        DeleteServiceHelper.delete((String)ADJUST_DETAIL, (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public void runEngine(EngineModel model) {
        LOGGER.info("=============BranchTaxpayEngine run start==========================");
        String orgId = model.getOrgId();
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        int month = DateUtils.getMonthOfDate((Date)startDate);
        Boolean isAjflag = DeadlineService.getDeadline(orgId);
        Map<String, List<DynamicObject>> lastPeriodSummaryMap = this.getLastPeriodSummaryMap(q1, startDate, endDate, isAjflag);
        List orglist = (List)model.getCustom().get("orglist");
        String declaretype = (String)model.getCustom().get("declaretype");
        Boolean branch = this.isBranch(declaretype);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(this.TYPES.size());
        for (String type : this.TYPES) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_SUMMARY));
            summary.set("org", (Object)orgId);
            summary.set("type", (Object)type);
            summary.set("skssqq", (Object)startDate);
            summary.set("skssqz", (Object)endDate);
            BigDecimal bqfse = BigDecimal.ZERO;
            BigDecimal bqlje = BigDecimal.ZERO;
            BigDecimal sqfse = BigDecimal.ZERO;
            BigDecimal sqlje = BigDecimal.ZERO;
            List<DynamicObject> dynamicObjects = lastPeriodSummaryMap.get(type);
            if (CollectionUtils.isNotEmpty(dynamicObjects)) {
                sqfse = dynamicObjects.stream().map(s -> s.getBigDecimal("bqfse")).reduce(BigDecimal.ZERO, BigDecimal::add);
                sqlje = dynamicObjects.stream().map(s -> s.getBigDecimal("bqlje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                sqlje = month == 1 ? BigDecimal.ZERO : sqlje;
            }
            summary.set("sqfse", (Object)sqfse);
            summary.set("sqlje", (Object)sqlje);
            List<DynamicObject> accountingList = this.calcAmount(type, branch, orgId, orglist, model);
            bqfse = this.getAccountingAmount(accountingList);
            summary.set("bqfse", (Object)bqfse);
            summary.set("bqlje", (Object)BigDecimalUtil.addObject((Object)bqfse, (Object)sqlje));
            list.add(summary);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> calcAmount(String type, Boolean branch, String orgId, List<Long> orglist, EngineModel model) {
        Map custom = model.getCustom();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (Long taxorgid : orglist) {
            List ruleList;
            if (branch.booleanValue() && !orgId.equals(String.valueOf(taxorgid)) || CollectionUtils.isEmpty(ruleList = RuleService.getSharingAndOrgRules(taxorgid, RuleTypeEnum.PROFITS, custom.getOrDefault("draftpurpose", "nssb")).get((Object)RuleTypeEnum.PROFITS))) continue;
            ruleList = (List)ruleList.stream().filter(s -> s.getDynamicObject("item").getString("number").equals(this.MAP.get(type))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            for (DynamicObject rule : ruleList) {
                String serialno = UUID.randomUUID().toString();
                AccountingCaliberService accountingCaliber = new AccountingCaliberService();
                DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
                List<DynamicObject> accountingList = accountingCaliber.execute(model, taxorgid, entryentity, serialno, PAGE_DETAIL);
                result.addAll(accountingList);
                SaveServiceHelper.save((DynamicObject[])accountingList.toArray(new DynamicObject[0]));
            }
        }
        return result;
    }

    private Map<String, List<DynamicObject>> getLastPeriodSummaryMap(QFilter q1, Date startDate, Date endDate, Boolean isAjsb) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(isAjsb != false ? -3 : -1));
        QFilter skssqq = new QFilter("skssqq", ">=", (Object)date);
        Date date1 = DateUtils.addMonth((Date)endDate, (int)(isAjsb != false ? -3 : -1));
        String lastDateOfMonthStr = DateUtils.getLastDateOfMonthStr((Date)date1, (String)"yyyy-MM-dd");
        QFilter skssqz = new QFilter("skssqz", "<=", (Object)DateUtils.stringToDate((String)lastDateOfMonthStr));
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_SUMMARY, (String)"type,skssqq,skssqz,bqfse,bqlje", (QFilter[])new QFilter[]{q1, skssqq, skssqz});
        return query.stream().collect(Collectors.groupingBy(e -> e.getString("type")));
    }

    private BigDecimal getAccountingAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject object : accountingList) {
            totalAmount = totalAmount.add(object.getBigDecimal("amount"));
        }
        return totalAmount;
    }

    private Boolean isBranch(String declaretype) {
        Boolean result = Boolean.FALSE;
        if ("100".equals(declaretype) || "311".equals(declaretype) || "312".equals(declaretype)) {
            result = true;
        } else if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            result = false;
        }
        return result;
    }
}

