/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.YearCalcTask;
import kd.taxc.tccit.business.draft.AccountingCaliberService;
import kd.taxc.tccit.business.engine.YearAccGetDataTask;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.NssbDraftTypeEnum;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.enums.SjjtDraftTypeEnum;

public class YearAccEngine
implements IEngine {
    private static final String PAGE_1 = "tccit_tz_a100000_1";
    private static final String PAGE_2 = "tccit_tz_a101010";
    private static final String PAGE_3 = "tccit_tz_a101020";
    private static final String PAGE_4 = "tccit_tz_a102010";
    private static final String PAGE_5 = "tccit_tz_a102020";
    private static final String PAGE_6 = "tccit_tz_a103000";
    private static final String PAGE_7 = "tccit_tz_a104000";
    private static final String PAGE_8 = "tccit_tz_nstz";
    private static final String ADJUST_DETAIL = "tccit_adjust_detail";
    private static final String TCCIT_DRAFT_EDIT = "tccit_draft_edit";
    private static final String DEDUCT_TZ_PAGE_DETAIL = "tccit_deduct_tz_detail";
    private static final String THINKOFSELL_PAGE_DETAIL = "tccit_thinkofsell_detail";
    private static final String BEFORETAX_PAGE_DETAIL = "tccit_beforetax_detail";
    private static final String SALARY_PAGE_DETAIL = "tccit_salary_tz_detail";
    private static final String PERIOD_PAGE_DETAIL = "tccit_period_tz_detail";
    private static final String TCCIT_DKYNSSDE_AJUST = "tccit_dkynssde_ajust";
    private static final String ADVERT_PAGE_DETAIL = "tccit_advert_detail";
    private static final String YSZDF_DETAIL = "tccit_ywzdf_tz_detail";
    private static final String ASSETS_PAGE_DETAIL = "tccit_assets_detail";
    private static final String ASSET_DISPOSE_DETAIL = "tccit_asset_dispose_det";
    private static final String RIGHTS_INCOME_PAGE_DETAIL = "tccit_rights_income_det";
    private static final String SALE_ZKZRTH_PAGE_DETAIL = "tccit_zkzrth_tz_detail";
    private static final String INVEST_PROFIT_PAGE_DETAIL = "tccit_invest_profit_det";
    private static final String HHQYHHR_PAGE_DETAIL = "tccit_hhqyhhr_tz_detail";
    private static final String TCCIT_QYCZJDYNS_TZ_DETAIL = "tccit_qyczjdyns_tz_detail";
    private static final String TZZCCSCBTZ_PAGE_DETAIL = "tccit_tzzccscbtz_detail";
    private static final String INTEREST_PAGE_DETAIL = "tccit_interest_tz_detail";
    private static final String GYJZBDSY_PAGE_DETAIL = "tccit_gyjzbdsy_tz_detail";
    private static final String INSURANCE_PAGE_DETAIL = "tccit_insurance_det";
    private static final String NON_INSURANCE_PAGE_DETAIL = "tccit_non_insurance_det";
    private static final String INCOME_OTHER_PAGE_DETAIL = "tccit_income_other_det";
    private static final String ZCTZ_OTHER_PAGE_DETAIL = "tccit_zctz_other_det";
    private static final String ZCTZ_EXPENSE_PAGE_DETAIL = "tccit_zctz_expense_det";
    private static final String SPEC_OTHER_PAGE_DETAIL = "tccit_spec_other_det";
    private static final String OTHER_SPEC_PAGE_DETAIL = "tccit_other_spec_det";
    private static final String OTHER_OTHER_PAGE_DETAIL = "tccit_other_other_det";
    private static final String TCCIT_DG_A100000_1_DET = "tccit_dg_a100000_1_det";
    private static final String PROFIT_FEES_PAGE_DETAIL = "tccit_profit_fees_detail";
    private static final String PROFIT_COST_PAGE_DETAIL = "tccit_profit_cost_detail";
    private static final String PROFIT_INCOME_PAGE_DETAIL = "tccit_profit_income_det";
    private static final String TCCIT_DG_A102020_DET = "tccit_dg_a102020_det";
    private static final String TCCIT_DG_A101020_DET = "tccit_dg_a101020_det";
    private static final String TCCIT_DG_A103000_DET = "tccit_dg_a103000_det";
    private static final String ZCZJTX_DETAIL = "tccit_zczjtx_detail";
    private static final String ASSETS_LOSS_PAGE_DETAIL = "tccit_assets_loss_detail";
    private static final String EDU_LIMIT_PAGE_DETAIL = "tccit_edu_limit_tz_detail";
    private static final String EDU_FULL_PAGE_DETAIL = "tccit_edufull_detail";
    private static final String QT_SALARY_PAGE_DETAIL = "tccit_qt_salary_detail";
    private static final String TCCIT_B105021_DETAIL = "tccit_dg_b105021_det";
    private static final String TCCIT_B105020_DETAIL = "tccit_dg_b105020_det";
    private static final String TCCIT_B105019_DETAIL = "tccit_dg_b105019_det";
    private static final String TCCIT_DG_B105038_DET = "tccit_dg_b105038_det";
    private static final String SPEC_DKSS_TZ_DETAIL = "tccit_spec_dksszbj_detail";
    private static final String TCCIT_DG_A100000_7_DET = "tccit_dg_a100000_7_det";
    private static final String TCCIT_YH_TAXCREDIT_DET = "tccit_yh_taxcredit_det";
    private static final String TCCIT_DG_B105093_DET = "tccit_dg_b105093_det";
    private static final String DEV_JJKC_DETAIL = "tccit_dev_jjkc_detail";
    private static final String DEDUCT_OTHER_DET = "tccit_deduct_other_det";
    private static final String HIGH_TECH_DET = "tccit_dg_a301010201_det";
    private static final String TCCIT_FDCTDYW_ACCDETAIL = "tccit_fdctdyw_accdetail";
    private static final String TCCIT_FDCTDYW_ACCDETAIL_SJJT = "tccit_fdc_acc_sjjt";
    public static final String REMOVE_ADJUST_BY_HAND = "remove_adjust_by_hand";
    private static Map<String, List<String>> ENTITY_ITEM_MAPPING = new HashMap<String, List<String>>();
    private static Set<String> byRules = Sets.newHashSet((Object[])new String[]{"tccit_thinkofsell_detail", "tccit_period_tz_detail", "tccit_assets_detail", "tccit_zkzrth_tz_detail", "tccit_hhqyhhr_tz_detail", "tccit_gyjzbdsy_tz_detail", "tccit_qyczjdyns_tz_detail", "tccit_non_insurance_det", "tccit_income_other_det", "tccit_zctz_other_det", "tccit_zctz_expense_det", "tccit_spec_other_det", "tccit_other_spec_det", "tccit_other_other_det", "tccit_zczjtx_detail", "tccit_assets_loss_detail", "tccit_dg_b105020_det", "tccit_dg_b105019_det", "tccit_yh_taxcredit_det", "tccit_dg_b105093_det", "tccit_fdctdyw_accdetail", "tccit_fdc_acc_sjjt", "tccit_deduct_other_det", NssbDraftTypeEnum.ASSERT_ACCE.getDetail(), NssbDraftTypeEnum.YJ_NONTAX.getDetail(), NssbDraftTypeEnum.YJ_INCRED.getDetail(), NssbDraftTypeEnum.YJ_TECHTRANS.getDetail(), NssbDraftTypeEnum.YJ_TREDUCED.getDetail(), NssbDraftTypeEnum.YJ_ADD_DEDUCTION.getDetail(), SjjtDraftTypeEnum.ASSERT_ACCE.getDetail(), SjjtDraftTypeEnum.YJ_NONTAX.getDetail(), SjjtDraftTypeEnum.YJ_INCRED.getDetail(), SjjtDraftTypeEnum.YJ_TECHTRANS.getDetail(), SjjtDraftTypeEnum.YJ_TREDUCED.getDetail(), SjjtDraftTypeEnum.YJ_ADD_DEDUCTION.getDetail()});
    private static List<String> exAdjustAcountList = Arrays.asList("2021-SWTZ-ZFJGSYS-0001", "2021-SWTZ-ZFJGSYS-0001_", "2021-SWTZ-ZFJGSYS-0002", "2021-SWTZ-ZFJGSYS-0002_", "2021-SWTZ-ZFJGSYS-0003", "2021-SWTZ-ZFJGSYS-0003_");
    private YearCalcTask task;
    private CopyOnWriteArrayList<List<DynamicObject>> saveDetails = new CopyOnWriteArrayList();

    public static Map<String, List<String>> getEntityItemMapping() {
        return ENTITY_ITEM_MAPPING;
    }

    public static Set<String> getByRules() {
        return byRules;
    }

    public CopyOnWriteArrayList<List<DynamicObject>> getSaveDetails() {
        return this.saveDetails;
    }

    public YearAccEngine() {
    }

    public YearAccEngine(YearCalcTask task) {
        this.task = task;
    }

    public void deleteData(EngineModel model) {
        Long orgId = Long.parseLong(model.getOrgId());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter startFilter = new QFilter("skssqq", "=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter endFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter noInFilter = new QFilter("itemnumber", "not in", exAdjustAcountList);
        Boolean removeAdjustByHand = (Boolean)model.getCustomValue(REMOVE_ADJUST_BY_HAND);
        this.deleteExistData(orgFilter, startFilter, endFilter, noInFilter, removeAdjustByHand);
    }

    public void runEngine(EngineModel model) {
        int startProgress = 10;
        int endProgress = 70;
        int progressing = startProgress;
        Optional.ofNullable(this.task).ifPresent(s -> s.customfeedbackProgress(startProgress, null, null));
        List orglist = (List)model.getCustom().get("orglist");
        int allRate = endProgress - startProgress;
        AccountingCaliberService accountingCaliber = new AccountingCaliberService();
        Map<String, List> allRulesByOrgId = orglist.stream().collect(Collectors.toMap(s -> s, s -> RuleService.getSharingAndOrgRules(Long.parseLong(s), RuleTypeEnum.ALL_HJ_RULES, null).get((Object)RuleTypeEnum.ALL_HJ_RULES)));
        List allRulesSize = allRulesByOrgId.values().stream().flatMap(s -> s.stream()).collect(Collectors.toList());
        for (Map.Entry<String, List> entry : allRulesByOrgId.entrySet()) {
            Long taxOrgid = Long.parseLong(entry.getKey());
            List ruleList = entry.getValue();
            if (ruleList != null && ruleList.size() > 0) {
                Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(Collections.singletonList(taxOrgid), (Date)DateUtils.stringToDate((String)model.getStartDate()), (Date)DateUtils.stringToDate((String)model.getEndDate()));
                Map fiBdAccounts = GetGLBalanceCommonUtil.create((Long)taxOrgid);
                model.getCustom().put("orgRelationMap", orgRelationMap);
                model.getCustom().put("fiBdAccounts", fiBdAccounts);
                YearAccGetDataTask task = new YearAccGetDataTask(ruleList, this.saveDetails, model, taxOrgid, this);
                ThreadPoolsService.getInstance().submit((Task)task);
                progressing += CollectionUtils.isEmpty(allRulesSize) ? 0 : ruleList.size() * allRate / allRulesSize.size();
            }
            int finalProgressing = progressing;
            Optional.ofNullable(this.task).ifPresent(s -> s.customfeedbackProgress(finalProgressing, null, null));
        }
        Optional.ofNullable(this.task).ifPresent(s -> s.customfeedbackProgress(endProgress, null, null));
    }

    protected String getEntityName(String itemnumber, String type) {
        if (RuleTypeEnum.TSSX.getVal().equals(type) && "80101".equals(itemnumber)) {
            return HHQYHHR_PAGE_DETAIL;
        }
        if (RuleTypeEnum.SSYH.getVal().equals(type) && "80101".equals(itemnumber)) {
            return TCCIT_DG_A100000_7_DET;
        }
        Optional<Map.Entry> entryItem = YearAccEngine.getEntityItemMapping().entrySet().stream().filter(s -> ((List)s.getValue()).contains(itemnumber)).findFirst();
        return entryItem.map(Map.Entry::getKey).orElse(null);
    }

    private void deleteExistData(QFilter orgFilter, QFilter startFilter, QFilter endFilter, QFilter noInFilter, Boolean removeAdjustByHand) {
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)PAGE_1, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_2, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_3, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_4, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_5, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_6, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_7, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                DeleteServiceHelper.delete((String)PAGE_8, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                YearAccEngine.getEntityItemMapping().forEach((k, v) -> DeleteServiceHelper.delete((String)k, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
                if (removeAdjustByHand != null && removeAdjustByHand.booleanValue()) {
                    DeleteServiceHelper.delete((String)ADJUST_DETAIL, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, noInFilter});
                    DeleteServiceHelper.delete((String)TCCIT_DKYNSSDE_AJUST, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
                    DeleteServiceHelper.delete((String)TCCIT_DRAFT_EDIT, (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, noInFilter});
                } else {
                    QFilter titleNameFiler = new QFilter("titlename", "!=", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"YearAccEngine_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)ADJUST_DETAIL, (String)"amount,totalamount", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, noInFilter, titleNameFiler});
                    if (load.length > 0) {
                        Arrays.stream(load).forEach(s -> {
                            s.set("totalamount", (Object)BigDecimal.ZERO);
                            s.set("amount", (Object)BigDecimal.ZERO);
                        });
                    }
                    SaveServiceHelper.update((DynamicObject[])load);
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    static {
        ENTITY_ITEM_MAPPING.put(DEDUCT_TZ_PAGE_DETAIL, Arrays.asList("3010104", "3010105", "3010108", "3010109", "30108"));
        ENTITY_ITEM_MAPPING.put(THINKOFSELL_PAGE_DETAIL, Arrays.asList("50101", "50102", "50103", "50104", "50105", "50106", "50107", "50108", "50109"));
        ENTITY_ITEM_MAPPING.put(BEFORETAX_PAGE_DETAIL, Arrays.asList("3010701", "3010702", "3010703", "3010704", "3010705", "3010706", "3010707"));
        ENTITY_ITEM_MAPPING.put(SALARY_PAGE_DETAIL, Arrays.asList("3010101", "3010110", "3010102", "3010103"));
        ENTITY_ITEM_MAPPING.put(EDU_LIMIT_PAGE_DETAIL, Collections.singletonList("3010106"));
        ENTITY_ITEM_MAPPING.put(EDU_FULL_PAGE_DETAIL, Collections.singletonList("3010107"));
        ENTITY_ITEM_MAPPING.put(QT_SALARY_PAGE_DETAIL, Collections.singletonList("3010111"));
        ENTITY_ITEM_MAPPING.put(PERIOD_PAGE_DETAIL, Collections.singletonList("3010901"));
        ENTITY_ITEM_MAPPING.put(ADVERT_PAGE_DETAIL, Collections.singletonList("30103"));
        ENTITY_ITEM_MAPPING.put(YSZDF_DETAIL, Collections.singletonList("30102"));
        ENTITY_ITEM_MAPPING.put(INTEREST_PAGE_DETAIL, Collections.singletonList("30105"));
        ENTITY_ITEM_MAPPING.put(RIGHTS_INCOME_PAGE_DETAIL, Arrays.asList("6010101", "6010102", "6010103", "6010201", "6010202", "6010203", "6010204", "6010205", "6010206", "6010207"));
        ENTITY_ITEM_MAPPING.put(SALE_ZKZRTH_PAGE_DETAIL, Collections.singletonList("60103"));
        ENTITY_ITEM_MAPPING.put(INVEST_PROFIT_PAGE_DETAIL, Arrays.asList("6010401", "6010402", "6010403", "6010404", "6010405", "6010406", "6010407", "6010408", "6010409"));
        ENTITY_ITEM_MAPPING.put(TZZCCSCBTZ_PAGE_DETAIL, Collections.singletonList("60105"));
        ENTITY_ITEM_MAPPING.put(GYJZBDSY_PAGE_DETAIL, Collections.singletonList("60106"));
        ENTITY_ITEM_MAPPING.put(ASSETS_PAGE_DETAIL, Collections.singletonList("70101"));
        ENTITY_ITEM_MAPPING.put(HHQYHHR_PAGE_DETAIL, Collections.singletonList("80101"));
        ENTITY_ITEM_MAPPING.put(TCCIT_QYCZJDYNS_TZ_DETAIL, Arrays.asList("80103", "8010301", "801030101", "801030102", "8010302", "801030201", "8010303", "801030301", "8010304", "801030401", "801030402", "8010305", "8010306", "8010307", "8010308", "8010309"));
        ENTITY_ITEM_MAPPING.put(INSURANCE_PAGE_DETAIL, Collections.singletonList("3010601"));
        ENTITY_ITEM_MAPPING.put(NON_INSURANCE_PAGE_DETAIL, Arrays.asList("3010602", "3010603"));
        ENTITY_ITEM_MAPPING.put(INCOME_OTHER_PAGE_DETAIL, Collections.singletonList("60107"));
        ENTITY_ITEM_MAPPING.put(ZCTZ_OTHER_PAGE_DETAIL, Collections.singletonList("70104"));
        ENTITY_ITEM_MAPPING.put(ZCTZ_EXPENSE_PAGE_DETAIL, Arrays.asList("7010501", "7010502", "7010503", "7010504"));
        ENTITY_ITEM_MAPPING.put(SPEC_OTHER_PAGE_DETAIL, Collections.singletonList("80104"));
        ENTITY_ITEM_MAPPING.put(SPEC_DKSS_TZ_DETAIL, Arrays.asList("801020101", "801020102", "801020103", "80102010101", "8010201010201", "8010201010202", "8010201010203", "8010201010204"));
        ENTITY_ITEM_MAPPING.put(OTHER_SPEC_PAGE_DETAIL, Collections.singletonList("90101"));
        ENTITY_ITEM_MAPPING.put(OTHER_OTHER_PAGE_DETAIL, Collections.singletonList("90102"));
        ENTITY_ITEM_MAPPING.put(PROFIT_FEES_PAGE_DETAIL, Arrays.asList("2010101", "2010102", "2010103", "2010104", "2010105", "2010106", "2010107", "2010108", "2010109", "2010110", "2010111", "2010112", "2010113", "2010114", "2010115", "2010116", "2010117", "2010118", "2010119", "2010120", "2010121", "2010201", "2010202", "2010203", "2010204", "2010205", "2010206", "2010207", "2010208", "2010301", "2010302", "2010303", "2010304", "2010305", "2010306", "2010307", "2010308", "2010309", "2010310", "2010311", "2010312", "2010313", "2010314", "2010315", "2010316", "2010317", "2010318", "2010319", "2010320", "2010321", "2010322", "2010401", "2010402", "2010403", "2010404", "2010405", "2010406", "2010407", "2010408", "2010501", "2010502", "2010503", "2010504", "2010505", "2010601", "2010602", "2010603", "2010604", "2010209", "2010409"));
        ENTITY_ITEM_MAPPING.put(ASSET_DISPOSE_DETAIL, Arrays.asList("6010801", "6010802", "6010803", "6010804", "6010805", "6010806", "6010807", "6010808", "6010809"));
        ENTITY_ITEM_MAPPING.put(PROFIT_COST_PAGE_DETAIL, Arrays.asList("1020101", "1020102", "1020103", "1020104", "1020105", "1020106", "1020107", "1020108", "1020109", "1020110", "1020111", "1020112", "1020201", "1020202", "1020203", "1020204", "1020205", "1020206", "1020207", "1020208", "1020209", "1020210"));
        ENTITY_ITEM_MAPPING.put(PROFIT_INCOME_PAGE_DETAIL, Arrays.asList("1010101", "1010102", "1010103", "1010104", "1010105", "1010106", "1010107", "1010108", "1010109", "1010110", "1010111", "1010112", "1010201", "1010202", "1010203", "1010204", "1010205", "1010206", "1010207", "1010208", "1010209", "1010210"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_A102020_DET, Arrays.asList("1040101", "1040102", "1040103", "1040104", "1040105", "1040106", "1040107", "1040108", "1040109", "1040110", "1040111", "1040112", "1040113", "1040114", "1040115", "1040116", "1040117", "1040118", "1040119", "1040120", "1040121", "1040122", "1040123", "1040124", "1040125", "1040201", "1040202", "1040203", "1040204", "1040205", "1040206"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_A101020_DET, Arrays.asList("1030101", "1030102", "1030103", "1030104", "1030105", "1030106", "1030107", "1030108", "1030109", "1030110", "1030111", "1030112", "1030113", "1030114", "1030115", "1030116", "1030117", "1030118", "1030119", "1030120", "1030121", "1030122", "1030123", "1030124", "1030125", "1030126", "1030127", "1030201", "1030202", "1030203", "1030204", "1030205", "1030206", "1030207"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_A103000_DET, Arrays.asList("1050101", "1050102", "1050103", "1050104", "1050105", "1050106", "1050107", "1050201", "1050202", "1050203", "1050204", "1050205", "1050301", "1050302", "1050303", "1050304", "1050305", "1050306", "1050307", "1050401", "1050402", "1050403", "1050404"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_A100000_1_DET, Arrays.asList("106", "107", "108", "109", "110"));
        ENTITY_ITEM_MAPPING.put(ZCZJTX_DETAIL, Arrays.asList("701020101", "701020102", "701020103", "701020104", "701020105", "701020106", "701020201", "701020202", "701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308", "701020401", "701020402", "701020403", "701020404", "701020405", "701020501", "701020502", "701020601", "701020602", "701020603", "701020604", "701020605", "701020606", "701020607", "701020608", "701020609", "701020610", "701020611", "701020612", "701020613", "701020614", "701020615", "701020616", "701020617", "701020618", "701020619", "701020620", "701020621", "701020622", "701020623", "701020624", "701020625", "701020626", "701020627"));
        ENTITY_ITEM_MAPPING.put(ASSETS_LOSS_PAGE_DETAIL, Arrays.asList("7010301", "701030201", "701030202", "701030203", "701030301", "701030302", "701030401", "701030402", "701030501", "701030502", "701030503", "701030601", "701030602", "701030701", "701030702", "70103080101", "70103080102", "70103080103", "70103080104", "70103080105", "701030802", "701030901", "701030902", "7010310", "7010311", "7010312"));
        ENTITY_ITEM_MAPPING.put(TCCIT_B105021_DETAIL, Collections.singletonList("3010401"));
        ENTITY_ITEM_MAPPING.put(TCCIT_B105020_DETAIL, Arrays.asList("301040201", "301040202", "301040203", "301040204", "301040205"));
        ENTITY_ITEM_MAPPING.put(TCCIT_B105019_DETAIL, Collections.singletonList("3010403"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_B105038_DET, Arrays.asList("501", "502", "503", "504", "505", "506", "507", "601", "60201", "60202", "60203", "603", "60401", "60402", "701", "702", "704", "705"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_A100000_7_DET, Arrays.asList("80101", "80102", "80201", "80202"));
        ENTITY_ITEM_MAPPING.put(TCCIT_DG_B105093_DET, Arrays.asList("8010501", "8010502"));
        ENTITY_ITEM_MAPPING.put(TCCIT_YH_TAXCREDIT_DET, Arrays.asList("901", "902", "903"));
        ENTITY_ITEM_MAPPING.put(DEV_JJKC_DETAIL, Arrays.asList("7030101", "7030102", "7030103", "7030104", "7030105", "7030106", "7030107", "70302", "70303"));
        ENTITY_ITEM_MAPPING.put(DEDUCT_OTHER_DET, Collections.singletonList("30110"));
        ENTITY_ITEM_MAPPING.put(HIGH_TECH_DET, Arrays.asList("1300101", "1300102", "1300103", "1300104", "1300201", "1300202", "1300301", "1300302", "1300303", "1300304", "1300305", "1300306", "1300307", "1300308", "1300309", "1300310"));
    }
}

