/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.draft.AccountingCaliberService;
import kd.taxc.tccit.business.engine.YearAccEngine;

public class YearAccGetDataTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(YearAccGetDataTask.class);
    private List<DynamicObject> ruleList;
    private CopyOnWriteArrayList<List<DynamicObject>> saveDetails;
    private EngineModel model;
    private Long taxOrgid;
    private YearAccEngine yearAccEngine;
    private static final int SQL_SIZE = 2;

    public YearAccGetDataTask(List<DynamicObject> ruleList, CopyOnWriteArrayList<List<DynamicObject>> saveDetails, EngineModel model, Long taxOrgid, YearAccEngine yearAccEngine) {
        this.ruleList = ruleList;
        this.saveDetails = saveDetails;
        this.model = model;
        this.taxOrgid = taxOrgid;
        this.yearAccEngine = yearAccEngine;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition(this.ruleList, (int)2);
    }

    public List<DynamicObject> executor(List<DynamicObject> list) {
        AccountingCaliberService accountingCaliber = new AccountingCaliberService();
        for (DynamicObject rule : list) {
            String serialno = UUID.randomUUID().toString();
            String type = rule.getString("type");
            DynamicObject item = rule.getDynamicObject("item");
            if (item == null) continue;
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            String entityname = this.yearAccEngine.getEntityName(rule.getDynamicObject("item").getString("number"), type);
            if (!StringUtil.isNotBlank((CharSequence)entityname)) continue;
            this.saveDetails.add(accountingCaliber.execute(this.model, this.taxOrgid, entryentity, serialno, entityname));
        }
        return new ArrayList<DynamicObject>(0);
    }
}

