/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.draft.engine.service.AbstractDraftEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.engine.refactoring.service.SeasonalDraftEngine;

public abstract class AbstractSeasonalDraftEngine
extends AbstractDraftEngine
implements SeasonalDraftEngine {
    public static final Log LOGGER = LogFactory.getLog(AbstractSeasonalDraftEngine.class);

    AbstractSeasonalDraftEngine() {
    }

    AbstractSeasonalDraftEngine(DraftEngineContext draftEngineContext) {
        this.draftEngineContext = draftEngineContext;
    }

    public void deleteData(EngineModel model) {
        this.preWorkBeforeDelDraft(model);
        Map delDataMap = (Map)this.getDraftEngineContext().getDelDataMap().get(this.getDelDataMapKey());
        if (CollectionUtils.isEmpty((Map)delDataMap)) {
            return;
        }
        delDataMap.forEach(DeleteServiceHelper::delete);
    }

    public void runEngine(EngineModel model) {
    }

    protected List<DynamicObject> execute() throws Exception {
        long start = System.currentTimeMillis();
        LOGGER.info("{0}|{1} start", (Object)this.getCtx().getTraceId(), (Object)this.getClass().getSimpleName());
        this.preWorkBeforeDelDraft(this.getEngineModel());
        List result = this.calDraftData(this.getEngineModel());
        long end = System.currentTimeMillis();
        LOGGER.info("{0}|{1} run success|cost:{2}", new Object[]{this.getCtx().getTraceId(), this.getClass().getSimpleName(), end - start});
        return result;
    }

    @Override
    public String[] getDelDraftTables(EngineModel model) {
        return new String[]{this.getAccountEntityType(model), this.getSummaryEntityType(model)};
    }

    protected List<DynamicObject> getRuleSourceData(EngineModel model) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        boolean isBranch = this.isBranch((String)model.getCustom().get("declaretype"));
        List orgList = (List)model.getCustom().get("orglist");
        for (Long taxOrgId : orgList) {
            if (isBranch && !model.getOrgId().equals(String.valueOf(taxOrgId))) continue;
            model.addCustom("currentOrg", (Object)taxOrgId);
            List rules = this.getRules(model);
            for (DynamicObject rule : rules) {
                model.addCustom("serialNo", (Object)UUID.randomUUID().toString());
                result.addAll(this.getRuleSourceData(model, rule));
            }
        }
        return result;
    }

    protected QFilter[] getOrgAndDateEqualsFilters(EngineModel model) {
        Long orgId = Long.parseLong(model.getOrgId());
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter q2 = new QFilter("skssqq", "=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q3 = new QFilter("skssqz", "=", (Object)endDate);
        return new QFilter[]{q1, q2, q3};
    }

    BigDecimal sumAccountingAmount(List<DynamicObject> accountingList) {
        return accountingList.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    boolean isSJJT(EngineModel model) {
        return "sjjt".equals(model.getCustom().get("draftpurpose"));
    }

    boolean isBranch(String declareType) {
        return false;
    }

    public List<DynamicObject> getSummaryDataByEngineKey(String key, Supplier<DynamicObjectCollection> supplier) {
        List dynamicObjects = (List)this.getDraftEngineContext().getSummaryDataMap().get(key);
        if (dynamicObjects != null) {
            return dynamicObjects;
        }
        DynamicObjectCollection collection = supplier.get();
        return CollectionUtils.isEmpty((Collection)collection) ? new ArrayList() : collection;
    }
}

