/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.enums.DiscountType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.AddDeductionService;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.AddDeductionScene;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class AddDeductionEngine
extends AbstractSeasonalDraftEngine {
    private static final String RULE_TYPE = "5";

    public AddDeductionEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public void preWorkBeforeDelDraft(EngineModel model) {
        Boolean isAjsb;
        Map custom = model.getCustom();
        String draftpurpose = custom.getOrDefault("draftpurpose", "nssb");
        if (AddDeductionScene.nodisplay_noclac == AddDeductionService.isSuitEndDate(draftpurpose, isAjsb = DeadlineService.getDeadline(model.getOrgId()), DateUtils.stringToDate((String)model.getEndDate()))) {
            return;
        }
        super.preWorkBeforeDelDraft(model);
    }

    public void putOtherFiltersDelDraftTables(Map delMap, EngineModel model) {
        ArrayList qFilters = Lists.newArrayList((Object[])this.getOrgAndDateFilters(model));
        qFilters.add(new QFilter("type", "=", (Object)RULE_TYPE));
        delMap.put(this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber(), qFilters.toArray(new QFilter[0]));
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.INCOME);
        return super.getRules(model);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjAddDuduction().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_ADD_DEDUCTION_DETAIL;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjAddDuduction().getNumber();
    }

    public void doHandleRelateData(EngineModel model, List summaryList) {
        List<DynamicObject> relateList = NontaxService.getHandleSummaryMiddleResult(summaryList, RULE_TYPE, "bnyffyjjkcze", 3, true, 1, this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber());
        this.getDraftEngineContext().getSummaryDataMap().put(this.getRelateDataMapKey(), relateList);
    }

    public void doSetDraftData(EngineModel model, List summaryList, List summaryAccountingList) {
        Boolean isAjsb;
        Map custom = model.getCustom();
        String draftpurpose = custom.getOrDefault("draftpurpose", "nssb");
        AddDeductionScene scene = AddDeductionService.isSuitEndDate(draftpurpose, isAjsb = DeadlineService.getDeadline(model.getOrgId()), DateUtils.stringToDate((String)model.getEndDate()));
        if (AddDeductionScene.nodisplay_noclac == scene) {
            return;
        }
        Long orgId = Long.parseLong(model.getOrgId());
        List orgList = (List)model.getCustom().get("orglist");
        Date startDate1 = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate1 = DateUtils.stringToDate((String)model.getEndDate());
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(orgId), startDate1, endDate1, Collections.singletonList("adddeduction")), draftTypeVoObject);
        if (AddDeductionScene.display_calc == scene) {
            this.calcData(model, summaryList, summaryAccountingList, orgId, orgList, scene, adjustAmounts);
        } else if (AddDeductionScene.display_last_month == scene) {
            String summaryEntityType = this.getSummaryEntityType(model);
            String startDate = model.getStartDate();
            String endDate = model.getEndDate();
            QFilter q1 = new QFilter("org", "=", (Object)orgId);
            QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startDate), (int)-1));
            QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth1((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endDate), (int)-1)));
            DynamicObjectCollection query = QueryServiceHelper.query((String)summaryEntityType, (String)MetadataUtil.getAllFieldToQuery((String)summaryEntityType), (QFilter[])new QFilter[]{q1, q2, q3});
            if (!CollectionUtils.isEmpty((Collection)query)) {
                this.fetchLastData(model, summaryList, query, adjustAmounts);
            }
        } else if (AddDeductionScene.display_last_rule == scene) {
            this.calcData(model, summaryList, summaryAccountingList, orgId, orgList, scene, adjustAmounts);
        }
    }

    private void fetchLastData(EngineModel model, List summaryList, DynamicObjectCollection query, DynamicObject[] adjustAmounts) {
        for (DynamicObject object : query) {
            BigDecimal adjustAmount = BigDecimal.ZERO;
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getLong("taxorg") == object.getLong("taxorg")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            if (!CollectionUtils.isEmpty((Collection)collect)) {
                adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
            summary.set("serialno", (Object)object.getString("serialno"));
            summary.set("org", object.get("org"));
            summary.set("taxorg", object.get("taxorg"));
            summary.set("rule", object.get("rule"));
            summary.set("skssqq", (Object)DateUtils.stringToDate((String)model.getStartDate()));
            summary.set("skssqz", (Object)DateUtils.stringToDate((String)model.getEndDate()));
            summary.set("income", (Object)BigDecimalUtil.addObject((Object)object.get("income"), (Object)adjustAmount));
            summary.set("discounttype", object.get("discounttype"));
            summary.set("jjkcpercent", object.get("jjkcpercent"));
            summary.set("bnyffyjjkcze", object.get("bnyffyjjkcze"));
            summaryList.add(summary);
        }
    }

    private void calcData(EngineModel model, List summaryList, List summaryAccountingList, Long orgId, List<Long> orgList, AddDeductionScene suitType, DynamicObject[] adjustAmounts) {
        for (Long taxOrgId : orgList) {
            model.addCustom("currentOrg", (Object)taxOrgId);
            for (DynamicObject rule : this.getRules(model)) {
                if (this.isUnuseRule(rule)) continue;
                String serialNo = UUID.randomUUID().toString();
                model.addCustom("serialNo", (Object)serialNo);
                ArrayList accountingList = AddDeductionScene.display_last_rule == suitType ? Lists.newArrayList() : this.getRuleSourceData(model, rule);
                summaryAccountingList.addAll(accountingList);
                BigDecimal lastPeriodData = AddDeductionService.queryLastPeriodData(model.getOrgId(), taxOrgId, model.getStartDate(), model.getEndDate(), rule.getLong("id"), this.getSummaryEntityType(model));
                BigDecimal accountingAmount = AddDeductionScene.display_last_rule == suitType ? lastPeriodData : this.sumAccountingAmount(accountingList);
                BigDecimal adjustAmount = BigDecimal.ZERO;
                DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(rule.getString("id"))).filter(s -> s.getLong("taxorg") == taxOrgId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
                if (!CollectionUtils.isEmpty((Collection)collect)) {
                    adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
                summary.set("serialno", (Object)serialNo);
                summary.set("org", (Object)orgId);
                summary.set("taxorg", (Object)taxOrgId);
                summary.set("rule", (Object)rule);
                summary.set("skssqq", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                summary.set("skssqz", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                summary.set("income", (Object)accountingAmount.add(adjustAmount));
                String discounttype = rule.getDynamicObject("itemchoicename").getString("projtype");
                summary.set("discounttype", (Object)discounttype);
                BigDecimal rate = DiscountType.getRate((String)discounttype);
                summary.set("jjkcpercent", (Object)rate);
                BigDecimal bnyffyjjkcze = BigDecimalUtil.multiplyObject((Object)accountingAmount, (Object)rate, (int)2);
                summary.set("bnyffyjjkcze", (Object)bnyffyjjkcze);
                summaryList.add(summary);
            }
        }
    }

    private boolean isUnuseRule(DynamicObject rule) {
        return !RULE_TYPE.equals(rule.getString("type"));
    }
}

