/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.org.BastaxTaxOrgService;

@Order(value=0)
public class ApportionEngine
extends AbstractSeasonalDraftEngine {
    private ApportionService apportionService = new ApportionService();

    public ApportionEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public List<DynamicObject> calDraftData(EngineModel model) {
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(16);
        this.doSetDraftData(model, summaryList);
        this.doSetDraftEngineContextOfSummary(summaryList);
        return summaryList;
    }

    @Override
    public QFilter[] getOrgAndDateFilters(EngineModel model) {
        String orgId = model.getOrgId();
        long orgid = Long.parseLong(orgId);
        QFilter q1 = new QFilter("org", "=", (Object)orgid).or(new QFilter("taxorg", "=", (Object)orgid));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter q2 = new QFilter("skssqq", ">=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)endDate));
        return new QFilter[]{q1, q2, q3};
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return null;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getApportion().getNumber();
    }

    private void doSetDraftData(EngineModel model, List<DynamicObject> summaryList) {
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        String hoOrgId = this.queryOrgGroupDetailForAggregator(orgId, startDate, endDate);
        int seq = 1;
        for (DynamicObject bill : this.apportionService.getBranchShareBills(model)) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
            Long orgid = bill.getLong("org");
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid);
            DynamicObject taxMain = (DynamicObject)result.getData();
            summary.set("rowno", (Object)seq++);
            summary.set("org", (Object)Long.valueOf(hoOrgId));
            summary.set("taxorg", bill.getString("orgname").contains(ResManager.loadKDString((String)"\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8", (String)"ApportionEngine_0", (String)"taxc-tccit", (Object[])new Object[0])) ? Long.valueOf(0L) : bill.get("org"));
            summary.set("unifiedsocialcode", taxMain.get("taxorg.unifiedsocialcode"));
            summary.set("unifiedsocialcode1", taxMain.get("taxorg.unifiedsocialcode"));
            if ("0".equals(bill.getString("hbfnszt"))) {
                summary.set("taxorgname", (Object)bill.getString("orgname"));
                summary.set("taxorgname1", (Object)bill.getString("orgname"));
            } else {
                String taxpayer = Optional.ofNullable(BastaxTaxOrgService.getBastaxTaxorg(orgid)).map(s -> s.getString("taxpayer")).orElseGet(() -> "");
                summary.set("taxorgname", (Object)taxpayer);
                summary.set("taxorgname1", (Object)taxpayer);
            }
            summary.set("skssqq", (Object)startDate);
            summary.set("skssqz", (Object)endDate);
            summary.set("income", bill.get("income"));
            summary.set("emolument", bill.get("salary"));
            summary.set("totalassets", bill.get("asset"));
            summary.set("rate", (Object)this.getShareRate(bill));
            summaryList.add(summary);
        }
    }

    private String queryOrgGroupDetailForAggregator(String orgId, Date startDate, Date endDate) {
        String orgFuId = OrgUtils.queryOrgGroupDetailForAggregator((String)"qysds", (String)"1", (String)orgId, (Date)startDate, (Date)endDate);
        return orgFuId == null ? orgId : orgFuId;
    }

    private BigDecimal getShareRate(DynamicObject bill) {
        String sharerate = bill.getString("sharerate");
        if (StringUtil.isEmpty((CharSequence)sharerate)) {
            return BigDecimal.ZERO;
        }
        if (sharerate.contains("%")) {
            String replace = sharerate.replace("%", "");
            return new BigDecimal(replace);
        }
        return new BigDecimal(sharerate);
    }
}

