/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.AssertAcceDepreService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class AssertAcceDepreEngine
extends AbstractSeasonalDraftEngine {
    private static final Map<String, String> MAP = new LinkedHashMap<String, String>();
    private static final List<String> ENTRYTYPES = Arrays.asList("depreciate", "origin", "normal", "quick");

    public AssertAcceDepreEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public QFilter[] getOrgAndDateFilters(EngineModel model) {
        return this.getOrgAndDateEqualsFilters(model);
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.DEPRECIATE);
        return super.getRules(model);
    }

    private Map<String, Object> doGetRuleSourceData(EngineModel model, DynamicObject rule) {
        RuleEngineDto ruleEngineDto = this.buildRuleEngineDto(model, rule);
        ruleEngineDto.setPrefix((String)model.getCustom().get("entryEntityTypePrefix"));
        ruleEngineDto.setRule(rule);
        return (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"AssertAcceDepreEnginService", (String)"getRuleEnginData", (Object[])new Object[]{ruleEngineDto});
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getAssertAcce().getDetail();
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getAssertAcce().getNumber();
    }

    public void doSetDraftData(EngineModel model, List assertAccList, List assertDetailList) {
        Long orgId = Long.parseLong(model.getOrgId());
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        String declareType = (String)model.getCustom().get("declaretype");
        String draftpurpose = (String)model.getCustom().get("draftpurpose");
        if ("311".equals(declareType) || "312".equals(declareType)) {
            return;
        }
        int monthDiff = DateUtils.getMonthDiff((Date)endDate, (Date)startDate);
        String taxlimit = "month";
        if (monthDiff == 2) {
            taxlimit = "season";
        }
        List orglist = (List)model.getCustom().get("orglist");
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, ENTRYTYPES), draftTypeVoObject);
        for (Long taxOrgId : orglist) {
            model.addCustom("currentOrg", (Object)taxOrgId);
            for (DynamicObject rule : this.getRules(model)) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)this.getSummaryEntityType(model));
                object.set("rule", (Object)rule);
                object.set("org", (Object)orgId);
                object.set("taxorg", (Object)taxOrgId);
                object.set("skssqq", (Object)startDate);
                object.set("skssqz", (Object)endDate);
                object.set("taxlimit", (Object)taxlimit);
                DynamicObject depreciateType = rule.getDynamicObject("depreciatetype");
                String depreciateTypeNum = depreciateType.getString("number");
                object.set("ewblxh", (Object)depreciateTypeNum);
                object.set("ewblname", (Object)depreciateType.getString("name"));
                Long ruleId = rule.getLong("id");
                model.addCustom("entryEntityTypePrefix", (Object)"origin");
                Map<String, Object> result1Map = this.doGetRuleSourceData(model, rule);
                Map originDataMap = (Map)result1Map.get("amount_map");
                BigDecimal zcyz = this.getAmountFromDataMap(originDataMap).add(this.getAjustAmount(adjustAmounts, "zcyz", ruleId, taxOrgId));
                object.set("zcyz", (Object)zcyz);
                model.addCustom("entryEntityTypePrefix", (Object)"");
                Map<String, Object> result2Map = this.doGetRuleSourceData(model, rule);
                Map dataMap = (Map)result2Map.get("amount_map");
                BigDecimal zzzjje = this.getAmountFromDataMap(dataMap);
                BigDecimal zzzjjeAndAjust = zzzjje.add(this.getAjustAmount(adjustAmounts, "zzzjje", ruleId, taxOrgId));
                object.set("zzzjje", (Object)zzzjjeAndAjust);
                object.set("zzzjje1", (Object)zzzjje);
                model.addCustom("entryEntityTypePrefix", (Object)"normal");
                Map<String, Object> result3Map = this.doGetRuleSourceData(model, rule);
                Map normalDataMap = (Map)result3Map.get("amount_map");
                BigDecimal azssybgdjsdzjje = this.getAmountFromDataMap(normalDataMap).add(this.getAjustAmount(adjustAmounts, "azssybgdjsdzjje", ruleId, taxOrgId));
                object.set("azssybgdjsdzjje", (Object)azssybgdjsdzjje);
                model.addCustom("entryEntityTypePrefix", (Object)"quick");
                Map<String, Object> result4Map = this.doGetRuleSourceData(model, rule);
                Map quickDataMap = (Map)result4Map.get("amount_map");
                BigDecimal xsjszjyhjsdzjje = this.getAmountFromDataMap(quickDataMap);
                BigDecimal xsjszjyhjsdzjjeAndAjust = xsjszjyhjsdzjje.add(this.getAjustAmount(adjustAmounts, "xsjszjyhjsdzjje", ruleId, taxOrgId));
                object.set("xsjszjyhjsdzjje", (Object)xsjszjyhjsdzjjeAndAjust);
                object.set("xsjszjyhjsdzjje1", (Object)xsjszjyhjsdzjje);
                DynamicObject preData = AssertAcceDepreService.getPreData(taxOrgId, rule.getLong("id"), startDate, endDate, this.getSummaryEntityType(model), draftpurpose);
                BigDecimal preadjustamount = preData == null ? BigDecimal.ZERO : preData.getBigDecimal("currentadjustamount");
                object.set("preadjustamount", (Object)preadjustamount);
                BigDecimal currentadjustamount = xsjszjyhjsdzjje.subtract(zzzjje);
                BigDecimal currentadjustamountAndAjust = xsjszjyhjsdzjjeAndAjust.subtract(zzzjjeAndAjust);
                object.set("currentadjustamount1", (Object)currentadjustamount);
                boolean preGreaterThanCurr = preData != null && preadjustamount.compareTo(currentadjustamount) > 0;
                currentadjustamount = preGreaterThanCurr ? preadjustamount : currentadjustamountAndAjust;
                object.set("currentadjustamount", (Object)currentadjustamount);
                if (preGreaterThanCurr && preData != null) {
                    object.set("zcyz", (Object)preData.getBigDecimal("zcyz"));
                    object.set("zzzjje", (Object)preData.getBigDecimal("zzzjje"));
                    object.set("azssybgdjsdzjje", (Object)preData.getBigDecimal("azssybgdjsdzjje"));
                    object.set("xsjszjyhjsdzjje", (Object)preData.getBigDecimal("xsjszjyhjsdzjje"));
                    object.set("ispredata", (Object)"1");
                }
                assertDetailList.addAll((List)result1Map.get("account_detail"));
                assertDetailList.addAll((List)result2Map.get("account_detail"));
                assertDetailList.addAll((List)result3Map.get("account_detail"));
                assertDetailList.addAll((List)result4Map.get("account_detail"));
                assertAccList.add(object);
            }
        }
    }

    private BigDecimal getAjustAmount(DynamicObject[] adjustAmounts, String columnType, Long ruleId, Long taxOrgId) {
        BigDecimal adjustAmount = BigDecimal.ZERO;
        DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> {
            boolean equalOrg = taxOrgId.equals(s.getLong("taxorg"));
            boolean equalEntrytype = s.getString("entrytype").equals(MAP.get(columnType));
            boolean equalRule = s.getLong("ruleid") == ruleId.longValue();
            return equalOrg & equalEntrytype & equalRule;
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return adjustAmount;
    }

    private BigDecimal getAmountFromDataMap(Map<String, List<BigDecimal>> dataMap) {
        BigDecimal total = BigDecimal.ZERO;
        for (Map.Entry<String, List<BigDecimal>> entry : dataMap.entrySet()) {
            for (BigDecimal amount : entry.getValue()) {
                total = BigDecimalUtil.addObject((Object)total, (Object)amount);
            }
        }
        return total;
    }

    static {
        MAP.put("zcyz", "origin");
        MAP.put("zzzjje", "depreciate");
        MAP.put("azssybgdjsdzjje", "normal");
        MAP.put("xsjszjyhjsdzjje", "quick");
        MAP.put("zzzjje1", "depreciate");
        MAP.put("xsjszjyhjsdzjje1", "quick");
    }
}

