/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class AssetsDataEngine
extends AbstractSeasonalDraftEngine {
    private static final List<String> CELL_TYPES = Arrays.asList("021", "022");

    public AssetsDataEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public QFilter[] getOrgAndDateFilters(EngineModel model) {
        return this.getOrgAndDateEqualsFilters(model);
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        String cellType = (String)model.getCustom().get("cellType");
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.PROFITS);
        List ruleList = super.getRules(model);
        return (List)ruleList.stream().filter(s -> cellType.equals(s.getDynamicObject("item").getString("number"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjAssets().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_YJ_ASSETS_ACCDET;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjAssets().getNumber();
    }

    public void doSetDraftData(EngineModel model, List summaryList, List summaryAccountingList) {
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(Long.parseLong(orgId)), startDate, endDate, Collections.singletonList("yjassets")), draftTypeVoObject);
        for (String cellType : CELL_TYPES) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
            summary.set("org", (Object)orgId);
            summary.set("type", (Object)cellType);
            summary.set("skssqq", (Object)startDate);
            summary.set("skssqz", (Object)endDate);
            model.addCustom("cellType", (Object)cellType);
            List<DynamicObject> account = this.getRuleSourceData(model);
            summaryAccountingList.addAll(account);
            DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals(cellType) || s.getString("itemnumber").equals(cellType + "_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            BigDecimal adjustAmount = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)collect)) {
                adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal bqamount = this.sumAccountingAmount(account).add(adjustAmount).divide(new BigDecimal("10000"), 2, 4);
            summary.set("bqamount", (Object)bqamount);
            summary.set("bjamount", this.calBjamount(bqamount, cellType, model));
            summaryList.add(summary);
        }
    }

    private Object calBjamount(BigDecimal bqamount, String type, EngineModel model) {
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        String draftPurpose = model.getCustom().getOrDefault("draftpurpose", "nssb");
        Boolean isAjflag = DeadlineService.getDeadline(orgId, draftPurpose);
        if ("021".equals(type)) {
            if (isAjflag.booleanValue()) {
                return bqamount;
            }
            int monthOfDate = DateUtils.getMonthOfDate((Date)startDate);
            if (Lists.newArrayList((Object[])new Integer[]{1, 4, 7, 10}).contains(monthOfDate)) {
                return bqamount;
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            Date firstDateOfMonth = DateUtils.getFirstDateOfSeason((Date)startDate);
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth2((Date)firstDateOfMonth);
            QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)firstDateOfMonth);
            QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)lastDateOfMonth);
            QFilter typeFilter = new QFilter("type", "=", (Object)"021");
            DynamicObject object = QueryServiceHelper.queryOne((String)draftTypeVoObject.getYjAssets().getNumber(), (String)"type,bqamount,bjamount", (QFilter[])new QFilter[]{orgFilter, typeFilter, skssqqFilter, skssqzFilter});
            if (object == null) {
                return BigDecimal.ZERO;
            }
            return object.getBigDecimal("bqamount");
        }
        if ("022".equals(type)) {
            return bqamount;
        }
        return BigDecimal.ZERO;
    }

    @Override
    boolean isBranch(String declareType) {
        Boolean result = Boolean.FALSE;
        if ("311".equals(declareType) || "312".equals(declareType)) {
            result = Boolean.TRUE;
        } else if ("210".equals(declareType) || "220".equals(declareType) || "230".equals(declareType)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private Map<String, List<DynamicObject>> getLastPeriodSummaryMap(String orgId, Date startDate, Date endDate, Boolean isAjsb, String entityName) {
        QFilter skssqz;
        QFilter skssqq;
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        if (isAjsb.booleanValue()) {
            skssqq = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)startDate, (int)-3));
            skssqz = new QFilter("skssqz", "=", (Object)DateUtils.addMonth((Date)endDate, (int)-3));
        } else {
            Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)startDate);
            Date date = DateUtils.addMonth((Date)lastDateOfSeason, (int)-3);
            Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)date);
            Date lastDateOfMonth = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)date));
            skssqq = new QFilter("skssqq", "=", (Object)firstDateOfMonth);
            skssqz = new QFilter("skssqz", "=", (Object)lastDateOfMonth);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"type,bqamount,bjamount", (QFilter[])new QFilter[]{q1, skssqq, skssqz});
        return query.stream().collect(Collectors.groupingBy(e -> e.getString("type")));
    }
}

