/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.enums.DiscountType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.constant.DiscountTypeConstant;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class IncredEngine
extends AbstractSeasonalDraftEngine {
    private static final String RULE_TYPE = "3";
    private BigDecimal wbw = new BigDecimal("5000000");
    private BigDecimal TWO_THOUSAND_W = new BigDecimal("20000000");

    public IncredEngine(DraftEngineContext context) {
        super(context);
    }

    public void putOtherFiltersDelDraftTables(Map delMap, EngineModel model) {
        ArrayList qFilters = Lists.newArrayList((Object[])this.getOrgAndDateFilters(model));
        qFilters.add(new QFilter("type", "=", (Object)RULE_TYPE));
        delMap.put(this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber(), qFilters.toArray(new QFilter[0]));
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.INCOME);
        return super.getRules(model);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjIncred().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_INCRED_ACCDETAIL;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjIncred().getNumber();
    }

    public void doHandleRelateData(EngineModel model, List summaryList) {
        List<DynamicObject> relateList = NontaxService.getHandleSummaryMiddleResult(summaryList, RULE_TYPE, "incredtotal", 3, true, 1, this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber());
        this.getDraftEngineContext().getSummaryDataMap().put(this.getRelateDataMapKey(), relateList);
    }

    public void doSetDraftData(EngineModel model, List summaryList, List summaryAccountingList) {
        Long orgId = Long.parseLong(model.getOrgId());
        List orglist = (List)model.getCustom().get("orglist");
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = this.getLastTaxMap(model, this.getSummaryEntityType(model));
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, Collections.singletonList("incredincome")), draftTypeVoObject);
        for (Long taxOrgId : orglist) {
            model.addCustom("currentOrg", (Object)taxOrgId);
            for (DynamicObject rule : this.getRules(model)) {
                if (this.isRuleUnuseful(rule)) continue;
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
                String serialNo = UUID.randomUUID().toString();
                model.addCustom("serialNo", (Object)serialNo);
                List accountingList = this.getRuleSourceData(model, rule);
                summaryAccountingList.addAll(accountingList);
                summary.set("serialno", (Object)serialNo);
                summary.set("org", (Object)Long.parseLong(model.getOrgId()));
                summary.set("taxorg", (Object)taxOrgId);
                summary.set("rule", (Object)rule);
                summary.set("skssqq", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                summary.set("skssqz", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                BigDecimal adjustAmount = BigDecimal.ZERO;
                DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(rule.getString("id"))).filter(s -> s.getLong("taxorg") == taxOrgId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
                if (!CollectionUtils.isEmpty((Collection)collect)) {
                    adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal incredIncome = this.sumAccountingAmount(accountingList).add(adjustAmount);
                summary.set("incredincome", (Object)incredIncome);
                Date dateField = rule.getDate("datefield");
                String discountType = rule.getDynamicObject("itemchoicename").getString("projtype");
                summary.set("discounttype", (Object)discountType);
                BigDecimal reductionRatio = this.getReductionRatio(discountType, startDate, dateField);
                summary.set("reductratio", (Object)reductionRatio);
                BigDecimal incredPresent = this.getIncredpresent(incredIncome, discountType, reductionRatio);
                summary.set("incredpresent", (Object)incredPresent);
                BigDecimal lastIncredTotal = lastTaxMap.get(taxOrgId + "#" + rule.getString("id"));
                summary.set("incredtotal", (Object)BigDecimalUtil.addObject((Object)incredPresent, (Object)lastIncredTotal));
                summaryList.add(summary);
            }
        }
    }

    private boolean isRuleUnuseful(DynamicObject rule) {
        DynamicObject itemChoiceName = rule.getDynamicObject("itemchoicename");
        if (itemChoiceName == null) {
            return true;
        }
        return !RULE_TYPE.equals(rule.getString("type")) || DiscountTypeConstant.techIds.contains(itemChoiceName.getLong("id"));
    }

    Map<String, BigDecimal> getLastTaxMap(EngineModel model, String entityName) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = new HashMap<String, BigDecimal>();
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        if ("season".equals(taxLimit)) {
            if (startDate.getMonth() >= 3) {
                lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 3, entityName);
            }
        } else if (startDate.getMonth() >= 1) {
            lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 1, entityName);
        }
        return lastTaxMap;
    }

    private Map<String, BigDecimal> getLastPeriodBigDecimalMap(Date startDate, Date endDate, QFilter orgFilter, int monthcount, String entityName) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(-monthcount));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)date);
        Date d2 = DateUtils.addMonth((Date)endDate, (int)(-monthcount));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)d2)));
        DynamicObjectCollection lastCols = QueryServiceHelper.query((String)entityName, (String)"taxorg,rule,incredtotal", (QFilter[])new QFilter[]{skssqqFilter, skssqzFilter, orgFilter});
        Map<String, BigDecimal> lastTaxMap = lastCols.stream().collect(Collectors.toMap(e -> e.getLong("taxorg") + "#" + e.getLong("rule"), f -> f.getBigDecimal("incredtotal")));
        return lastTaxMap;
    }

    private BigDecimal getIncredpresent(BigDecimal incredincome, String discounttype, BigDecimal reductRatio) {
        BigDecimal incredpresent = "6".equals(discounttype) && incredincome.compareTo(this.wbw) > 0 ? incredincome.subtract(this.wbw).multiply(reductRatio).add(this.wbw) : ("12".equals(discounttype) && incredincome.compareTo(this.TWO_THOUSAND_W) > 0 ? incredincome.subtract(this.TWO_THOUSAND_W).multiply(reductRatio).add(this.TWO_THOUSAND_W) : BigDecimalUtil.multiplyObject((Object)incredincome, (Object)reductRatio, (int)2));
        return incredpresent;
    }

    private BigDecimal getReductionRatio(String discounttype, Date startDate, Date datefield) {
        int diff = 0;
        int year = DateUtils.getYearOfDate((Date)startDate);
        if (datefield != null) {
            int year1 = DateUtils.getYearOfDate((Date)datefield);
            diff = year - year1;
        }
        BigDecimal redctionRatio = DiscountType.getRate((String)discounttype);
        switch (discounttype) {
            case "5": {
                if (diff >= 0 && diff < 3) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                if (diff >= 3 && diff <= 5) {
                    redctionRatio = new BigDecimal("0.5");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
            case "7": {
                if (diff >= 0 && diff < 2) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                if (diff >= 2 && diff <= 4) {
                    redctionRatio = new BigDecimal("0.5");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
            case "8": {
                if (diff >= 0 && diff < 5) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                if (diff >= 5 && diff <= 9) {
                    redctionRatio = new BigDecimal("0.5");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
            case "13": {
                if (diff < 0) {
                    redctionRatio = new BigDecimal("0");
                    break;
                }
                if (diff >= 0 && diff <= 9) {
                    redctionRatio = new BigDecimal("1");
                    break;
                }
                redctionRatio = new BigDecimal("0");
                break;
            }
        }
        return redctionRatio;
    }
}

