/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.enums.DiscountType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class NontaxEngine
extends AbstractSeasonalDraftEngine {
    private static final String RULE_TYPE = "1";

    public NontaxEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjNontax().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_NONTAX_ACCDETAIL;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjNontax().getNumber();
    }

    public void putOtherFiltersDelDraftTables(Map delMap, EngineModel model) {
        ArrayList qFilters = Lists.newArrayList((Object[])this.getOrgAndDateFilters(model));
        qFilters.add(new QFilter("type", "=", (Object)RULE_TYPE));
        delMap.put(this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber(), qFilters.toArray(new QFilter[0]));
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.INCOME);
        return super.getRules(model);
    }

    public void doHandleRelateData(EngineModel model, List summaryList) {
        List<DynamicObject> relateList = NontaxService.getHandleSummaryMiddleResult(summaryList, RULE_TYPE, "nontaxtotal", 3, 1, this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber());
        this.getDraftEngineContext().getSummaryDataMap().put(this.getRelateDataMapKey(), relateList);
    }

    public void doSetDraftData(EngineModel model, List summaryList, List summaryAccountingList) {
        Long orgId = Long.parseLong(model.getOrgId());
        List orgList = (List)model.getCustom().get("orglist");
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = this.getLastTaxMap(model, this.getSummaryEntityType(model));
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, Collections.singletonList("nontaxincome")), draftTypeVoObject);
        for (Long taxOrgId : orgList) {
            model.addCustom("currentOrg", (Object)taxOrgId);
            for (DynamicObject rule : this.getRules(model)) {
                String type = rule.getString("type");
                if (!RULE_TYPE.equals(type)) continue;
                String serialNo = UUID.randomUUID().toString();
                model.addCustom("serialNo", (Object)serialNo);
                List accountingList = this.getRuleSourceData(model, rule);
                summaryAccountingList.addAll(accountingList);
                BigDecimal adjustAmount = BigDecimal.ZERO;
                DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(rule.getString("id"))).filter(s -> s.getLong("taxorg") == taxOrgId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
                if (!CollectionUtils.isEmpty((Collection)collect)) {
                    adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal nontaxIncome = this.sumAccountingAmount(accountingList).add(adjustAmount);
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
                summary.set("serialno", (Object)serialNo);
                summary.set("org", (Object)orgId);
                summary.set("taxorg", (Object)taxOrgId);
                summary.set("rule", (Object)rule);
                summary.set("skssqq", (Object)startDate);
                summary.set("skssqz", (Object)endDate);
                summary.set("nontaxincome", (Object)nontaxIncome);
                DynamicObject itemChoiceName = rule.getDynamicObject("itemchoicename");
                String discountType = itemChoiceName.getString("projtype");
                summary.set("discounttype", (Object)discountType);
                BigDecimal rate = DiscountType.getRate((String)discountType);
                BigDecimal nontaxpresent = BigDecimalUtil.multiplyObject((Object)nontaxIncome, (Object)rate, (int)2);
                summary.set("nontaxpresent", (Object)nontaxpresent);
                BigDecimal lastnontaxtotal = lastTaxMap.get(taxOrgId + "#" + rule.getString("id"));
                summary.set("nontaxtotal", (Object)BigDecimalUtil.addObject((Object)nontaxpresent, (Object)lastnontaxtotal));
                summaryList.add(summary);
            }
        }
    }

    Map<String, BigDecimal> getLastTaxMap(EngineModel model, String entityName) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = new HashMap<String, BigDecimal>();
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        if ("season".equals(taxLimit)) {
            if (startDate.getMonth() >= 3) {
                lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 3, entityName);
            }
        } else if (startDate.getMonth() >= 1) {
            lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 1, entityName);
        }
        return lastTaxMap;
    }

    private Map<String, BigDecimal> getLastPeriodBigDecimalMap(Date startDate, Date endDate, QFilter orgFilter, int monthcount, String entityName) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(-monthcount));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)date);
        Date d2 = DateUtils.addMonth((Date)endDate, (int)(-monthcount));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)d2)));
        DynamicObjectCollection lastCols = QueryServiceHelper.query((String)entityName, (String)"taxorg,rule,nontaxtotal", (QFilter[])new QFilter[]{skssqqFilter, skssqzFilter, orgFilter});
        Map<String, BigDecimal> lastTaxMap = lastCols.stream().collect(Collectors.toMap(e -> e.getLong("taxorg") + "#" + e.getLong("rule"), f -> f.getBigDecimal("nontaxtotal")));
        return lastTaxMap;
    }
}

