/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class RealEstateSpeBizEngine
extends AbstractSeasonalDraftEngine {
    public static final String NUMBER_001 = "001";
    public static final String NUMBER_002 = "002";
    public static final String NUMBER_003 = "003";
    public static final String NUMBER_004 = "004";
    public static final String NUMBER_005 = "005";
    public static final String NUMBER_006 = "006";
    public static final String NUMBER_007 = "007";
    public static final String NUMBER_008 = "008";
    public static final String NUMBER_009 = "009";
    public static final List<String> ITEMS = Arrays.asList("001", "002", "003", "004", "005", "006", "007", "008", "009");

    public RealEstateSpeBizEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public QFilter[] getOrgAndDateFilters(EngineModel model) {
        return this.getOrgAndDateEqualsFilters(model);
    }

    @Override
    public String[] getDelDraftTables(EngineModel model) {
        return new String[]{this.getAccountEntityType(model), this.getSummaryEntityType(model), this.getSummary1EntityType(model)};
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.YJ_OTHER);
        return super.getRules(model);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getFdctdywMle().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_YJ_OTHER_ACCDET;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getFdctdywMle().getNumber();
    }

    protected String getSummary1EntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getFdctdywNstz().getNumber();
    }

    @Override
    public List<DynamicObject> calDraftData(EngineModel model) {
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summary1List = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        this.doSetDraftData(model, summaryList, summary1List, summaryAccountingList);
        this.doSetDraftEngineContext(summaryList, summary1List, summaryAccountingList);
        return summaryList;
    }

    void doSetDraftEngineContext(List<DynamicObject> summaryList, List<DynamicObject> summary1List, List<DynamicObject> summaryAccountingList) {
        this.doSetDraftEngineContext(summaryList, summaryAccountingList);
        this.draftEngineContext.getSummaryDataMap().put(this.getSummaryDataMapKey().concat("1"), summary1List);
    }

    private void doSetDraftData(EngineModel model, List<DynamicObject> summaryList, List<DynamicObject> summary1List, List<DynamicObject> summaryAccountingList) {
        this.doSetSummary(model, summaryList, summaryAccountingList);
        this.doSetSummary1(model, summary1List, summaryList);
    }

    private void doSetSummary1(EngineModel model, List<DynamicObject> summary1List, List<DynamicObject> summaryList) {
        Long orgId = Long.parseLong(model.getOrgId());
        Map<String, BigDecimal> lastTaxMap = this.getLastTaxMap(model);
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        AdjustAmountDto adjustAmountDto = new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, Collections.singletonList("yjother"));
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, adjustAmountDto, draftTypeVoObject);
        Map<String, BigDecimal> cellAmountMap = this.getEachItemAmount(summaryList, orgId, lastTaxMap, adjustAmounts);
        for (String type : ITEMS) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummary1EntityType(model)));
            summary.set("itemnumber", (Object)type);
            summary.set("org", (Object)orgId);
            summary.set("taxorg", (Object)orgId);
            summary.set("skssqq", (Object)DateUtils.stringToDate((String)model.getStartDate()));
            summary.set("skssqz", (Object)DateUtils.stringToDate((String)model.getEndDate()));
            summary.set("entrytype", (Object)"yjother");
            summary.set("sqbnljje", (Object)lastTaxMap.getOrDefault(orgId + "#" + type, BigDecimal.ZERO));
            summary.set("bqje", (Object)cellAmountMap.get(this.getBqjeKey(type)));
            summary.set("bnljje", (Object)cellAmountMap.get(this.getBnljjeKey(type)));
            summary1List.add(summary);
        }
    }

    private void doSetSummary(EngineModel model, List<DynamicObject> summaryList, List<DynamicObject> summaryAccountingList) {
        Long orgId = Long.parseLong(model.getOrgId());
        List orgList = (List)model.getCustom().get("orglist");
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        AdjustAmountDto adjustAmountDto = new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, Collections.singletonList("yjother"));
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, adjustAmountDto, draftTypeVoObject);
        for (Long taxOrgId : orgList) {
            model.addCustom("currentOrg", (Object)taxOrgId);
            for (DynamicObject rule : this.getRules(model)) {
                String itemNumber = rule.getDynamicObject("item").getString("number");
                String serialNo = UUID.randomUUID().toString();
                model.addCustom("serialNo", (Object)serialNo);
                List accountingList = this.getRuleSourceData(model, rule);
                summaryAccountingList.addAll(accountingList);
                DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> taxOrgId.equals(s.getLong("taxorg")) && (s.getString("itemnumber").equals(itemNumber) || s.getString("itemnumber").equals(itemNumber + "_"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                BigDecimal adjustAmount = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty((Collection)collect) && !Arrays.asList("30102", "30104").contains(itemNumber)) {
                    adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal bqsrje = this.sumAccountingAmount(accountingList).add(adjustAmount);
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
                summary.set("serialno", (Object)serialNo);
                summary.set("org", (Object)orgId);
                summary.set("taxorg", (Object)taxOrgId);
                summary.set("skssqq", (Object)startDate);
                summary.set("skssqz", (Object)endDate);
                summary.set("ruleid", (Object)rule);
                summary.set("itemnumber", (Object)itemNumber);
                summary.set("bqsrje", (Object)bqsrje);
                summaryList.add(summary);
            }
        }
    }

    private Map<String, BigDecimal> getEachItemAmount(List<DynamicObject> summaryList, Long orgId, Map<String, BigDecimal> lastTaxMap, DynamicObject[] adjustAmounts) {
        BigDecimal totalBqsrje = BigDecimal.ZERO;
        BigDecimal totalBqje = BigDecimal.ZERO;
        BigDecimal totalEndBqsrje = BigDecimal.ZERO;
        BigDecimal totalEndBqje = BigDecimal.ZERO;
        for (DynamicObject summary : summaryList) {
            switch (summary.getString("itemnumber")) {
                case "30101": {
                    totalBqsrje = BigDecimalUtil.addObject((Object)totalBqsrje, (Object)summary.getBigDecimal("bqsrje"));
                    break;
                }
                case "30102": {
                    totalBqje = BigDecimalUtil.addObject((Object)totalBqje, (Object)summary.getBigDecimal("bqsrje"));
                    break;
                }
                case "30103": {
                    totalEndBqsrje = BigDecimalUtil.addObject((Object)totalEndBqsrje, (Object)summary.getBigDecimal("bqsrje"));
                    break;
                }
                case "30104": {
                    totalEndBqje = BigDecimalUtil.addObject((Object)totalEndBqje, (Object)summary.getBigDecimal("bqsrje"));
                }
            }
        }
        DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals("30102") || s.getString("itemnumber").equals("30102_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        BigDecimal adjustAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        totalBqje = totalBqje.add(adjustAmount);
        collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals("30104") || s.getString("itemnumber").equals("30104_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        adjustAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        totalEndBqje = totalEndBqje.add(adjustAmount);
        return this.doSetEachItemAmount(orgId, lastTaxMap, totalBqsrje, totalBqje, totalEndBqsrje, totalEndBqje);
    }

    private Map<String, BigDecimal> doSetEachItemAmount(Long orgId, Map<String, BigDecimal> lastTaxMap, BigDecimal totalBqsrje, BigDecimal totalBqje, BigDecimal totalEndBqsrje, BigDecimal totalEndBqje) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(32);
        result.put(this.getBqjeKey(ITEMS.get(0)), totalBqsrje);
        result.put(this.getBnljjeKey(ITEMS.get(0)), BigDecimalUtil.addObject((Object)totalBqsrje, (Object)this.getLastTaxMapValue(orgId, lastTaxMap, 0)));
        result.put(this.getBqjeKey(ITEMS.get(1)), BigDecimal.ZERO);
        result.put(this.getBnljjeKey(ITEMS.get(1)), this.getLastTaxMapValue(orgId, lastTaxMap, 1));
        result.put(this.getBqjeKey(ITEMS.get(2)), totalBqje);
        result.put(this.getBnljjeKey(ITEMS.get(2)), BigDecimalUtil.addObject((Object)totalBqje, (Object)this.getLastTaxMapValue(orgId, lastTaxMap, 2)));
        result.put(this.getBqjeKey(ITEMS.get(3)), BigDecimalUtil.subtractObject(result.get(this.getBqjeKey(ITEMS.get(1))), result.get(this.getBqjeKey(ITEMS.get(2)))));
        result.put(this.getBnljjeKey(ITEMS.get(3)), BigDecimalUtil.subtractObject(result.get(this.getBnljjeKey(ITEMS.get(2))), result.get(this.getBnljjeKey(ITEMS.get(2)))));
        result.put(this.getBqjeKey(ITEMS.get(4)), totalEndBqsrje);
        result.put(this.getBnljjeKey(ITEMS.get(4)), BigDecimalUtil.subtractObject((Object)totalEndBqsrje, (Object)this.getLastTaxMapValue(orgId, lastTaxMap, 4)));
        result.put(this.getBqjeKey(ITEMS.get(5)), BigDecimal.ZERO);
        result.put(this.getBnljjeKey(ITEMS.get(5)), this.getLastTaxMapValue(orgId, lastTaxMap, 5));
        result.put(this.getBqjeKey(ITEMS.get(6)), totalEndBqje);
        result.put(this.getBnljjeKey(ITEMS.get(6)), BigDecimalUtil.subtractObject((Object)totalEndBqje, (Object)this.getLastTaxMapValue(orgId, lastTaxMap, 6)));
        result.put(this.getBqjeKey(ITEMS.get(7)), BigDecimalUtil.subtractObject(result.get(this.getBqjeKey(ITEMS.get(5))), result.get(this.getBqjeKey(ITEMS.get(6)))));
        result.put(this.getBnljjeKey(ITEMS.get(7)), BigDecimalUtil.subtractObject(result.get(this.getBnljjeKey(ITEMS.get(5))), result.get(this.getBnljjeKey(ITEMS.get(6)))));
        result.put(this.getBqjeKey(ITEMS.get(8)), BigDecimalUtil.subtractObject(result.get(this.getBqjeKey(ITEMS.get(3))), result.get(this.getBqjeKey(ITEMS.get(7)))));
        result.put(this.getBnljjeKey(ITEMS.get(8)), BigDecimalUtil.subtractObject(result.get(this.getBnljjeKey(ITEMS.get(3))), result.get(this.getBnljjeKey(ITEMS.get(7)))));
        return result;
    }

    private BigDecimal getLastTaxMapValue(Long orgId, Map<String, BigDecimal> lastTaxMap, int i) {
        return lastTaxMap.getOrDefault(orgId + "#" + ITEMS.get(i), BigDecimal.ZERO);
    }

    private String getBqjeKey(String item) {
        return item.concat("bqje");
    }

    private String getBnljjeKey(String item) {
        return item.concat("bnljje");
    }

    Map<String, BigDecimal> getLastTaxMap(EngineModel model) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = new HashMap<String, BigDecimal>();
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        if ("season".equals(taxLimit)) {
            if (startDate.getMonth() >= 3) {
                lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 3, this.getSummary1EntityType(model));
            }
        } else if (startDate.getMonth() >= 1) {
            lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 1, this.getSummary1EntityType(model));
        }
        return lastTaxMap;
    }

    private Map<String, BigDecimal> getLastPeriodBigDecimalMap(Date startDate, Date endDate, QFilter orgFilter, int monthcount, String entityName) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(-monthcount));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)date);
        Date d2 = DateUtils.addMonth((Date)endDate, (int)(-monthcount));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)d2)));
        DynamicObjectCollection lastCols = QueryServiceHelper.query((String)entityName, (String)"taxorg,itemnumber,bnljje", (QFilter[])new QFilter[]{skssqqFilter, skssqzFilter, orgFilter});
        return lastCols.stream().collect(Collectors.toMap(e -> e.getLong("taxorg") + "#" + e.getString("itemnumber"), f -> f.getBigDecimal("bnljje")));
    }
}

