/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.AddDeductionEngine;
import kd.taxc.tccit.business.engine.refactoring.AssertAcceDepreEngine;
import kd.taxc.tccit.business.engine.refactoring.IncredEngine;
import kd.taxc.tccit.business.engine.refactoring.NontaxEngine;
import kd.taxc.tccit.business.engine.refactoring.RealEstateSpeBizEngine;
import kd.taxc.tccit.business.engine.refactoring.TaxpayEngine;
import kd.taxc.tccit.business.engine.refactoring.TechTransEngine;
import kd.taxc.tccit.business.engine.refactoring.TreducedEngine;
import kd.taxc.tccit.business.engine.refactoring.ZeroRatingInEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import org.apache.commons.collections.CollectionUtils;

@Order(value=2)
public class RecoupDeficitEngine
extends AbstractSeasonalDraftEngine {
    private static final List<String> ITEMS = Arrays.asList("item1", "item2", "item3", "item4", "item5", "item6", "item7", "item8", "item9", "item10");
    private String AMOUNTRESOURCE = "amountresource";

    public RecoupDeficitEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public List<DynamicObject> calDraftData(EngineModel model) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ITEMS.size());
        this.doSetDraftData(model, list);
        this.doSetDraftEngineContextOfSummary(list);
        return list;
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return null;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getRecoupDeficit().getNumber();
    }

    private void doSetDraftData(EngineModel model, List<DynamicObject> list) {
        Long orgId = Long.parseLong(model.getOrgId());
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, Collections.singletonList("recoup_deficit_amount")), draftTypeVoObject);
        HashMap<String, String> amountResourceMap = new HashMap<String, String>();
        Map<String, BigDecimal> amountMap = this.getEachItemAmount(model, amountResourceMap, adjustAmounts);
        for (String item : ITEMS) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
            summary.set("org", (Object)model.getOrgId());
            summary.set("item", (Object)item);
            summary.set("skssqq", (Object)DateUtils.stringToDate((String)model.getStartDate()));
            summary.set("skssqz", (Object)DateUtils.stringToDate((String)model.getEndDate()));
            summary.set("amount", (Object)amountMap.get(item));
            if ("item8".equals(item)) {
                summary.set("amountresource", amountResourceMap.get(item + this.AMOUNTRESOURCE));
            }
            list.add(summary);
        }
    }

    public Map<String, BigDecimal> getEachItemAmount(EngineModel model, Map<String, String> amountResourceMap, DynamicObject[] adjustAmounts) {
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map customParams = model.getCustom();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Boolean showNontax = Boolean.valueOf((String)customParams.get("shownontax"));
        Boolean showTeduced = Boolean.valueOf((String)customParams.get("showtreduced"));
        String declaretype = (String)customParams.get("declaretype");
        boolean showAssert = !"311".equals(declaretype) && !"312".equals(declaretype);
        Boolean showIncred = Boolean.valueOf((String)customParams.get("showincred"));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)endDate);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(ITEMS.size());
        BigDecimal amount1 = this.getAmount1(orgFilter, startFilter, endFilter, draftTypeObjectVo);
        result.put(ITEMS.get(0), amount1);
        BigDecimal amount2 = this.getAmount2(orgFilter, startFilter, endFilter, draftTypeObjectVo);
        result.put(ITEMS.get(1), amount2);
        BigDecimal amount3 = this.getAmount3(orgFilter, startFilter, endFilter, draftTypeObjectVo);
        result.put(ITEMS.get(2), amount3);
        BigDecimal amount4 = this.getAmount4(orgFilter, startFilter, endFilter, startDate, showNontax, showTeduced, draftTypeObjectVo);
        result.put(ITEMS.get(3), amount4);
        BigDecimal amount5 = this.getAmount5(orgFilter, startFilter, endFilter, showAssert, draftTypeObjectVo);
        result.put(ITEMS.get(4), amount5);
        BigDecimal amount6 = this.getAmount6(orgFilter, startFilter, endFilter, showIncred, draftTypeObjectVo);
        result.put(ITEMS.get(5), amount6);
        BigDecimal amount7 = amount1.add(amount2).subtract(amount3).subtract(amount4).subtract(amount5).subtract(amount6);
        result.put(ITEMS.get(6), amount7);
        BigDecimal ajustAmount = BigDecimal.ZERO;
        if (adjustAmounts != null && adjustAmounts.length > 0) {
            ajustAmount = adjustAmounts[0].getBigDecimal("adjustamount");
        }
        BigDecimal amount8 = this.getAmount8(orgFilter, startDate, endDate, amountResourceMap, draftTypeObjectVo).add(ajustAmount);
        result.put(ITEMS.get(7), amount8);
        BigDecimal amount9 = amount7.doubleValue() <= 0.0 ? BigDecimal.ZERO : amount7.min(amount8);
        result.put(ITEMS.get(8), amount9);
        result.put(ITEMS.get(9), amount7.subtract(amount9));
        return result;
    }

    private BigDecimal getAmount8(QFilter orgFilter, Date startDate, Date endDate, Map<String, String> amountResourceMap, DraftTypeObjectVo draftTypeObjectVo) {
        BigDecimal amount8;
        QFilter orderfilter;
        QFilter declarestatusFilter;
        QFilter typeFilter;
        LocalDateTime endDayOfLastYear;
        QFilter endFilter;
        LocalDateTime firstDayOfLastYear = LocalDateUtils.date2LocalDateTime(startDate).minusYears(1L).with(TemporalAdjusters.firstDayOfYear());
        QFilter startFilter = new QFilter("skssqq", "=", (Object)firstDayOfLastYear);
        DynamicObject declare = QueryServiceHelper.queryOne((String)"tccit_quarterly_report", (String)"id,billno,declarestatus", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter = new QFilter("skssqz", "=", (Object)(endDayOfLastYear = LocalDateUtils.date2LocalDateTime(endDate).minusYears(1L).with(TemporalAdjusters.lastDayOfYear()))), typeFilter = new QFilter("type", "=", (Object)"qysdsnb"), declarestatusFilter = new QFilter("declarestatus", "=", (Object)"declared")});
        if (declare == null) {
            DynamicObject lastPeriodData = this.getLastPeriodData(orgFilter, startDate, draftTypeObjectVo);
            if (lastPeriodData == null) {
                return BigDecimal.ZERO;
            }
            amountResourceMap.put(ITEMS.get(7) + this.AMOUNTRESOURCE, "lastdraft");
            return lastPeriodData.getBigDecimal("amount");
        }
        String nxxId = declare.getString("id");
        QFilter billnofilter = new QFilter("sbbid", "=", (Object)nxxId);
        DynamicObject result = QueryServiceHelper.queryOne((String)"tccit_qysds_a106000", (String)"kjz", (QFilter[])new QFilter[]{billnofilter, orderfilter = new QFilter("ewblxh", "=", (Object)"12")});
        BigDecimal bigDecimal = result == null ? BigDecimal.ZERO : (amount8 = result.getBigDecimal("kjz").doubleValue() <= 0.0 ? BigDecimal.ZERO : result.getBigDecimal("kjz"));
        if (amount8.compareTo(BigDecimal.ZERO) > 0) {
            amountResourceMap.put(ITEMS.get(7) + this.AMOUNTRESOURCE, "lastdeclare");
        }
        return amount8;
    }

    private DynamicObject getLastPeriodData(QFilter orgFilter, Date startDate, DraftTypeObjectVo draftTypeObjectVo) {
        Date lastDateOfMonth;
        int lastyearOfDate;
        int yearOfDate = DateUtils.getYearOfDate((Date)startDate);
        if (yearOfDate != (lastyearOfDate = DateUtils.getYearOfDate((Date)(lastDateOfMonth = DateUtils.getLastDateOfMonth1((Date)DateUtils.addMonth((Date)startDate, (int)-1)))))) {
            return null;
        }
        QFilter endFilter = new QFilter("skssqz", "=", (Object)lastDateOfMonth);
        QFilter itemFilter = new QFilter("item", "=", (Object)"item8");
        return QueryServiceHelper.queryOne((String)draftTypeObjectVo.getRecoupDeficit().getNumber(), (String)"amount", (QFilter[])new QFilter[]{orgFilter, endFilter, itemFilter});
    }

    private BigDecimal getAmount6(QFilter orgFilter, QFilter startFilter, QFilter endFilter, Boolean showIncred, DraftTypeObjectVo draftTypeObjectVo) {
        BigDecimal assertAmount = BigDecimal.ZERO;
        if (showIncred.booleanValue()) {
            List<DynamicObject> incredSummaryList = this.getSummaryDataByEngineKey(IncredEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getYjIncred().getNumber(), (String)"incredtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
            assertAmount = CollectionUtils.isEmpty(incredSummaryList) ? BigDecimal.ZERO : incredSummaryList.stream().map(var -> var.getBigDecimal("incredtotal")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        String str1 = ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u4e00\u822c\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u6240\u5f97\u51cf\u514d\u7d2f\u8ba1\u6570", (String)"RecoupDeficitEngine_0", (String)"taxc-tccit", (Object[])new Object[0]);
        String str2 = ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u4e2d\u5173\u6751\u56fd\u5bb6\u81ea\u4e3b\u521b\u65b0\u793a\u8303\u533a\u7279\u5b9a\u533a\u57df\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u6240\u5f97\u51cf\u514d\u7d2f\u8ba1\u6570", (String)"RecoupDeficitEngine_1", (String)"taxc-tccit", (Object[])new Object[0]);
        QFilter nameFilter = new QFilter("rulename", "in", Arrays.asList(str1, str2));
        List<DynamicObject> nontaxtotalCollect = this.getSummaryDataByEngineKey(TechTransEngine.class.getSimpleName().concat("_summary_relate"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getNontaxSummaryM().getNumber(), (String)"nontaxtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter, nameFilter}));
        BigDecimal nontaxtotalAmount = CollectionUtils.isEmpty(nontaxtotalCollect) ? BigDecimal.ZERO : nontaxtotalCollect.stream().map(var -> var.getBigDecimal("nontaxtotal")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return assertAmount.add(nontaxtotalAmount);
    }

    private BigDecimal getAmount5(QFilter orgFilter, QFilter startFilter, QFilter endFilter, boolean showAssert, DraftTypeObjectVo draftTypeObjectVo) {
        if (!showAssert) {
            return BigDecimal.ZERO;
        }
        List<DynamicObject> assertSummaryList = this.getSummaryDataByEngineKey(AssertAcceDepreEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getAssertAcce().getNumber(), (String)"xsjszjyhjsdzjje,zzzjje", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
        return CollectionUtils.isEmpty(assertSummaryList) ? BigDecimal.ZERO : assertSummaryList.stream().map(var -> var.getBigDecimal("xsjszjyhjsdzjje").subtract(var.getBigDecimal("zzzjje"))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getAmount4(QFilter orgFilter, QFilter startFilter, QFilter endFilter, Date startDate, Boolean showNontax, Boolean showTeduced, DraftTypeObjectVo draftTypeObjectVo) {
        BigDecimal nontaxAmount = BigDecimal.ZERO;
        if (showNontax.booleanValue()) {
            List<DynamicObject> nontaxSummaryList = this.getSummaryDataByEngineKey(NontaxEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getYjNontax().getNumber(), (String)"nontaxtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
            nontaxAmount = nontaxSummaryList.stream().map(s -> s.getBigDecimal("nontaxtotal")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal treducedAmount = BigDecimal.ZERO;
        if (showTeduced.booleanValue()) {
            List<DynamicObject> treducedSummaryList = this.getSummaryDataByEngineKey(TreducedEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getYjTreduced().getNumber(), (String)"treducedtotal", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
            treducedAmount = treducedSummaryList.stream().map(s -> s.getBigDecimal("treducedtotal")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        List<DynamicObject> apportionSummaryList = this.getSummaryDataByEngineKey(AddDeductionEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getYjAddDuduction().getNumber(), (String)"bnyffyjjkcze", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
        BigDecimal developAmount = BigDecimal.ZERO;
        if (apportionSummaryList != null && apportionSummaryList.size() > 0) {
            developAmount = apportionSummaryList.stream().map(s -> s.getBigDecimal("bnyffyjjkcze")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        LOGGER.info("\u5f25\u8865\u7b2c4\u884c\u6570\u636e\uff1a{}\uff0c{}\uff0c{}", new Object[]{nontaxAmount, treducedAmount, developAmount});
        return nontaxAmount.add(treducedAmount).add(developAmount);
    }

    private BigDecimal getAmount3(QFilter orgFilter, QFilter startFilter, QFilter endFilter, DraftTypeObjectVo draftTypeObjectVo) {
        List<DynamicObject> apportionSummaryList = this.getSummaryDataByEngineKey(ZeroRatingInEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getZeroratingin().getNumber(), (String)"zeroratinginamount", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
        return apportionSummaryList.stream().map(s -> s.getBigDecimal("zeroratinginamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getAmount2(QFilter orgFilter, QFilter startFilter, QFilter endFilter, DraftTypeObjectVo draftTypeObjectVo) {
        List<DynamicObject> apportionSummaryList = this.getSummaryDataByEngineKey(RealEstateSpeBizEngine.class.getSimpleName().concat("_summary1"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getFdctdywNstz().getNumber(), (String)"itemnumber,bnljje", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
        return apportionSummaryList.stream().filter(s -> "009".equals(s.getString("itemnumber"))).map(s -> s.getBigDecimal("bnljje")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getAmount1(QFilter orgFilter, QFilter startFilter, QFilter endFilter, DraftTypeObjectVo draftTypeObjectVo) {
        List<DynamicObject> apportionSummaryList = this.getSummaryDataByEngineKey(TaxpayEngine.class.getSimpleName().concat("_summary"), () -> QueryServiceHelper.query((String)draftTypeObjectVo.getYjProfits().getNumber(), (String)"type,bqlje", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter}));
        return apportionSummaryList.stream().filter(s -> "profit".equals(s.getString("type"))).map(s -> s.getBigDecimal("bqlje")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

