/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.draft.TaxPayService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import org.apache.commons.collections.CollectionUtils;

@Order(value=0)
public class TaxpayEngine
extends AbstractSeasonalDraftEngine {
    private static final List<String> CELL_TYPES = Arrays.asList("income", "jcost", "profit");
    private static final List<String> CELL_HDZSTYPES = Arrays.asList("grossincome", "totalcost");
    private static final Map<String, String> CELL_TYPES_MAP = new LinkedHashMap<String, String>();

    public TaxpayEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public QFilter[] getOrgAndDateFilters(EngineModel model) {
        return this.getOrgAndDateEqualsFilters(model);
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        String cellType = (String)model.getCustom().get("cellType");
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.PROFITS);
        List ruleList = super.getRules(model);
        return (List)ruleList.stream().filter(s -> CELL_TYPES_MAP.get(cellType).equals(s.getDynamicObject("item").getString("number"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjProfits().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_YJ_PROFITS_ACCDET;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjProfits().getNumber();
    }

    public void doSetDraftData(EngineModel model, List summaryList, List summaryAccountingList) {
        String orgId = model.getOrgId();
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        int month = DateUtils.getMonthOfDate((Date)startDate);
        DynamicObject policy = (DynamicObject)model.getCustom().get("policy");
        String draftPurpose = model.getCustom().getOrDefault("draftpurpose", "nssb");
        Boolean isAjflag = DeadlineService.getDeadline(orgId, draftPurpose);
        Map<String, List<DynamicObject>> lastPeriodSummaryMap = this.getLastPeriodSummaryMap(orgId, startDate, endDate, isAjflag, this.getSummaryEntityType(model));
        String levytype = model.getCustom().getOrDefault("levytype", "czzs");
        List<String> typeList = "hdzs".equalsIgnoreCase(levytype) ? CELL_HDZSTYPES : CELL_TYPES;
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(Long.parseLong(orgId)), startDate, endDate, Lists.newArrayList((Object[])new String[]{"profits", "profits-bqlje"})), draftTypeVoObject);
        for (String cellType : typeList) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
            summary.set("org", (Object)orgId);
            summary.set("type", (Object)cellType);
            summary.set("skssqq", (Object)startDate);
            summary.set("skssqz", (Object)endDate);
            model.addCustom("cellType", (Object)cellType);
            BigDecimal sqlje = this.doSetSqData(month, lastPeriodSummaryMap, cellType, summary);
            List<DynamicObject> account = this.getRuleSourceData(model);
            String type = CELL_TYPES_MAP.get(cellType);
            BigDecimal amount = this.getAmount(adjustAmounts, type, account);
            summary.set("bqfse", (Object)amount);
            BigDecimal bqlje = TaxPayService.getBqlje(policy, type, amount, sqlje, draftPurpose);
            summary.set("bqlje", (Object)bqlje);
            summaryList.add(summary);
            summaryAccountingList.addAll(account);
        }
    }

    private BigDecimal getAmount(DynamicObject[] adjustAmounts, String type, List<DynamicObject> account) {
        DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("itemnumber").equals(type) || s.getString("itemnumber").equals(type + "_")).collect(Collectors.toCollection(DynamicObjectCollection::new));
        BigDecimal adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amount = this.sumAccountingAmount(account).add(adjustAmount);
        return amount;
    }

    private BigDecimal doSetSqData(int month, Map<String, List<DynamicObject>> lastPeriodSummaryMap, String cellType, DynamicObject summary) {
        BigDecimal sqfse = BigDecimal.ZERO;
        BigDecimal sqlje = BigDecimal.ZERO;
        List<DynamicObject> dynamicObjects = lastPeriodSummaryMap.get(cellType);
        if (CollectionUtils.isNotEmpty(dynamicObjects)) {
            sqfse = dynamicObjects.stream().map(s -> s.getBigDecimal("bqfse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            sqlje = dynamicObjects.stream().map(s -> s.getBigDecimal("bqlje")).reduce(BigDecimal.ZERO, BigDecimal::add);
            sqlje = month == 1 ? BigDecimal.ZERO : sqlje;
        }
        summary.set("sqfse", (Object)sqfse);
        summary.set("sqlje", (Object)sqlje);
        return sqlje;
    }

    private Map<String, List<DynamicObject>> getLastPeriodSummaryMap(String orgId, Date startDate, Date endDate, Boolean isAjsb, String entityName) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date date = DateUtils.addMonth((Date)startDate, (int)(isAjsb != false ? -3 : -1));
        QFilter skssqq = new QFilter("skssqq", "=", (Object)date);
        Date date1 = DateUtils.addMonth((Date)endDate, (int)(isAjsb != false ? -3 : -1));
        String lastDateOfMonthStr = DateUtils.getLastDateOfMonthStr((Date)date1, (String)"yyyy-MM-dd");
        QFilter skssqz = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)lastDateOfMonthStr));
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"type,skssqq,skssqz,bqfse,bqlje", (QFilter[])new QFilter[]{q1, skssqq, skssqz});
        return query.stream().collect(Collectors.groupingBy(e -> e.getString("type")));
    }

    @Override
    boolean isBranch(String declareType) {
        Boolean result = Boolean.FALSE;
        if ("100".equals(declareType) || "311".equals(declareType) || "312".equals(declareType)) {
            result = Boolean.TRUE;
        } else if ("210".equals(declareType) || "220".equals(declareType) || "230".equals(declareType)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    static {
        CELL_TYPES_MAP.put("income", "011");
        CELL_TYPES_MAP.put("jcost", "012");
        CELL_TYPES_MAP.put("profit", "013");
        CELL_TYPES_MAP.put("grossincome", "011");
        CELL_TYPES_MAP.put("totalcost", "012");
    }
}

