/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.draft.NontaxService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.engine.refactoring.service.AdjustAmountService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.common.constant.DiscountTypeConstant;
import kd.taxc.tccit.common.dto.AdjustAmountDto;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

@Order(value=0)
public class TechTransEngine
extends AbstractSeasonalDraftEngine {
    private static final String RULE_TYPE = "4";

    public TechTransEngine(DraftEngineContext context) {
        super(context);
    }

    public void putOtherFiltersDelDraftTables(Map delMap, EngineModel model) {
        ArrayList qFilters = Lists.newArrayList((Object[])this.getOrgAndDateFilters(model));
        qFilters.add(new QFilter("type", "=", (Object)RULE_TYPE));
        delMap.put(this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber(), qFilters.toArray(new QFilter[0]));
    }

    @Override
    public List<DynamicObject> getRules(EngineModel model) {
        model.addCustom("ruleTypeEnum", (Object)RuleTypeEnum.INCOME);
        return super.getRules(model);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjTechtrans().getDetail();
    }

    @Override
    public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return RuleEnginEntityTypeEnum.TCCIT_TECHTRANS_ACCDETAIL;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getYjTechtrans().getNumber();
    }

    public void doHandleRelateData(EngineModel model, List summaryList) {
        String entity = this.getDraftTypeObjectVo(model.getCustom()).getNontaxSummaryM().getNumber();
        List<DynamicObject> relateList = NontaxService.getHandleSummaryMiddleResult(summaryList, RULE_TYPE, "incredtotal", 2, this.doGetBeginSeq(model, entity), entity);
        this.getDraftEngineContext().getSummaryDataMap().put(this.getRelateDataMapKey(), relateList);
    }

    private int doGetBeginSeq(EngineModel model, String entity) {
        ArrayList qFilters = Lists.newArrayList((Object[])this.getOrgAndDateFilters(model));
        qFilters.add(new QFilter("type", "=", (Object)"3"));
        return BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0])).length + 1;
    }

    public void doSetDraftData(EngineModel model, List summaryList, List summaryAccountingList) {
        Long orgId = Long.parseLong(model.getOrgId());
        List orglist = (List)model.getCustom().get("orglist");
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = this.getLastTaxMap(model, this.getSummaryEntityType(model));
        DraftTypeObjectVo draftTypeVoObject = this.getDraftTypeObjectVo(model.getCustom());
        DynamicObject[] adjustAmounts = AdjustAmountService.getAdjustAmountByOperate(model, new AdjustAmountDto(Collections.singletonList(orgId), startDate, endDate, Collections.singletonList("incredpresent")), draftTypeVoObject);
        for (Long taxOrgId : orglist) {
            model.addCustom("currentOrg", (Object)taxOrgId);
            for (DynamicObject rule : this.getRules(model)) {
                if (this.isUnuseRule(rule)) continue;
                String serialNo = UUID.randomUUID().toString();
                model.addCustom("serialNo", (Object)serialNo);
                List accountingList = this.getRuleSourceData(model, rule);
                summaryAccountingList.addAll(accountingList);
                BigDecimal adjustAmount = BigDecimal.ZERO;
                DynamicObjectCollection collect = Arrays.stream(adjustAmounts).filter(s -> s.getString("ruleid").equals(rule.getString("id"))).filter(s -> s.getLong("taxorg") == taxOrgId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
                if (!CollectionUtils.isEmpty((Collection)collect)) {
                    adjustAmount = collect.stream().map(s -> s.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal incredPresent = this.sumAccountingAmount(accountingList).add(adjustAmount);
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
                summary.set("serialno", (Object)serialNo);
                summary.set("org", (Object)orgId);
                summary.set("taxorg", (Object)taxOrgId);
                summary.set("rule", (Object)rule);
                summary.set("skssqq", (Object)startDate);
                summary.set("skssqz", (Object)endDate);
                DynamicObject itemChoiceName = rule.getDynamicObject("itemchoicename");
                summary.set("itemtype", (Object)itemChoiceName);
                summary.set("discounttype", (Object)itemChoiceName.getString("projtype"));
                summary.set("incredpresent", (Object)incredPresent);
                BigDecimal lastIncredtotal = lastTaxMap.get(taxOrgId + "#" + rule.getLong("id"));
                BigDecimal incredTotal = BigDecimalUtil.addObject((Object)incredPresent, (Object)lastIncredtotal);
                summary.set("incredtotal", (Object)incredTotal);
                summaryList.add(summary);
            }
        }
    }

    private boolean isUnuseRule(DynamicObject rule) {
        return !DiscountTypeConstant.techIds.contains(rule.getDynamicObject("itemchoicename").getLong("id"));
    }

    Map<String, BigDecimal> getLastTaxMap(EngineModel model, String entityName) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        Map<String, BigDecimal> lastTaxMap = new HashMap<String, BigDecimal>();
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        if ("season".equals(taxLimit)) {
            if (startDate.getMonth() >= 3) {
                lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 3, entityName);
            }
        } else if (startDate.getMonth() >= 1) {
            lastTaxMap = this.getLastPeriodBigDecimalMap(startDate, endDate, q1, 1, entityName);
        }
        return lastTaxMap;
    }

    private Map<String, BigDecimal> getLastPeriodBigDecimalMap(Date startDate, Date endDate, QFilter orgFilter, int monthcount, String entityName) {
        Date date = DateUtils.addMonth((Date)startDate, (int)(-monthcount));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)date);
        Date d2 = DateUtils.addMonth((Date)endDate, (int)(-monthcount));
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)d2)));
        DynamicObjectCollection lastCols = QueryServiceHelper.query((String)entityName, (String)"taxorg,rule,incredtotal", (QFilter[])new QFilter[]{skssqqFilter, skssqzFilter, orgFilter});
        Map<String, BigDecimal> lastTaxMap = lastCols.stream().collect(Collectors.toMap(e -> e.getLong("taxorg") + "#" + e.getLong("rule"), f -> f.getBigDecimal("incredtotal")));
        return lastTaxMap;
    }
}

