/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;

@Order(value=1)
public class YjQyyhEngine
extends AbstractSeasonalDraftEngine {
    private static final String POLICY_CONFIRM = "tccit_seasonal_policy";

    public YjQyyhEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return null;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getQyyh().getNumber();
    }

    @Override
    public QFilter[] getOrgAndDateFilters(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter q2 = new QFilter("skssqq", "=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q3 = new QFilter("skssqz", "=", (Object)endDate);
        return new QFilter[]{q1, q2, q3};
    }

    @Override
    public List<DynamicObject> calDraftData(EngineModel model) {
        DynamicObjectCollection sum = new DynamicObjectCollection();
        this.doSetDraftData(model, sum);
        this.doSetDraftEngineContextOfSummary((List)sum);
        return sum;
    }

    private void doSetDraftData(EngineModel model, DynamicObjectCollection sum) {
        String orgId = model.getOrgId();
        Long orgid = Long.parseLong(orgId);
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        Map custom = model.getCustom();
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(custom);
        DynamicObject tccitPolicy = this.findTccitPolicy(orgid, skssqq, skssqz, custom);
        if (tccitPolicy == null) {
            return;
        }
        String declareType = tccitPolicy.getString("declaretype");
        if (Lists.newArrayList((Object[])new String[]{"100", "220", "230"}).contains(declareType)) {
            List<DynamicObject> cards = this.findCard(tccitPolicy);
            sum.addAll((Collection)this.createRow(orgid, skssqq, skssqz, orgid, tccitPolicy.getDynamicObject("orgid").getString("name"), cards, new BigDecimal("1")));
        } else if ("210".contains(declareType)) {
            List<DynamicObject> cards = this.findCard(tccitPolicy);
            List apportionSummaryList = (List)this.getDraftEngineContext().getSummaryDataMap().get("ApportionEngine_summary");
            if (CollectionUtils.isEmpty((Collection)apportionSummaryList)) {
                return;
            }
            Optional<DynamicObject> org = apportionSummaryList.stream().filter(e -> e.getLong("taxorg") == orgid.longValue()).findFirst();
            BigDecimal rate = org.isPresent() ? (org.get().getBigDecimal("rate") != null ? org.get().getBigDecimal("rate") : BigDecimal.ZERO) : this.getZjgftbl(tccitPolicy);
            sum.addAll((Collection)this.createRow(orgid, skssqq, skssqz, orgid, tccitPolicy.getDynamicObject("orgid").getString("name"), cards, rate));
            List apportionSummary = apportionSummaryList.stream().filter(e -> e.getLong("taxorg") != orgid.longValue()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(apportionSummary)) {
                return;
            }
            List branchOrgId = apportionSummary.stream().map(s -> s.getLong("taxorg")).collect(Collectors.toList());
            for (Long fzOrgId : branchOrgId) {
                List<DynamicObject> listCard = fzOrgId == 0L ? this.findCard(tccitPolicy) : this.listCard(fzOrgId, skssqq, skssqz);
                Optional<DynamicObject> optional = apportionSummary.stream().filter(s -> s.getLong("taxorg") == fzOrgId.longValue()).findFirst();
                if (!optional.isPresent()) continue;
                DynamicObject filterObj = optional.get();
                String taxorgname = filterObj.getString("taxorgname");
                BigDecimal qbfzjgftbl = tccitPolicy.getBigDecimal("qbfzjgftbl");
                BigDecimal ftrate = org.isPresent() ? (filterObj.getBigDecimal("rate") != null ? filterObj.getBigDecimal("rate") : BigDecimal.ZERO) : (filterObj.getBigDecimal("rate") != null ? filterObj.getBigDecimal("rate").multiply(qbfzjgftbl) : BigDecimal.ZERO);
                DynamicObjectCollection fzSum = this.createRow(orgid, skssqq, skssqz, fzOrgId, taxorgname, listCard, ftrate);
                sum.addAll((Collection)fzSum);
            }
        }
    }

    private BigDecimal getZjgftbl(DynamicObject tccitPolicy) {
        BigDecimal zjgftbl = tccitPolicy.getBigDecimal("zjgftbl");
        BigDecimal czjzfpbl = tccitPolicy.getBigDecimal("czjzfpbl");
        return zjgftbl.add(czjzfpbl);
    }

    private DynamicObject findTccitPolicy(Long orgid, Date skssqq, Date skssqz, Map<String, Object> customParams) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter startDateFilter = new QFilter("startdate", "=", (Object)skssqq);
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)skssqz);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", customParams.getOrDefault("draftpurpose", "nssb"));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)POLICY_CONFIRM, (String)"id,orgid", (QFilter[])new QFilter[]{orgFilter, startDateFilter, endDateFilter, draftpurposeFilter});
        DynamicObject loadSingle = null;
        if (dynamicObject != null) {
            loadSingle = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)POLICY_CONFIRM);
        }
        return loadSingle;
    }

    private DynamicObjectCollection createRow(Long orgid, Date skssqq, Date skssqz, Long taxorg, String taxorgname, List<DynamicObject> cards, BigDecimal ftrate) {
        if (CollectionUtils.isEmpty(cards)) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        DynamicObject dgEntry = null;
        int itemNo = 0;
        for (DynamicObject card : cards) {
            dgEntry = BusinessDataServiceHelper.newDynamicObject((String)this.getSummaryEntityType(this.getEngineModel()));
            dgEntry.set("itemno", (Object)itemNo);
            dgEntry.set("companytype", card.getDynamicObject("companytype").get("id"));
            dgEntry.set("taxorg", (Object)taxorg);
            dgEntry.set("taxorgname", (Object)taxorgname);
            dgEntry.set("ftrate", (Object)ftrate);
            BigDecimal jmrate = this.getJmrate(DateUtils.getYearOfDate((Date)skssqq), card, cards);
            dgEntry.set("jmrate", (Object)jmrate);
            dgEntry.set("orgid", (Object)orgid);
            dgEntry.set("skssqq", (Object)skssqq);
            dgEntry.set("skssqz", (Object)skssqz);
            ++itemNo;
            sum.add((Object)dgEntry);
        }
        return sum;
    }

    private BigDecimal getJmrate(int declareyear, DynamicObject card, List<DynamicObject> list) {
        Integer profitmYear = Integer.valueOf(StringUtils.isEmpty((Object)card.getString("profitmyear")) ? "0" : card.getString("profitmyear"));
        int diff = declareyear - profitmYear;
        DynamicObject companytype = card.getDynamicObject("companytype");
        if (companytype == null) {
            return BigDecimal.ZERO;
        }
        if ("FTA001".equals(companytype.getString("number"))) {
            if (list.size() == 1) {
                return new BigDecimal("0.1");
            }
            Optional<DynamicObject> first = list.stream().filter(s -> s.getDynamicObject("companytype").getString("number").equals("FTA002")).findFirst();
            if (first.isPresent()) {
                DynamicObject dynamicObject = first.get();
                Integer profitmYear2 = Integer.valueOf(StringUtils.isEmpty((Object)dynamicObject.getString("profitmyear")) ? "0" : dynamicObject.getString("profitmyear"));
                if (0 <= declareyear - profitmYear2 && declareyear - profitmYear2 < 2) {
                    return new BigDecimal("0");
                }
                if (2 <= declareyear - profitmYear2 && declareyear - profitmYear2 <= 4) {
                    return new BigDecimal("0.05");
                }
                return new BigDecimal("0.1");
            }
        }
        if ("FTA002".equals(companytype.getString("number"))) {
            if (0 <= diff && diff < 2) {
                return new BigDecimal("0.25");
            }
            if (2 <= diff && diff <= 4) {
                return new BigDecimal("0.125");
            }
            return BigDecimal.ZERO;
        }
        if ("FTA003".equals(companytype.getString("number"))) {
            return new BigDecimal("0.25");
        }
        if (Lists.newArrayList((Object[])new String[]{"FTA004", "FTA005", "FTA006"}).contains(companytype.getString("number"))) {
            return new BigDecimal("0.1");
        }
        return BigDecimal.ZERO;
    }

    private DynamicObjectCollection findBranchOrgId(Long orgid, Date skssqq, Date skssqz, DraftTypeObjectVo draftTypeObjectVo) {
        int year = DateUtils.getYearOfDate((Date)skssqq);
        QFilter taxorgFilter = new QFilter("taxorg", "!=", (Object)orgid);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
        String selectFields = "org, taxorg,taxorgname1,taxorgname,unifiedsocialcode1,unifiedsocialcode,income,emolument,totalassets,rate,year ";
        DynamicObjectCollection apportionSummary = QueryServiceHelper.query((String)draftTypeObjectVo.getApportion().getNumber(), (String)selectFields, (QFilter[])new QFilter[]{orgFilter, taxorgFilter, startFilter, endFilter});
        return apportionSummary;
    }

    private List<DynamicObject> findCard(DynamicObject dynamicObject) {
        List<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)POLICY_CONFIRM);
        DynamicObjectCollection apitudeentryentity = loadSingle.getDynamicObjectCollection("apitudeentryentity");
        if (!CollectionUtils.isEmpty((Collection)apitudeentryentity)) {
            List<DynamicObject> collect = apitudeentryentity.stream().filter(s -> s.getString("apitudetype").equals("3")).filter(s -> s.getBoolean("yxsy")).collect(Collectors.toList());
            list = this.removeDuplicate(collect);
        }
        return list;
    }

    private List<DynamicObject> removeDuplicate(List<DynamicObject> collect) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        Map<String, List<DynamicObject>> companytype = collect.stream().collect(Collectors.groupingBy(s -> s.getString("companytype")));
        for (Map.Entry<String, List<DynamicObject>> entry : companytype.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            list.add(value.get(0));
        }
        return list;
    }

    public List<DynamicObject> listCard(Long orgId, Date startdate, Date enddate) {
        List<Object> list = new ArrayList<DynamicObject>();
        DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(orgId);
        if (CollectionUtils.isEmpty((Collection)apitudeEntryEntity)) {
            return list;
        }
        List collect = apitudeEntryEntity.stream().filter(s -> s.getString("apitudetype").equals("3")).filter(s -> s.getBoolean("yxsy")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return list;
        }
        list = collect.stream().filter(s -> {
            Date apitudestartdate = s.getDate("apitudestartdate");
            Date apitudeenddate = s.getDate("apitudeenddate");
            if (apitudeenddate == null) {
                return !apitudestartdate.after(startdate);
            }
            return !apitudestartdate.after(startdate) && !apitudeenddate.before(enddate);
        }).collect(Collectors.toList());
        list = this.removeDuplicate(list);
        return list;
    }
}

