/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.engine.refactoring.AbstractSeasonalDraftEngine;
import org.apache.commons.collections.CollectionUtils;

@Order(value=0)
public class ZeroRatingInEngine
extends AbstractSeasonalDraftEngine {
    public ZeroRatingInEngine(DraftEngineContext context) {
        super(context);
    }

    @Override
    public String getAccountEntityType(EngineModel model) {
        return null;
    }

    @Override
    public String getSummaryEntityType(EngineModel model) {
        return this.getDraftTypeObjectVo(model.getCustom()).getZeroratingin().getNumber();
    }

    @Override
    public List<DynamicObject> calDraftData(EngineModel model) {
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        this.doSetDraftData(model, summaryList);
        this.doSetDraftEngineContextOfSummary(summaryList);
        return summaryList;
    }

    private void doSetDraftData(EngineModel model, List<DynamicObject> summaryList) {
        DynamicObject[] zbs = this.queryAccount(model);
        if (zbs == null || zbs.length == 0) {
            return;
        }
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        for (DynamicObject dyo : zbs) {
            DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSummaryEntityType(model)));
            this.doFillSummary(model, dyo, summary);
            BigDecimal incomeregAmmount = this.calcAmount(dyo, startDate, ZREAccountEnum.INCOMEREGAMMOUNT);
            summary.set("incomeregammount", (Object)incomeregAmmount);
            BigDecimal payregAmmount = this.calcAmount(dyo, startDate, ZREAccountEnum.PAYREGAMMOUNT);
            summary.set("payregammount", (Object)payregAmmount);
            BigDecimal balanceregAmount = this.calcAmount(dyo, startDate, ZREAccountEnum.BALANCEREGAMOUNT);
            summary.set("balanceregamount", (Object)balanceregAmount);
            BigDecimal zeroratinginAmount = incomeregAmmount.subtract(payregAmmount).subtract(balanceregAmount);
            summary.set("zeroratinginamount", (Object)zeroratinginAmount);
            summaryList.add(summary);
        }
    }

    private void doFillSummary(EngineModel model, DynamicObject dyo, DynamicObject summary) {
        Long orgId = Long.parseLong(model.getOrgId());
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        summary.set("serialno", (Object)UUID.randomUUID().toString());
        summary.set("org", (Object)orgId);
        summary.set("skssqq", (Object)startDate);
        summary.set("skssqz", (Object)endDate);
        summary.set("incomedate", dyo.get("incomedate"));
        summary.set("type", dyo.get("type"));
        summary.set("fiscalamount", dyo.get("fiscalamount"));
        summary.set("zeroratingamount", dyo.get("zeroratingamount"));
    }

    private DynamicObject[] queryAccount(EngineModel model) {
        Long orgId = Long.parseLong(model.getOrgId());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)startDate);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)startDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(firstDateOfYear);
        cal.add(1, -5);
        Date fiveYearAgo = cal.getTime();
        QFilter yearFilter = new QFilter("incomedate", ">=", (Object)fiveYearAgo).and(new QFilter("incomedate", "<=", (Object)lastDateOfYear));
        return BusinessDataServiceHelper.load((String)"tccit_zero_rating_inout", (String)"id,incomedate,type,fiscalamount,zeroratingamount,tccit_in_income_reg.income_reg_date,tccit_in_income_reg.income_reg_amount,tccit_pay_register.pay_reg_date,tccit_pay_register.pay_reg_amount,tccit_pay_register.paytype,tccit_balance_register.balance_reg_date,tccit_balance_register.balance_reg_amount", (QFilter[])new QFilter[]{orgFilter, yearFilter});
    }

    private BigDecimal calcAmount(DynamicObject dyo, Date startDate, ZREAccountEnum accountEnum) {
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)startDate);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)startDate);
        BigDecimal r = BigDecimal.ZERO;
        DynamicObjectCollection income = dyo.getDynamicObjectCollection(accountEnum.entryName);
        if (CollectionUtils.isNotEmpty((Collection)income)) {
            for (DynamicObject d : income) {
                Date date;
                if ("tccit_pay_register".equals(accountEnum.entryName) && !"2".equals(d.getString("paytype")) || (date = d.getDate(accountEnum.dateName)).compareTo(firstDateOfYear) < 0 || date.compareTo(lastDateOfYear) > 0) continue;
                r = r.add(d.getBigDecimal(accountEnum.amountName));
            }
        }
        return r;
    }

    static enum ZREAccountEnum {
        INCOMEREGAMMOUNT("tccit_in_income_reg", "income_reg_date", "income_reg_amount"),
        PAYREGAMMOUNT("tccit_pay_register", "pay_reg_date", "pay_reg_amount"),
        BALANCEREGAMOUNT("tccit_balance_register", "balance_reg_date", "balance_reg_amount");

        String entryName;
        String dateName;
        String amountName;

        private ZREAccountEnum(String entryName, String dateName, String amountName) {
            this.entryName = entryName;
            this.dateName = dateName;
            this.amountName = amountName;
        }
    }
}

