/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.draft.engine.service.DraftEngine;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.tccit.business.engine.refactoring.AddDeductionEngine;
import kd.taxc.tccit.business.engine.refactoring.ApportionEngine;
import kd.taxc.tccit.business.engine.refactoring.AssertAcceDepreEngine;
import kd.taxc.tccit.business.engine.refactoring.AssetsDataEngine;
import kd.taxc.tccit.business.engine.refactoring.IncredEngine;
import kd.taxc.tccit.business.engine.refactoring.NontaxEngine;
import kd.taxc.tccit.business.engine.refactoring.RealEstateSpeBizEngine;
import kd.taxc.tccit.business.engine.refactoring.RecoupDeficitEngine;
import kd.taxc.tccit.business.engine.refactoring.TaxpayEngine;
import kd.taxc.tccit.business.engine.refactoring.TechTransEngine;
import kd.taxc.tccit.business.engine.refactoring.TreducedEngine;
import kd.taxc.tccit.business.engine.refactoring.YjQyyhEngine;
import kd.taxc.tccit.business.engine.refactoring.ZeroRatingInEngine;

public class DraftEngineBuilder {
    private static Map<String, List<DraftEngine>> map = new HashMap<String, List<DraftEngine>>();

    public static List<DraftEngine> getDraftEngines(String scene) {
        return map.get(scene);
    }

    private static List<DraftEngine> initTccitSeasonal() {
        DraftEngineContext context = new DraftEngineContext();
        ArrayList<DraftEngine> engineList = new ArrayList<DraftEngine>();
        engineList.add(new AssetsDataEngine(context));
        engineList.add(new TaxpayEngine(context));
        engineList.add(new IncredEngine(context));
        engineList.add(new TechTransEngine(context));
        engineList.add(new NontaxEngine(context));
        engineList.add(new ZeroRatingInEngine(context));
        engineList.add(new TreducedEngine(context));
        engineList.add(new ApportionEngine(context));
        engineList.add(new AssertAcceDepreEngine(context));
        engineList.add(new RealEstateSpeBizEngine(context));
        engineList.add(new YjQyyhEngine(context));
        engineList.add(new AddDeductionEngine(context));
        engineList.add(new RecoupDeficitEngine(context));
        return engineList;
    }

    public static List<IEngine> initTccitSeasonalIEngine() {
        DraftEngineContext context = new DraftEngineContext();
        ArrayList<IEngine> engineList = new ArrayList<IEngine>();
        engineList.add((IEngine)new AssetsDataEngine(context));
        engineList.add((IEngine)new TaxpayEngine(context));
        engineList.add((IEngine)new IncredEngine(context));
        engineList.add((IEngine)new TechTransEngine(context));
        engineList.add((IEngine)new NontaxEngine(context));
        engineList.add((IEngine)new ZeroRatingInEngine(context));
        engineList.add((IEngine)new TreducedEngine(context));
        engineList.add((IEngine)new ApportionEngine(context));
        engineList.add((IEngine)new AssertAcceDepreEngine(context));
        engineList.add((IEngine)new RealEstateSpeBizEngine(context));
        engineList.add((IEngine)new YjQyyhEngine(context));
        engineList.add((IEngine)new AddDeductionEngine(context));
        engineList.add((IEngine)new RecoupDeficitEngine(context));
        return engineList;
    }

    static {
        map.put("tccit_seasonal", DraftEngineBuilder.initTccitSeasonal());
    }
}

