/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring.handler;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.draft.engine.annotation.Order;
import kd.taxc.bdtaxr.common.draft.engine.handler.AbstractDraftEngineHandler;
import kd.taxc.bdtaxr.common.draft.engine.service.DraftEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.tccit.business.engine.refactoring.factory.DraftEngineEnum;

public class SeasonalDraftEngineHandler
extends AbstractDraftEngineHandler {
    List<DraftEngine> baseDraftEngines;
    List<DraftEngine> upperDraftEngines;

    public void init() {
        this.setDraftEngines(DraftEngineEnum.TCCIT_SEASONAL.engines);
    }

    public void work(EngineModel engineModel, RequestContext mainRc) throws Exception {
        this.doEnginesWork(engineModel, mainRc, this.baseDraftEngines);
        this.doEnginesWork(engineModel, mainRc, this.upperDraftEngines);
    }

    public void sort() {
        this.baseDraftEngines = this.getDraftEngines().stream().filter(this::isBase).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(this.baseDraftEngines)) {
            this.upperDraftEngines = this.getDraftEngines();
            return;
        }
        this.upperDraftEngines = this.getDraftEngines().stream().filter(u -> !this.isBase((DraftEngine)u)).sorted(Comparator.comparingInt(this::getEngineOrder)).collect(Collectors.toList());
    }

    private boolean isBase(DraftEngine e) {
        return this.getEngineOrder(e) == 0;
    }

    private int getEngineOrder(DraftEngine e) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = e.getClass().getAnnotations()) {
            if (!(annotation instanceof Order)) continue;
            return ((Order)annotation).value();
        }
        return 1;
    }

    private void doEnginesWork(EngineModel engineModel, RequestContext mainRc, List<DraftEngine> engines) throws InterruptedException, ExecutionException, TimeoutException, CloneNotSupportedException {
        if (CollectionUtils.isEmpty(engines)) {
            return;
        }
        ArrayList<Future> futures = new ArrayList<Future>(16);
        for (DraftEngine e : engines) {
            e.setCtx(mainRc);
            e.setEngineModel(EngineModel.clone((EngineModel)engineModel));
            Future future = ThreadPoolsService.getInstance().submitFutrue((Callable)e);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get(30L, TimeUnit.SECONDS);
        }
    }
}

