/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.draft.engine.service.DraftEnginePreDelService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;

public interface SeasonalDraftEngineDelService<T extends EngineModel>
extends DraftEnginePreDelService,
IDraftTypeObserver {
    default public void preWorkBeforeDelDraft(EngineModel model) {
        String[] keys;
        HashMap<String, QFilter[]> delMap = new HashMap<String, QFilter[]>();
        QFilter[] qFilters = this.getOrgAndDateFilters(model);
        for (String key : keys = this.getDelDraftTables(model)) {
            if (key == null) continue;
            delMap.put(key, qFilters);
        }
        if (model.getCustom() == null || !"refetch".equals(String.valueOf(model.getCustom().get("operateType")))) {
            this.putAdjustInfoDelTables(delMap, this.getAdjustOrgAndDateFilters(model), model);
        }
        this.putOtherFiltersDelDraftTables(delMap, model);
        this.getDraftEngineContext().getDelDataMap().put(this.getDelDataMapKey(), delMap);
    }

    default public String[] getDelDraftTables(EngineModel model) {
        return new String[0];
    }

    default public void putAdjustInfoDelTables(Map<String, QFilter[]> delMap, QFilter[] qFilters, EngineModel model) {
        delMap.put(this.getDraftTypeObjectVo(model.getCustom()).getAdjustDetail().getNumber(), qFilters);
        delMap.put(this.getDraftTypeObjectVo(model.getCustom()).getAdjustRecord().getNumber(), qFilters);
    }

    default public String getDelDataMapKey() {
        return this.getClass().getSimpleName().concat("_del");
    }

    default public QFilter[] getOrgAndDateFilters(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter q2 = new QFilter("skssqq", ">=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)endDate));
        return new QFilter[]{q1, q2, q3};
    }

    default public QFilter[] getAdjustOrgAndDateFilters(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        QFilter q2 = new QFilter("skssqq", ">=", (Object)startDate);
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)endDate));
        return new QFilter[]{q1, q2, q3};
    }

    default public void putOtherFiltersDelDraftTables(Map<String, QFilter[]> delMap, EngineModel model) {
    }
}

