/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.engine.refactoring.service;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.draft.engine.service.DraftEngineRuleFetchService;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.common.utils.TaxRuleConstantUtils;

public interface SeasonalDraftEngineRuleFetchService<T extends EngineModel>
extends DraftEngineRuleFetchService {
    default public List<DynamicObject> getRuleSourceData(EngineModel model, DynamicObject rule) {
        RuleEngineDto ruleEngineDto = this.buildRuleEngineDto(model, rule);
        return this.fetchRuleSourceData(ruleEngineDto);
    }

    default public RuleEngineDto buildRuleEngineDto(EngineModel model, DynamicObject rule) {
        Date startdate = DateUtils.stringToDate((String)model.getStartDate());
        Date enddate = DateUtils.stringToDate((String)model.getEndDate());
        Long currentOrg = (Long)model.getCustom().get("currentOrg");
        String serialNo = (String)model.getCustom().get("serialNo");
        RuleEngineDto ruleEngineDto = new RuleEngineDto(currentOrg, Long.valueOf(Long.parseLong(model.getOrgId())), startdate, enddate, this.getAccountEntityType(model), TaxRuleConstantUtils.getRuleFilterMap(), rule.getDynamicObjectCollection(this.getRuleEntryEntityType(model)));
        ruleEngineDto.setTaxaccountserialno(serialNo);
        RuleEnginEntityTypeEnum ruleEngineEntityTypeEnum = this.getRuleEngineEntityTypeEnum();
        if (ruleEngineEntityTypeEnum != null) {
            ruleEngineDto.setRuleEnginEntityType(ruleEngineEntityTypeEnum.getEntityType());
        }
        ruleEngineDto.setTaxCategoryId(DeclareTaxType.QYSDS.getBaseTaxId());
        return ruleEngineDto;
    }

    default public List<DynamicObject> fetchRuleSourceData(RuleEngineDto ruleEngineDto) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getRuleEnginData", (Object[])new Object[]{ruleEngineDto});
    }

    public String getAccountEntityType(EngineModel var1);

    default public RuleEnginEntityTypeEnum getRuleEngineEntityTypeEnum() {
        return null;
    }

    public String getSummaryEntityType(EngineModel var1);

    default public String getRuleEntryEntityType(EngineModel model) {
        String entryEntityTypePrefix = (String)model.getCustom().get("entryEntityTypePrefix");
        return StringUtil.isBlank((CharSequence)entryEntityTypePrefix) ? "entryentity" : entryEntityTypePrefix.concat("entryentity");
    }
}

