/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.graph;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.tccit.business.calc.impl.CalcSummery;
import kd.taxc.tccit.business.graph.NodeTask;
import kd.taxc.tccit.business.graph.TaskGraph;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class BuilderYearEngineGraphService {
    private Map<String, NodeTask> nodeTaskMap = Maps.newConcurrentMap();
    private static BuilderYearEngineGraphService instance = null;
    private TaskGraph taskGraph = new TaskGraph();
    private CalcSummery calcSummery = new CalcSummery();

    private BuilderYearEngineGraphService() {
        Map<String, List<String>> allDependentOn = this.getAllDependentOn();
        this.buildGraph(allDependentOn);
    }

    public TaskGraph getTaskGraph() {
        return this.taskGraph;
    }

    public static synchronized BuilderYearEngineGraphService getInstance() {
        if (instance == null) {
            instance = new BuilderYearEngineGraphService();
        }
        return instance;
    }

    public final Map<String, List<String>> getAllDependentOn() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
        List<IEngine> engines = this.calcSummery.getEngines();
        for (IEngine engine : engines) {
            Map<String, List<String>> dependents = ((AbstractEngine)engine).getNodeDependentOn();
            map.putAll(dependents);
        }
        return map;
    }

    public final void buildGraph(Map<String, List<String>> allDependendOn) {
        List<IEngine> engines = this.calcSummery.getEngines();
        for (IEngine engine : engines) {
            NodeTask nodeTask;
            String pluginName = engine.getClass().getSimpleName();
            List<String> dependent = allDependendOn.get(pluginName);
            if (dependent == null) {
                nodeTask = new NodeTask(pluginName);
                this.nodeTaskMap.put(pluginName, nodeTask);
                continue;
            }
            nodeTask = new NodeTask(pluginName);
            dependent.stream().forEach(s -> nodeTask.addDependence((String)s));
            this.nodeTaskMap.put(pluginName, nodeTask);
        }
        this.taskGraph.parseNodeTasksToGraph(this.nodeTaskMap);
    }

    public List<String> getTopologicallys(String nodeId) {
        return this.taskGraph.getTopologicallys(this.nodeTaskMap.get(nodeId));
    }

    public boolean isDAGraph() {
        return this.taskGraph.isDAGraph();
    }

    public void printAllDependentOn() {
        this.taskGraph.printAllDependentOn();
    }

    public Map<String, IEngine> getYearEnginePluginMapper() {
        List<IEngine> engines = this.calcSummery.getEngines();
        Map<String, IEngine> pluginMapping = engines.stream().collect(Collectors.toMap(s -> s.getClass().getSimpleName(), s -> s, (a, b) -> a));
        return pluginMapping;
    }
}

