/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.graph;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tccit.business.graph.NodeTask;

public class TaskGraph {
    private static final Log LOGGER = LogFactory.getLog(TaskGraph.class);
    private MutableGraph<NodeTask> graph = GraphBuilder.directed().allowsSelfLoops(false).build();

    public MutableGraph<NodeTask> getGraph() {
        return this.graph;
    }

    public void parseNodeTasksToGraph(Map<String, NodeTask> nodeTasks) {
        for (NodeTask nodeTask : nodeTasks.values()) {
            if (!this.graph.nodes().contains(nodeTask)) {
                this.graph.addNode((Object)nodeTask);
            }
            for (String dependence : nodeTask.getDependences()) {
                this.graph.putEdge((Object)nodeTasks.get(dependence), (Object)nodeTask);
            }
        }
    }

    public boolean isDAGraph() {
        HashMap<String, Integer> nodeInDegreeMap = new HashMap<String, Integer>(16);
        ArrayDeque queue = Queues.newArrayDeque();
        ArrayList topologicalSortList = Lists.newArrayList();
        for (NodeTask nodeTask : this.graph.nodes()) {
            int indegree = this.graph.inDegree((Object)nodeTask);
            nodeInDegreeMap.put(nodeTask.getId(), indegree);
            if (indegree != 0) continue;
            queue.add(nodeTask);
            topologicalSortList.add(nodeTask.getId());
        }
        while (!queue.isEmpty()) {
            NodeTask preNode = (NodeTask)queue.poll();
            for (NodeTask successorNode : this.graph.successors((Object)preNode)) {
                int indegree = (Integer)nodeInDegreeMap.get(successorNode.getId());
                if (--indegree == 0) {
                    queue.offer(successorNode);
                    topologicalSortList.add(successorNode.getId());
                }
                nodeInDegreeMap.put(successorNode.getId(), indegree);
            }
        }
        LOGGER.info("\u62d3\u6251\u6392\u5e8f\uff08topologicalSortList\uff09:" + topologicalSortList);
        return topologicalSortList.size() == this.graph.nodes().size();
    }

    public void printAllDependentOn() {
        StringBuilder builder = new StringBuilder();
        builder.append("=============NodeTask count: ").append(this.graph.nodes().size()).append("\t\n");
        for (NodeTask nodeTask : this.graph.nodes()) {
            builder.append("-------- NodeTask: ").append(nodeTask.getId()).append("--------").append("\t\n");
            builder.append("Dependent on: ");
            this.graph.successors((Object)nodeTask).forEach(v -> builder.append(v.getId()).append(", "));
            builder.append("\t\n");
            builder.append("all predecessors: ");
            this.graph.predecessors((Object)nodeTask).forEach(v -> builder.append(v.getId()).append(", "));
            builder.append("\n\n");
        }
        LOGGER.info(builder.toString());
    }

    public List<String> getTopologicallys(NodeTask startNode) {
        ArrayList<String> list = new ArrayList<String>();
        Iterable topologicallys = Traverser.forGraph(this.graph).breadthFirst((Object)startNode);
        topologicallys.iterator().forEachRemaining(s -> list.add(s.getId()));
        return list;
    }
}

