/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.onekeygenerate.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.onekeygenerate.AbstractEngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.batch.PolicyService;
import kd.taxc.tccit.business.batch.impl.YjBatchDraftService;
import kd.taxc.tccit.business.batch.impl.handler.YjDraftHandlerService;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.DraftMainService;
import kd.taxc.tccit.business.engine.refactoring.factory.DraftEngineBuilder;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.pojo.InitSeasonalPolicyVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.common.utils.DraftEntityUtils;
import kd.taxc.tccit.formplugin.seasonal.SeasonalCalcPagePlugin;
import kd.taxc.tccit.formplugin.seasonal.SeasonalPolicyEdit;

public class QysdsjbHandler
extends AbstractEngineHandler {
    public static final String LEVYTYPE = "levytype";
    private static final String ORGLIST = "orglist";
    private static final String DECLARETYPE = "declaretype";
    private static final String DRAFTPURPOSE = "draftpurpose";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORGID = "orgid";
    private YjBatchDraftService yjBatchDraftService = new YjBatchDraftService();
    private YjDraftHandlerService yjDraftHandlerService = new YjDraftHandlerService();

    public void execute(EngineModel engineModel) {
        String orgId = engineModel.getOrgId();
        String startDate = engineModel.getStartDate();
        String endDate = engineModel.getEndDate();
        String draftpurpose = engineModel.getCustom().getOrDefault(DRAFTPURPOSE, "nssb");
        boolean fzjg = OrgGroupService.isFzjg(Long.parseLong(orgId), DateUtils.stringToDate((String)endDate));
        if (fzjg) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f", (String)"QysdsjbHandler_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        DataResultVo dataResultVo = DraftMainService.hasIntersection(orgId, startDate, endDate, draftpurpose);
        if (!dataResultVo.getSuccess().booleanValue()) {
            throw new KDBizException(new ErrorCode("hasIntersection", dataResultVo.getMessage()), new Object[0]);
        }
        DataResultVo checkResultVo = BranchTaxbookBusinessService.checkBrankShare(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        if (!checkResultVo.getSuccess().booleanValue()) {
            throw new KDBizException(checkResultVo.getMessage());
        }
        InitSeasonalPolicyVo initSeasonalPolicyVo = SeasonalPolicyService.initSeasonalPolicy(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), draftpurpose);
        if (!initSeasonalPolicyVo.getExistsPreviousDraft().booleanValue()) {
            throw new KDBizException(new ErrorCode("need_show_confirm", ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u5e95\u7a3f\u7f16\u5236\u754c\u9762\u5f55\u5165\u4ece\u4e1a\u4eba\u6570", (String)"QysdsjbHandler_1", (String)"taxc-tccit", (Object[])new Object[0])), new Object[0]);
        }
        this.getEngineList().forEach(e -> e.deleteData(engineModel));
        DynamicObject policy = this.createSeasonalPolicy(engineModel, initSeasonalPolicyVo);
        String templatetype = TemplateEnum.getEnumByDeclareType((String)engineModel.getDeclareType(), (String)draftpurpose).getDraftType();
        DynamicObject dgobject = StatusUtils.queryOne((String)templatetype, (String)orgId, (String)startDate, (String)endDate, (String)draftpurpose);
        if (dgobject != null) {
            String entity = DraftEntityUtils.getEntityByDraftPurpose(draftpurpose);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dgobject.get("id"), (String)entity);
            object.set("ismodified", (Object)0);
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        } else {
            this.createDraftBill(engineModel);
            this.updateDraftCodeNumber(engineModel, templatetype);
        }
        this.yjDraftHandlerService.runTask(this.createEngineModel(engineModel, policy));
    }

    public void deleteSeasonalPolicy(EngineModel engineModel) {
        String draftpurpose = engineModel.getCustom().getOrDefault(DRAFTPURPOSE, "nssb");
        SeasonalPolicyService.delete(engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate(), draftpurpose);
    }

    public DynamicObject createSeasonalPolicy(EngineModel engineModel, InitSeasonalPolicyVo initSeasonalPolicyVo) {
        String orgId = engineModel.getOrgId();
        String startDate = engineModel.getStartDate();
        String endDate = engineModel.getEndDate();
        String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        Date lastStartDate = "month".equals(taxLimit) ? DateUtils.addMonth((Date)DateUtils.stringToDate((String)startDate), (int)-1) : DateUtils.addMonth((Date)DateUtils.stringToDate((String)startDate), (int)-3);
        Date lastEndDate = "month".equals(taxLimit) ? DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endDate), (int)-1))) : DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endDate), (int)-3)));
        DynamicObject lastPolicy = SeasonalPolicyService.getPolicy(Long.parseLong(orgId), lastStartDate, lastEndDate, "nssb");
        String declareType = this.yjBatchDraftService.initDeclareCompanyType(Long.parseLong(orgId), DateUtils.stringToDate((String)endDate));
        DynamicObject policy = this.yjBatchDraftService.contractPolicy(initSeasonalPolicyVo, Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), lastPolicy, declareType);
        this.deleteSeasonalPolicy(engineModel);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{policy});
        return policy;
    }

    public void deleteDraftBill(EngineModel engineModel) {
        String draftpurpose = engineModel.getCustom().getOrDefault(DRAFTPURPOSE, "nssb");
        String declareType = engineModel.getDeclareType();
        String draftType = TemplateEnum.getEnumByDeclareType((String)declareType, (String)draftpurpose).getDraftType();
        StatusUtils.delete((String)draftType, (String)engineModel.getOrgId(), (String)engineModel.getStartDate(), (String)engineModel.getEndDate(), (String)draftpurpose);
    }

    public DynamicObject createDraftBill(EngineModel engineModel) {
        String draftpurpose = engineModel.getCustom().getOrDefault(DRAFTPURPOSE, "nssb");
        String declareType = engineModel.getDeclareType();
        String draftType = TemplateEnum.getEnumByDeclareType((String)declareType, (String)draftpurpose).getDraftType();
        return StatusUtils.createStatus((String)draftType, (String)engineModel.getOrgId(), (String)engineModel.getStartDate(), (String)engineModel.getEndDate(), (String)this.getStatus(), (String)draftpurpose, (String)engineModel.getOrgId());
    }

    public List<IEngine> getEngineList() {
        List<IEngine> iEngines = DraftEngineBuilder.initTccitSeasonalIEngine();
        iEngines.add(new SeasonalCalcPagePlugin());
        iEngines.add(new SeasonalPolicyEdit());
        return iEngines;
    }

    protected String getStatus() {
        int size = TaxStepsConstant.getTccitSeasonal().size();
        return String.valueOf(size);
    }

    public String getDraftNumberPrefix(EngineModel model, String draftType) {
        Map customParams = model.getCustom();
        String draftpurpose = customParams.getOrDefault(DRAFTPURPOSE, "nssb");
        String orgId = model.getOrgId();
        String endDate = model.getEndDate();
        String billType = DeclareCompanyTypeService.getDgType(orgId, endDate, "seasonal");
        return "sjjt".equals(draftpurpose) ? "EITACCURE-" + billType : "CIT-" + billType;
    }

    private EngineModel createEngineModel(EngineModel engineModel, DynamicObject policy) {
        EngineModel innerEngineModel = new EngineModel(engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate());
        innerEngineModel.getCustom().putAll(this.createCustomMap(innerEngineModel, policy));
        return innerEngineModel;
    }

    protected Map<String, Object> createCustomMap(EngineModel engineModel, DynamicObject policy) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(ORGID, engineModel.getOrgId());
        customParams.put(SKSSQQ, engineModel.getStartDate());
        customParams.put(SKSSQZ, engineModel.getEndDate());
        List<Object> orgList = PolicyService.getOrgIdsBySeaSonalPolicy(engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate());
        customParams.put(ORGLIST, orgList);
        customParams.put(DECLARETYPE, policy.getString(DECLARETYPE));
        customParams.put(LEVYTYPE, policy.getString(LEVYTYPE));
        customParams.put(DRAFTPURPOSE, policy.getString(DRAFTPURPOSE));
        customParams.put("policy", policy);
        return customParams;
    }

    public void handleException(KDBizException exception, IFormView view, IFormPlugin plugin) {
        view.showErrorNotification(exception.getMessage());
    }
}

