/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.org;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;

public class OrgGroupService {
    public static Boolean exists(Long subOrgId, Date endDate) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)subOrgId);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter levelFilter = new QFilter("orgrow.level", "!=", (Object)1);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"effectdate,orgrow.orgid as orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.parentid as parentid,orgrow.orgname as orgname", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, levelFilter, OrgUtils.getQFilter((Date)endDate)});
        return object != null;
    }

    public static Boolean exists(String orgNumber, Date endDate) {
        Long orgId = (Long)TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgNum((String)orgNumber).getData();
        if (orgId == 0L) {
            return Boolean.FALSE;
        }
        return OrgGroupService.exists(orgId, endDate);
    }

    public static DynamicObjectCollection getOrgGroupDynamicObjects(String orgid, String skssqz, String taxtype, String status) {
        QFilter orgFilter = new QFilter("orgrow.collectorg", "=", (Object)orgid);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        return QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx,orgrow.levelname as levelname,participation", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)DateUtils.stringToDate((String)skssqz))}, (String)"orgrow.seq asc");
    }

    public static DynamicObjectCollection getOrgGroup(String orgid, String endDate, String taxtype, String status) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)Long.valueOf(orgid));
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        return QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter, billstatusFilter, OrgUtils.getQFilter((Date)DateUtils.stringToDate((String)endDate))});
    }

    public static DynamicObject loadTaxMainByOrgId(String orgId) {
        List data = (List)TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(orgId))).getData();
        if (EmptyCheckUtils.isNotEmpty((Object)data)) {
            return (DynamicObject)data.get(0);
        }
        return null;
    }

    public static List<Long> getOrgIds(Long orgid, Date startDate, Date endDate) {
        QFilter statusFilter;
        List<Long> result = new ArrayList<Long>();
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter orgFilter = new QFilter("orgrow.collectorg", "=", (Object)(orgid != null ? orgid.toString() : "0"));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.id,orgrow.pid,orgrow.orgid as orgid,orgrow.shareid as share,orgrow.declaration as declare,orgrow.kdqjyqylx as kdqjyqylx", (QFilter[])new QFilter[]{taxtypeFilter, orgFilter, statusFilter = new QFilter("status", "=", (Object)"2"), OrgUtils.getQFilter((Date)endDate)});
        if (CollectionUtils.isEmpty((Collection)objects)) {
            result.add(orgid);
        } else {
            result = objects.stream().map(s -> s.getLong("orgid")).collect(Collectors.toList());
        }
        return result;
    }

    public static DynamicObjectCollection queryOrgGroupDetailForCollectedOrg(String type, String orgid, String enddate) {
        String fields = "orgrow.orgid as orgid, orgrow.declaration as declaration,orgrow.levelname as levelname";
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter collectorgFilter = new QFilter("orgrow.collectorg", "=", (Object)orgid);
        QFilter declarationFilter = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter shareidFilter = new QFilter("orgrow.shareid", "=", (Object)true);
        QFilter q = new QFilter("effectdate", "<=", (Object)DateUtils.getLastDateOfMonth1((Date)DateUtils.stringToDate((String)enddate))).and("invaliddate", ">=", (Object)DateUtils.getLastDateOfMonth1((Date)DateUtils.stringToDate((String)enddate)));
        q = q.or(new QFilter("effectdate", "<=", (Object)DateUtils.getLastDateOfMonth1((Date)DateUtils.stringToDate((String)enddate))).and(QFilter.isNull((String)"invaliddate")));
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, collectorgFilter, declarationFilter, shareidFilter, q};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)fields, (QFilter[])filters, (String)"orgrow.declaration asc");
        return collection;
    }

    public static String getLevyType(Long orgId) {
        QFilter q1 = new QFilter("categoryentryentity.taxtype", "=", (Object)"qysds");
        QFilter q2 = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject object = QueryServiceHelper.queryOne((String)TaxcMainConstant.ENTITYNAME, (String)"categoryentryentity.levytype as levytype", (QFilter[])new QFilter[]{q1, q2});
        if (object != null) {
            return object.getString("levytype");
        }
        return "czzs";
    }

    public static boolean isFzjg(Long orgid, Date endDate) {
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{new QFilter("orgrow.orgid", "=", (Object)orgid), new QFilter("orgrow.declaration", "=", (Object)"3"), new QFilter("taxtype", "=", (Object)"qysds"), new QFilter("status", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C"), OrgUtils.getQFilter((Date)endDate)});
    }

    public static boolean isZjg(String orgid, String endDate) {
        String declareCompanyType = DeclareCompanyTypeService.getDeclareCompanyType(orgid, endDate);
        return Arrays.asList("210", "220", "230").contains(declareCompanyType);
    }

    public static DynamicObject getQysdsCard(String orgId) {
        DynamicObject object = OrgGroupService.loadTaxMainByOrgId(orgId);
        if (object != null) {
            return object.getDynamicObjectCollection("categoryentryentity").stream().filter(a -> "qysds".equals(a.getString("taxtype"))).findFirst().orElseGet(() -> null);
        }
        return null;
    }

    public static String queryzjgOrgIdForAggregator(String type, String shareid, String orgid, Date startdate, Date enddate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter shareFilter = new QFilter("orgrow.shareid", "=", (Object)shareid);
        QFilter ziorgidFilter = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(orgid));
        QFilter[] filters = new QFilter[]{statusFilter, billstatusFilter, typeFilter, shareFilter, ziorgidFilter, OrgUtils.getQFilter((Date)enddate)};
        DynamicObjectCollection object = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.collectorg as collectorg", (QFilter[])filters, (String)"orgrow.orgid");
        if (null != object && object.size() > 0) {
            return ((DynamicObject)object.get(0)).getString("collectorg");
        }
        return null;
    }

    public static List<Long> getAllPermOrgs(String appId, String entityId, String permItemId) {
        TaxResult permOrgs = PermDataServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityId, (String)permItemId);
        if (permOrgs.isSuccess() && !ObjectUtils.isEmpty((Object)permOrgs.getData())) {
            return (List)permOrgs.getData();
        }
        return new ArrayList<Long>();
    }

    public static String getRegisteraddressId(String orgId, String startdate, String enddate) {
        TaxResult taxResult;
        String zjgOrgId = OrgGroupService.queryzjgOrgIdForAggregator("qysds", "1", orgId, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate));
        if (EmptyCheckUtils.isNotEmpty((Object)zjgOrgId) && (taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(zjgOrgId))).isSuccess()) {
            DynamicObject level2;
            DynamicObject taxoffice = ((DynamicObject)taxResult.getData()).getDynamicObject("taxoffice");
            if (taxoffice == null) {
                return "0";
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorgan", (String)"taxorganaddress", (QFilter[])new QFilter[]{new QFilter("id", "=", taxoffice.get("id"))});
            long registeraddressId = object.getLong("taxorganaddress");
            DynamicObject admindivision = BusinessDataServiceHelper.loadSingle((Object)registeraddressId, (String)"bd_admindivision");
            String longnumber = admindivision.getString("longnumber");
            String[] split = longnumber.split("\\.");
            String rootNumber = split[0];
            String level2Number = null;
            if (split.length > 1 && (level2 = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id,name,simplespell", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(level2Number = split[1]))})) != null && Lists.newArrayList((Object[])new String[]{"SZS", "DLS", "QDS", "NBS", "XMS"}).contains(level2.getString("simplespell"))) {
                return level2.getString("id");
            }
            DynamicObject root = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)rootNumber)});
            return root.getString("id");
        }
        return "0";
    }
}

