/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.policy;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.InitSeasonalPolicyVo;

public class SeasonalPolicyService {
    public static final String SEASONAL_POLICY = "tccit_seasonal_policy";

    public static DynamicObject getPolicy(Long orgid, Date startDate, Date endDate, String draftpurpose) {
        QFilter q3 = new QFilter("orgid", "=", (Object)orgid);
        QFilter q1 = new QFilter("startdate", "=", (Object)startDate);
        QFilter q2 = new QFilter("enddate", "=", (Object)endDate);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        return QueryServiceHelper.queryOne((String)SEASONAL_POLICY, (String)"id,orgid.id,startdate,enddate,declaretype,yjprofitslogic,residenttype,levytype,checkcollectway,draftpurpose,illegal,sospersonnum,eospersonnum,eosassets,zjgftbl,czjzfpbl,qbfzjgftbl", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
    }

    private static BigDecimal getLastSeasonPersonNum(Long orgId, Date queryEnd, int monthOfDate) {
        QFilter org = new QFilter("org", "=", (Object)orgId);
        QFilter skssqz = new QFilter("skssqz", "=", (Object)queryEnd);
        QFilter type = new QFilter("type", "in", Arrays.asList("qysdsjb", "qysds_hdzs_jb"));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{skssqz, org, type});
        if (object != null) {
            String id = object.getString("id");
            QFilter sbbid = new QFilter("sbbid", "=", (Object)id);
            QFilter ewblxh = new QFilter("ewblxh", "=", (Object)SeasonalPolicyService.getEwblxh(monthOfDate));
            DynamicObject personObject = QueryServiceHelper.queryOne((String)"tccit_qysds_jdtbxx", (String)"cyrs", (QFilter[])new QFilter[]{sbbid, ewblxh});
            if (personObject != null) {
                return personObject.getBigDecimal("cyrs");
            }
        }
        return null;
    }

    private static String getEwblxh(int monthOfDate) {
        String ewblxh = "2";
        switch (monthOfDate) {
            case 3: {
                ewblxh = "2";
                break;
            }
            case 6: {
                ewblxh = "4";
                break;
            }
            case 9: {
                ewblxh = "6";
                break;
            }
            case 12: {
                ewblxh = "8";
            }
        }
        return ewblxh;
    }

    public static DynamicObject getPolicy(Long orgid, Date endDate, String draftpurpose) {
        QFilter q3 = new QFilter("orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("enddate", "=", (Object)endDate);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        return QueryServiceHelper.queryOne((String)SEASONAL_POLICY, (String)"id,startdate,enddate,declaretype,illegal,sospersonnum,eospersonnum,eosassets,zjgftbl,czjzfpbl,qbfzjgftbl", (QFilter[])new QFilter[]{q2, q3, draftpurposeFilter});
    }

    public static DynamicObject getPolicyByDateRange(Long orgid, Date startDate, Date endDate, String draftpurpose) {
        QFilter q3 = new QFilter("orgid", "=", (Object)orgid);
        QFilter q1 = new QFilter("startdate", ">=", (Object)startDate);
        QFilter q2 = new QFilter("enddate", "<=", (Object)endDate);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        return QueryServiceHelper.queryOne((String)SEASONAL_POLICY, (String)"id,declaretype,illegal,sospersonnum,eospersonnum,eosassets,zjgftbl,czjzfpbl,qbfzjgftbl", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
    }

    public static InitSeasonalPolicyVo initSeasonalPolicy(Long orgId, Date startDate, Date endDate, String draftpurpose) {
        String yjprofitslogic;
        Optional<DynamicObject> optional;
        InitSeasonalPolicyVo initSeasonalPolicyVo = new InitSeasonalPolicyVo();
        DynamicObject object = OrgGroupService.loadTaxMainByOrgId(String.valueOf(orgId));
        initSeasonalPolicyVo.setIllegal(object != null ? object.getBoolean("restrictbanindustry") : false);
        if (object != null && (optional = object.getDynamicObjectCollection("categoryentryentity").stream().filter(e -> "qysds".equals(e.getString("taxtype"))).findFirst()).isPresent()) {
            DynamicObject qysdsCard = optional.get();
            initSeasonalPolicyVo.setLevytype(qysdsCard.getString("levytype"));
            initSeasonalPolicyVo.setResidenttype(qysdsCard.getString("residenttype"));
            initSeasonalPolicyVo.setCheckcollectway(qysdsCard.getString("approvedcollectionmethod"));
            initSeasonalPolicyVo.setTaxableincomerate(qysdsCard.getBigDecimal("taxableincometaxrate"));
        }
        initSeasonalPolicyVo.setYjprofitslogic(StringUtil.isBlank((CharSequence)(yjprofitslogic = (String)SystemParamUtil.getAppParameter((String)"tccit", (String)"yjprofitslogic", (long)orgId))) ? "bnlje" : yjprofitslogic);
        Date currentSeasonalStart = DateUtils.getFirstDateOfSeason((Date)startDate);
        Date queryStart = DateUtils.addMonth((Date)currentSeasonalStart, (int)-3);
        Date queryEnd = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)queryStart));
        BigDecimal lastSeasonPersonNum = SeasonalPolicyService.getLastSeasonPersonNum(orgId, queryEnd, DateUtils.getMonthOfDate((Date)queryEnd));
        DynamicObject policy = SeasonalPolicyService.getPolicy(orgId, queryEnd, draftpurpose);
        if (lastSeasonPersonNum != null) {
            initSeasonalPolicyVo.setSospersonnum(Integer.parseInt(BigDecimalUtil.setScale((Object)lastSeasonPersonNum, (int)0).toString()));
        }
        if (lastSeasonPersonNum == null || lastSeasonPersonNum.compareTo(BigDecimal.ZERO) <= 0) {
            initSeasonalPolicyVo.setSospersonnum(policy != null ? policy.getInt("eospersonnum") : 0);
        }
        DynamicObject bill = null;
        if (policy != null) {
            queryStart = policy.getDate("startdate");
            queryEnd = policy.getDate("enddate");
            bill = StatusUtils.queryOne((String)"draft_qysdsjb", (String)String.valueOf(orgId), (String)DateUtils.format((Date)queryStart), (String)DateUtils.format((Date)queryEnd), (String)draftpurpose);
        }
        initSeasonalPolicyVo.setExistsPreviousDraft(policy != null && bill != null || lastSeasonPersonNum != null ? Boolean.TRUE : Boolean.FALSE);
        DynamicObject eospersonnum = SeasonalPolicyService.getEospersonnum(orgId, startDate, endDate);
        int totaleospersonnum = eospersonnum == null ? initSeasonalPolicyVo.getSospersonnum() : (eospersonnum.getInt("totaleospersonnum") == 0 ? initSeasonalPolicyVo.getSospersonnum().intValue() : eospersonnum.getInt("totaleospersonnum"));
        initSeasonalPolicyVo.setEospersonnum(totaleospersonnum);
        return initSeasonalPolicyVo;
    }

    private static DynamicObject getEospersonnum(Long orgId, Date startDate, Date endDate) {
        DynamicObject eospersonnum;
        DynamicObject orgGroup = SeasonalPolicyService.getOrgGroup(orgId, startDate, endDate);
        if (orgGroup != null) {
            DynamicObjectCollection orgrow = orgGroup.getDynamicObjectCollection("orgrow");
            List<Long> orgids = orgrow.stream().map(e -> e.getLong("orgid_id")).collect(Collectors.toList());
            eospersonnum = SeasonalPolicyService.getEospersonnum(orgids, endDate);
        } else {
            eospersonnum = SeasonalPolicyService.getEospersonnum(Collections.singletonList(orgId), endDate);
        }
        return eospersonnum;
    }

    private static DynamicObject getOrgGroup(Long orgId, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)orgId);
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter effectDateFilter = new QFilter("effectdate", "<=", (Object)startDate);
        QFilter invalidDateFilter = new QFilter("invaliddate", ">=", (Object)endDate).or(new QFilter("invaliddate", "is null", null));
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter declaretypeFilter = new QFilter("orgrow.declaration", "=", (Object)"2");
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject query = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"id", (QFilter[])new QFilter[]{orgFilter, taxTypeFilter, effectDateFilter, invalidDateFilter, statusFilter, declaretypeFilter, billstatusFilter});
        if (query == null) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"tctb_org_group_latest");
        DynamicObject[] ids = BusinessDataServiceHelper.load((Object[])new Long[]{query.getLong("id")}, (DynamicObjectType)type);
        if (ids.length > 0) {
            return ids[0];
        }
        return null;
    }

    private static DynamicObject getEospersonnum(List<Long> orgids, Date endDate) {
        QFilter orgFilter = new QFilter("org", "in", orgids);
        QFilter countDateFilter = new QFilter("countdate", "=", (Object)endDate);
        return QueryServiceHelper.queryOne((String)"tdm_employee_count", (String)"sum(headcount) as totaleospersonnum", (QFilter[])new QFilter[]{orgFilter, countDateFilter});
    }

    public static void delete(String orgid, String startDate, String endDate, String draftpurpose) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter q2 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("draftpurpose", "=", (Object)draftpurpose);
        DeleteServiceHelper.delete((String)SEASONAL_POLICY, (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }
}

