/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.tccit.business.task.CaculateRulesTask;

public class RuleQueryService {
    private static Log logger = LogFactory.getLog(RuleQueryService.class);

    public static List<TreeNode> getNodeList(DynamicObject org, boolean showdisable) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        TreeNode root = new TreeNode();
        root.setId("0");
        QFilter qFilter = new QFilter("subtable.typecopy", "=", (Object)"income");
        DynamicObjectCollection income = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"subtable.id as id, subtable.projname as projname, subtable.parentid as parentid,subtable.costcollect as rulesnum", (QFilter[])new QFilter[]{qFilter}, (String)"subtable.projnumber");
        collection.addAll((Collection)income);
        ArrayList firstnode = Lists.newArrayList((Object[])new String[]{"period", "ajust", "dsale", "zcajust", "srajust", "tssx", "other"});
        for (String node : firstnode) {
            QFilter qFilter1 = new QFilter("subtable.typecopy", "in", (Object)node);
            DynamicObjectCollection other = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"subtable.id as id, subtable.projname as projname, subtable.parentid as parentid,subtable.costcollect as rulesnum", (QFilter[])new QFilter[]{qFilter1});
            collection.addAll((Collection)other);
        }
        QFilter qFilter2 = new QFilter("subtable.typecopy", "=", (Object)"ssyh");
        DynamicObjectCollection ssyh = QueryServiceHelper.query((String)"tpo_discount_items", (String)"subtable.id as id, subtable.projname as projname,subtable.parentid as parentid,subtable.description as rulesnum", (QFilter[])new QFilter[]{qFilter2});
        collection.addAll((Collection)ssyh);
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)new CaculateRulesTask(collection, org, showdisable));
        try {
            List<DynamicObject> List2 = RuleQueryService.getFutureList(futures);
            for (DynamicObject entry : List2) {
                String Id = entry.getString("id");
                String name = entry.getString("projname");
                String parentid = entry.getString("parentid");
                String num = entry.getString("rulesnum");
                TreeNode leftRoot = new TreeNode();
                leftRoot.setParentid(parentid);
                leftRoot.setId(Id);
                leftRoot.setText(name + "(" + num + ")");
                nodeList.add(leftRoot);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        int sumchild = RuleQueryService.getrules(RuleQueryService.getChildList("0", null), org, showdisable).size();
        root.setText(String.format(ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"RuleQueryService_0", (String)"taxc-tccit", (Object[])new Object[0]), sumchild));
        nodeList.add(root);
        return nodeList;
    }

    public static List<Long> getChildList(String id, String type) {
        ArrayList<Long> list = new ArrayList<Long>();
        DynamicObjectCollection dyos = null;
        Long currentid = Long.parseLong(id);
        QFilter qFilter = new QFilter("entryid", "=", (Object)currentid);
        QFilter qFilter1 = new QFilter("type", "=", (Object)"ssyh");
        QFilter qFilter2 = new QFilter("type", "!=", (Object)"ssyh");
        dyos = type == null ? QueryServiceHelper.query((String)"tccit_rule_nbchild", (String)"childid", (QFilter[])new QFilter[]{qFilter}) : (type.equals("ssyh") ? QueryServiceHelper.query((String)"tccit_rule_nbchild", (String)"childid", (QFilter[])new QFilter[]{qFilter, qFilter1}) : QueryServiceHelper.query((String)"tccit_rule_nbchild", (String)"childid", (QFilter[])new QFilter[]{qFilter, qFilter2}));
        for (DynamicObject dyo : dyos) {
            long childid = dyo.getLong("childid");
            list.add(childid);
        }
        return list;
    }

    public static DynamicObjectCollection getrules(List<Long> number, DynamicObject org, boolean showdisable) {
        DynamicObjectCollection rules = new DynamicObjectCollection();
        if (null != org) {
            ArrayList yearlist = Lists.newArrayList((Object[])new String[]{"remincome", "remperiod", "remajust", "srajust", "zcajust", "dsale", "other", "ssyh", "tssx"});
            ArrayList<Long> ruleids = new ArrayList<Long>();
            ArrayList sbxPlanQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", org.get("id")).and(new QFilter("ruleentity.type", "in", (Object)yearlist))});
            DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tccit_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid,ruleentity.type as type", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
            for (DynamicObject sharingRule : sharingRules) {
                Long ruleid = sharingRule.getLong("ruleid");
                ruleids.add(ruleid);
            }
            for (Long id : number) {
                DynamicObjectCollection rule;
                QFilter qFilter3 = new QFilter("org", "=", org.get("id"));
                QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                QFilter qFilter5 = new QFilter("item", "=", (Object)id);
                QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                QFilter qFilter7 = new QFilter("id", "in", ruleids);
                if (showdisable) {
                    QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7.and(qFilter5))};
                    rule = QueryServiceHelper.query((String)"tccit_year_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])allfilter);
                    rules.addAll((Collection)rule);
                    continue;
                }
                QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7.and(qFilter5).and(qFilter6))};
                rule = QueryServiceHelper.query((String)"tccit_year_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])enalbefilter);
                rules.addAll((Collection)rule);
            }
        }
        return rules;
    }

    public static List<DynamicObject> getFutureList(List<Future<Object>> futures) throws Exception {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (Future<Object> future : futures) {
            list.addAll((Collection)future.get());
        }
        return list;
    }

    public static Map<Long, String> getYearItemRules(List<Long> ruleIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(ruleIds)) {
            return result;
        }
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"subtable.id as id,subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "in", ruleIds)});
        return objects.stream().collect(Collectors.toMap(s -> s.getLong("id"), s -> s.getString("projname"), (x, y) -> x));
    }

    public static Map<Long, String> getDiscountItemRules(List<Long> ruleIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(ruleIds)) {
            return result;
        }
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tpo_discount_items", (String)"subtable.id as id,subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "in", ruleIds)});
        return objects.stream().collect(Collectors.toMap(s -> s.getLong("id"), s -> s.getString("projname"), (x, y) -> x));
    }
}

