/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.enums.RuleTypeNodeEnum;
import org.apache.commons.collections.CollectionUtils;

public class RuleService {
    public static final String TCCIT_ALL_RULE_CONFIG = "tccit_all_rule_config";

    public static DynamicObjectCollection getYearRule(String keyword, Long orgId, String type, String ruleType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            QFilter q1 = new QFilter("name", "like", (Object)("%" + keyword + "%"));
            QFilter q2 = new QFilter("item.name", "like", (Object)("%" + keyword + "%"));
            filterList.add(q1.or(q2));
        }
        filterList.add(new QFilter("org", "=", (Object)orgId));
        filterList.add(new QFilter("type", "=", (Object)type));
        filterList.add(new QFilter("ruletype", "=", (Object)ruleType));
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"tccit_year_rule", (String)"id,type,ruletype,costtype,item,enable,name,modifytime", (QFilter[])filterList.toArray(new QFilter[0]), (String)"id");
        return rules;
    }

    public static List<DynamicObject> getSharingAndOrgRules(List<Long> orglist, RuleTypeEnum type) {
        ArrayList sbxPlanQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "in", orglist)});
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tccit_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid,ruleentity.type as type", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
        HashMap<String, List<Long>> rulePublicIdMap = new HashMap<String, List<Long>>();
        for (DynamicObject sharingRule : sharingRules) {
            String ruletype = sharingRule.getString("type");
            List ids = rulePublicIdMap.computeIfAbsent(ruletype, k -> new ArrayList());
            ids.add(sharingRule.getLong("ruleid"));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("org", "in", orglist));
        filterList.add(new QFilter("ruletype", "=", (Object)"private"));
        HashMap<RuleTypeEnum, List<DynamicObject>> result = new HashMap<RuleTypeEnum, List<DynamicObject>>();
        if (RuleTypeEnum.ALL == type) {
            Arrays.stream(RuleTypeEnum.values()).filter(e -> RuleTypeEnum.ALL != e && RuleTypeEnum.ALL_HJ_RULES != e).forEach(ruleTypeEnum -> RuleService.queryRulesByType(ruleTypeEnum, Boolean.FALSE, rulePublicIdMap, filterList, result));
        } else {
            RuleService.queryRulesByType(type, Boolean.FALSE, rulePublicIdMap, filterList, result);
        }
        return (List)result.get((Object)type);
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(Long orgid, RuleTypeEnum type, String rulepurpose) {
        return RuleService.getSharingAndOrgRules(orgid, null, type, Boolean.FALSE, rulepurpose, "czzs");
    }

    public static List<DynamicObject> getSharingAndOrgRuleList(Long orgid, RuleTypeEnum type, String rulepurpose, String levytype) {
        return RuleService.getSharingAndOrgRules(orgid, null, type, Boolean.FALSE, rulepurpose, levytype).get((Object)type);
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getAllSharingAndOrgRuleList(Long orgid, String rulepurpose, String levytype) {
        List<RuleTypeEnum> ruleTypeEnums = "czzs".equals(levytype) ? Arrays.asList(RuleTypeEnum.INCOME, RuleTypeEnum.DEPRECIATE, RuleTypeEnum.PROFITS, RuleTypeEnum.YJ_OTHER) : Arrays.asList(RuleTypeEnum.INCOME, RuleTypeEnum.PROFITS);
        HashMap<RuleTypeEnum, List<DynamicObject>> ruleMap = new HashMap<RuleTypeEnum, List<DynamicObject>>();
        for (RuleTypeEnum type : ruleTypeEnums) {
            ruleMap.putAll(RuleService.getSharingAndOrgRules(orgid, null, type, Boolean.FALSE, rulepurpose, levytype));
        }
        return ruleMap;
    }

    public static Map<RuleTypeEnum, List<DynamicObject>> getSharingAndOrgRules(Long orgid, Long excludingPlanId, RuleTypeEnum type, Boolean includingDisable, String rulepurpose, String levytype) {
        ArrayList sbxPlanQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", (Object)orgid)});
        if (excludingPlanId != null && excludingPlanId != 0L) {
            sbxPlanQfilters.add(new QFilter("id", "!=", (Object)excludingPlanId));
        }
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tccit_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid,ruleentity.type as type", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
        HashMap<String, List<Long>> rulePublicIdMap = new HashMap<String, List<Long>>(16);
        for (DynamicObject sharingRule : sharingRules) {
            boolean exists;
            String ruletype = sharingRule.getString("type");
            List ids = rulePublicIdMap.computeIfAbsent(ruletype, k -> new ArrayList());
            if (type == RuleTypeEnum.DEPRECIATE || type == RuleTypeEnum.YJ_OTHER) {
                exists = QueryServiceHelper.exists((String)type.getEntry(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sharingRule.getLong("ruleid")), new QFilter("rulepurpose", "like", (Object)("%" + rulepurpose + "%"))});
                if (!exists) continue;
                ids.add(sharingRule.getLong("ruleid"));
                continue;
            }
            if (type == RuleTypeEnum.PROFITS || type == RuleTypeEnum.INCOME) {
                exists = QueryServiceHelper.exists((String)type.getEntry(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sharingRule.getLong("ruleid")), new QFilter("rulepurpose", "like", (Object)("%" + rulepurpose + "%")), new QFilter("levytype", "=", (Object)levytype)});
                if (!exists) continue;
                ids.add(sharingRule.getLong("ruleid"));
                continue;
            }
            ids.add(sharingRule.getLong("ruleid"));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("org", "=", (Object)orgid));
        filterList.add(new QFilter("ruletype", "=", (Object)"private"));
        if (type == RuleTypeEnum.INCOME || type == RuleTypeEnum.DEPRECIATE || type == RuleTypeEnum.PROFITS || type == RuleTypeEnum.YJ_OTHER) {
            filterList.add(new QFilter("rulepurpose", "like", (Object)("%" + rulepurpose + "%")));
        }
        if (type == RuleTypeEnum.PROFITS || type == RuleTypeEnum.INCOME) {
            filterList.add(new QFilter("levytype", "=", (Object)levytype));
        }
        if (!includingDisable.booleanValue()) {
            filterList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        HashMap<RuleTypeEnum, List<DynamicObject>> result = new HashMap<RuleTypeEnum, List<DynamicObject>>();
        if (RuleTypeEnum.ALL == type) {
            Arrays.stream(RuleTypeEnum.values()).filter(e -> RuleTypeEnum.ALL != e && RuleTypeEnum.ALL_HJ_RULES != e).forEach(ruleTypeEnum -> RuleService.queryRulesByType(ruleTypeEnum, includingDisable, rulePublicIdMap, filterList, result));
        } else {
            RuleService.queryRulesByType(type, includingDisable, rulePublicIdMap, filterList, result);
        }
        return result;
    }

    private static void queryRulesByType(RuleTypeEnum ruleType, Boolean includingDisable, Map<String, List<Long>> rulePublicIdMap, List<QFilter> filterList, Map<RuleTypeEnum, List<DynamicObject>> result) {
        List ids = new ArrayList();
        if (ruleType == RuleTypeEnum.ALL_HJ_RULES) {
            for (Map.Entry<String, List<Long>> entry : rulePublicIdMap.entrySet()) {
                ids.addAll((Collection)entry.getValue());
            }
        } else {
            ids = rulePublicIdMap.getOrDefault(ruleType.getName(), rulePublicIdMap.getOrDefault(ruleType.getVal(), new ArrayList()));
        }
        if (null != ruleType.getVal()) {
            filterList.add(new QFilter("type", "=", (Object)ruleType.getVal()));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ruleType.getEntry(), (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        if (null != ruleType.getVal()) {
            filterList.remove(filterList.size() - 1);
        }
        List privateids = dynamicObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        ids.addAll(privateids);
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
        Object[] rulearray = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ruleType.getEntry()));
        CollectionUtils.addAll(rules, (Object[])rulearray);
        rules.removeIf(rule -> !"1".equals(rule.getDynamicObject("org").getString("enable")));
        if (!includingDisable.booleanValue()) {
            rules.removeIf(rule -> !rule.getBoolean("enable"));
        }
        result.put(ruleType, new ArrayList(rules));
        List objects = result.computeIfAbsent(RuleTypeEnum.ALL, r -> new ArrayList());
        objects.addAll(new ArrayList(rules));
    }

    public static DynamicObject saveRule(DynamicObject ruleObject, String issystem) {
        block18: {
            String formId = ruleObject.getDataEntityType().getName();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_ALL_RULE_CONFIG);
            String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)ruleObject, (String)ruleObject.getString("org.id"));
            ruleObject.set("number", (Object)number);
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ruleObject});
                if (objs == null || objs.length <= 0) break block18;
                DynamicObject obj = objs[0];
                RuleService.copyAndSetObject(obj, dynamicObject, formId, issystem);
                Long id = obj.getLong("id");
                if (QueryServiceHelper.exists((String)TCCIT_ALL_RULE_CONFIG, (Object)id)) {
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                    DynamicObject dynamicObject2 = ruleObject;
                    return dynamicObject2;
                }
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new KDBizException(t.getMessage());
                }
            }
        }
        return ruleObject;
    }

    private static void copyAndSetObject(DynamicObject source, DynamicObject target, String formId, String issystem) {
        BeanCopyUtils.copyDynamicObjectWithoutEntity((DynamicObject)source, (DynamicObject)target);
        if (RuleTypeNodeEnum.PROFITS.getFormId().equals(formId)) {
            target.set("itemtype", (Object)"tpo_yearitems_tree");
        }
        if (RuleTypeNodeEnum.PREFERENTIAL.getFormId().equals(formId)) {
            target.set("item", (Object)source.getDynamicObject("itemchoicename").getLong("id"));
            target.set("itemtype", (Object)"tpo_discount_tree");
        }
        if (RuleTypeNodeEnum.DEPRECIATION.getFormId().equals(formId)) {
            target.set("item", (Object)source.getDynamicObject("depreciatetype").getLong("id"));
            target.set("itemtype", (Object)"tpo_yearitems_tree");
        }
        if (RuleTypeNodeEnum.YJOTHER.getFormId().equals(formId)) {
            target.set("itemtype", (Object)"tpo_yearitems_tree");
        }
        if (RuleTypeNodeEnum.STANDINGBOOK.getFormId().equals(formId)) {
            target.set("item", (Object)source.getDynamicObject("standingbooks").getLong("id"));
            target.set("itemtype", (Object)"tpo_standingbook_tree");
        }
        Long groupId = "tccit_year_rule".equals(formId) ? RuleTypeNodeEnum.getGroupId(formId, source.getString("type")) : RuleTypeNodeEnum.getGroupId(formId);
        target.set("group", (Object)groupId);
        target.set("issystem", (Object)issystem);
    }
}

