/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.sbb;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SbbQueryService {
    public static DynamicObject queryOne(String entityName, String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getQysdsZb2015(String cache_sbbid) {
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)cache_sbbid);
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"2");
        return SbbQueryService.queryOne("tccit_qysds_zb_2015", "byswjgqdyjsde,bysjynsdse,bysjybsdse,zjgstsdse,czjzfpsdse,zjgdlscjybmyftsdse,jgfpsdse,sjlre,byynsdse", new QFilter[]{rowFilter, sbbidFilter});
    }

    public static DynamicObject getQysdsFbJmmx2015(String cache_sbbid) {
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)cache_sbbid);
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"1");
        return SbbQueryService.queryOne("tccit_qysds_fb_jmmx_2015", "total", new QFilter[]{rowFilter, sbbidFilter});
    }

    public static BigDecimal getQysdsZb(String sbbid, String column) {
        DynamicObject dynamiczb = SbbQueryService.getQysdsDetailObject(sbbid, column, "tccit_qysds_zb");
        return dynamiczb != null ? dynamiczb.getBigDecimal(column) : BigDecimal.ZERO;
    }

    public static DynamicObject getQysdsDetailObject(String sbbid, String column, String entityName) {
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"1");
        DynamicObject dynamiczb = SbbQueryService.queryOne(entityName, column, new QFilter[]{rowFilter, sbbidFilter});
        return dynamiczb;
    }

    public static BigDecimal getQysdsZjgxx(String sbbid, String column) {
        DynamicObject dynamiczb = SbbQueryService.getQysdsDetailObject(sbbid, column, "tccit_qysds_zjgxx");
        return dynamiczb != null ? dynamiczb.getBigDecimal(column) : BigDecimal.ZERO;
    }

    public static BigDecimal getSumQysdsZjgxx(String sbbid, String column, String name) {
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter nameFilter = new QFilter("fzjgmc", "=", (Object)name);
        DynamicObject dynamicObject = SbbQueryService.queryOne("tccit_qysds_fzjgxx_dyn", column, new QFilter[]{sbbidFilter, nameFilter});
        return dynamicObject == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal(column);
    }

    public static BigDecimal getHdzs2018Zb(String sbbid, String column) {
        DynamicObject dynamiczb = SbbQueryService.getQysdsDetailObject(sbbid, column, "tccit_hsqjsbb_b_2018");
        return dynamiczb != null ? dynamiczb.getBigDecimal(column) : BigDecimal.ZERO;
    }

    public static BigDecimal getQysdsA100000(String sbbid, String column) {
        DynamicObject dynamiczb = SbbQueryService.getQysdsDetailObject(sbbid, column, "tccit_qysds_a100000");
        return dynamiczb != null ? dynamiczb.getBigDecimal(column) : BigDecimal.ZERO;
    }

    public static void updateTaxDeclareMain(String orgid, Date skssqq, Date skssqz, BigDecimal bqjmse) {
        SbbQueryService.updateTaxDeclareMainBySbbid(SbbQueryService.getCurrentSbbid(orgid, skssqq, skssqz, 0), bqjmse);
    }

    public static void updateTaxDeclareMainBySbbid(String sbbid, BigDecimal bqybtse) {
        DynamicObject object;
        if (StringUtil.isNotBlank((CharSequence)sbbid) && !Objects.equals(sbbid, "0") && (object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)"tctb_declare_main")) != null) {
            object.set("bqybtse", (Object)bqybtse);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    public static String getCurrentSbbid(String orgid, Date skssqq, Date skssqz, int month) {
        String startdate = DateUtils.format((Date)skssqq);
        String enddate = DateUtils.format((Date)skssqz);
        return YbnsrService.queryYbnsrPre((String)orgid, (String)"qysdsnb", (String)startdate, (String)enddate, (int)month);
    }

    public static String getSbbidStr(Date skssqq, Date skssqz, String orgId, String type) {
        DynamicObjectCollection sbbid = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz), new QFilter("org", "=", (Object)Long.parseLong(orgId))});
        if (null != sbbid && !sbbid.isEmpty()) {
            return String.valueOf(((DynamicObject)sbbid.get(0)).getLong("id"));
        }
        return "0";
    }

    public static DynamicObjectCollection getNsrxxObjectByMonthOrSeasonal(String orgid, Date lastYearBegin, Date lastYearEnd, Date lastQuarterBegin, Date lastQuarterEnd) {
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter monthFilter = new QFilter("skssqq", "=", (Object)lastYearBegin).and(new QFilter("skssqz", "=", (Object)lastYearEnd));
        QFilter quarterFilter = new QFilter("skssqq", "=", (Object)lastQuarterBegin).and(new QFilter("skssqz", "=", (Object)lastQuarterEnd));
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsjb");
        QFilter declareStatusFilter = new QFilter("declarestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"editing", "declared"}));
        QFilter[] filter = new QFilter[]{orgFilter, monthFilter.or(quarterFilter), typeFilter, declareStatusFilter};
        return QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])filter);
    }

    public static DynamicObject queryBranchObjects(Date skssqq, Date skssqz, String orgid) {
        QFilter taxorgFilter = new QFilter("fzjgmc", "=", (Object)OrgUtils.getOrgNameById((String)orgid));
        String sbbid = SbbQueryService.getSbbidStr(skssqq, skssqz, orgid, "qysdsnb_fzjg");
        QFilter sbbFilter = new QFilter("sbbid", "=", (Object)sbbid);
        return SbbQueryService.queryOne("tccit_qysds_fzjgxx_dyn", "fpbl, fpse", new QFilter[]{sbbFilter, taxorgFilter});
    }

    public static DynamicObject queryZjgObjects(Date skssqq, Date skssqz, String orgid) {
        String sbbid = SbbQueryService.getSbbidStr(skssqq, skssqz, orgid, "qysdsnb_fzjg");
        QFilter sbbFilter = new QFilter("sbbid", "=", (Object)sbbid);
        return SbbQueryService.queryOne("tccit_qysds_zjgxx", "ynsdse", new QFilter[]{sbbFilter});
    }

    public static DynamicObject queryZbObjects(Date skssqq, Date skssqz, String orgid) {
        String sbbid = SbbQueryService.getSbbidStr(skssqq, skssqz, orgid, "qysdsnb_fzjg");
        QFilter sbbFilter = new QFilter("sbbid", "=", (Object)sbbid);
        return SbbQueryService.queryOne("tccit_qysds_zb", "fzjgbqftybtsdse,fsjybsdse", new QFilter[]{sbbFilter});
    }

    public static DynamicObject queryQysdsA109010Fz(Date skssqq, Date skssqz, String orgid) {
        QFilter taxorgFilter = new QFilter("fzjgmc", "=", (Object)OrgUtils.getOrgNameById((String)orgid));
        String orgFuId = OrgUtils.queryOrgGroupDetailForAggregator((String)"qysds", (String)"1", (String)String.valueOf(orgid), (Date)skssqq, (Date)skssqz);
        DynamicObject dynamicObject = null;
        if (StringUtil.isNotBlank((CharSequence)orgFuId)) {
            String sbbid = SbbQueryService.getSbbidStr(skssqq, skssqz, orgFuId, "qysdsnb");
            QFilter sbbFilter = new QFilter("sbbid", "=", (Object)sbbid);
            dynamicObject = SbbQueryService.queryOne("tccit_qysds_a109010_fz", "fzjgnsrsbh, fzjgmc, fzjgsrze, fzjggzze, fzjgzcze, fpbl,fpse", new QFilter[]{sbbFilter, taxorgFilter});
        }
        return dynamicObject;
    }

    public static int deleteDeclareHistoryByCell(String sbbid) {
        QFilter sbbidQFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter cellidQFilter = new QFilter("cellid", "like", (Object)"tccit_qysds_a106000%");
        return DeleteServiceHelper.delete((String)"tctb_declare_his", (QFilter[])new QFilter[]{sbbidQFilter, cellidQFilter});
    }
}

