/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.schedule;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tccit.business.task.SyncDataService;
import org.apache.commons.lang.StringUtils;

public class TaxDiffScheduleTask
extends AbstractTask {
    private static final String KEY_ORGS = "orgs";
    private static final String KEY_DATE = "syncdate";
    private Log logger = LogFactory.getLog(TaxDiffScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Long> orgs;
        this.logger.info("\u5f00\u59cb\u6267\u884c\u8d44\u4ea7\u6298\u65e7\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1");
        SyncDataService service = new SyncDataService();
        if (EmptyCheckUtils.isNotEmpty((Object)map.get(KEY_ORGS))) {
            String orgsStr = (String)map.get(KEY_ORGS);
            orgs = Arrays.stream(orgsStr.split(",")).map(orgid -> Long.parseLong(StringUtils.trim((String)orgid))).collect(Collectors.toList());
        } else {
            QFilter q1 = new QFilter("org.status", "=", (Object)"C").and("enable", "=", (Object)"1");
            Map orgMap = OrgUtils.getAllOrgByViewId((Long)10L, (QFilter)q1);
            orgs = orgMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        Date syncdate = EmptyCheckUtils.isNotEmpty((Object)map.get(KEY_DATE)) ? (Date)map.get(KEY_DATE) : new Date();
        service.syncData(orgs, syncdate);
        this.logger.info("\u7ed3\u675f\u6267\u884c\u8d44\u4ea7\u6298\u65e7\u6570\u636e\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\uff0c\u540c\u6b65\u5c5e\u671f\uff1a{}\uff0c\u540c\u6b65\u7ec4\u7ec7\uff1a{}", (Object)syncdate, orgs);
    }
}

