/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.sync;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class MbksTaxbookSyncHandle {
    private static Log log = LogFactory.getLog(MbksTaxbookSyncHandle.class);

    public void syncData(List<Object> ids) {
        try {
            log.info("\u5f25\u8865\u4e8f\u635f\u53f0\u8d26\u9700\u8981\u540c\u6b65\u7684\u7533\u62a5\u8868ID:{}", ids);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
            DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntityType);
            if (loadResult == null || loadResult.length < 1) {
                log.info("\u5f25\u8865\u4e8f\u635f\u53f0\u8d26\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8fd9\u6279ID\u672a\u67e5\u5230\u7eb3\u7a0e\u7533\u62a5\u6570\u636e");
                return;
            }
            List auditDataList = Arrays.stream(loadResult).filter(e -> "C".equals(e.getString("billstatus"))).collect(Collectors.toList());
            List auditIds = auditDataList.stream().map(e -> e.getString("id")).collect(Collectors.toList());
            Map<Long, List<DynamicObject>> nxxMap = auditDataList.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
            DynamicObjectCollection a106000List = QueryServiceHelper.query((String)"tccit_qysds_a106000", (String)"*", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", auditIds)});
            if (CollectionUtils.isEmpty((Collection)a106000List)) {
                log.info("\u5f25\u8865\u4e8f\u635f\u53f0\u8d26\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u5b58\u5728\u9700\u8981\u540c\u6b65\u7684\u5f25\u8865\u4e8f\u635f\u6570\u636e");
                return;
            }
            Map<Long, List<DynamicObject>> a106000Map = a106000List.stream().collect(Collectors.groupingBy(e -> e.getLong("sbbid")));
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            for (Map.Entry<Long, List<DynamicObject>> entry : a106000Map.entrySet()) {
                this.handleData(nxxMap, entry, saveList, updateList);
            }
            if (CollectionUtils.isNotEmpty(saveList)) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e2) {
            log.error("\u5f25\u8865\u4e8f\u635f\u53f0\u8d26\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0:{}", (Object)e2.getMessage());
        }
    }

    private void handleData(Map<Long, List<DynamicObject>> nxxMap, Map.Entry<Long, List<DynamicObject>> entry, List<DynamicObject> saveList, List<DynamicObject> updateList) {
        Long key = entry.getKey();
        List<DynamicObject> nxxList = nxxMap.get(key);
        if (CollectionUtils.isEmpty(nxxList)) {
            return;
        }
        if (nxxList.size() > 1) {
            return;
        }
        Long orgid = nxxList.get(0).getDynamicObject("org").getLong("id");
        List<DynamicObject> nxxA106000List = entry.getValue();
        List effectiveList = nxxA106000List.stream().filter(e -> BigDecimal.ZERO.compareTo(e.getBigDecimal("qyndynbe")) > 0 && !"11".equals(e.getString("ewblxh"))).collect(Collectors.toList());
        List<Date> ndList = effectiveList.stream().map(e -> DateUtils.stringToDate((String)e.getString("nd"), (String)"yyyy")).collect(Collectors.toList());
        DynamicObject[] taxbookDatas = this.loadTaxbookData(orgid, ndList);
        Optional<DynamicObject> bndRow = nxxA106000List.stream().filter(e -> "11".equals(e.getString("ewblxh"))).findFirst();
        if (!bndRow.isPresent()) {
            return;
        }
        String bndStr = bndRow.get().getString("nd");
        Date thisYear = DateUtils.stringToDate((String)bndStr, (String)"yyyy");
        for (DynamicObject row : effectiveList) {
            this.handleA106000Data(thisYear, taxbookDatas, row, updateList);
        }
        this.handleThisYearRow(bndRow.get(), orgid, saveList, updateList);
    }

    private void handleA106000Data(Date thisYear, DynamicObject[] taxbookDatas, DynamicObject row, List<DynamicObject> updateList) {
        String nd = row.getString("nd");
        Date year = DateUtils.stringToDate((String)nd, (String)"yyyy");
        assert (year != null);
        List<DynamicObject> ndDataList = Arrays.stream(taxbookDatas).filter(e -> e.getDate("happenyear").compareTo(year) == 0).filter(e -> thisYear.compareTo(e.getDate("ksdqnd")) < 0).collect(Collectors.toList());
        if (ndDataList.size() == 1) {
            this.modifyTaxbook((DynamicObject)ndDataList.get(0), row, thisYear);
            updateList.add(ndDataList.get(0));
        }
        if (ndDataList.size() > 1) {
            this.modifyTaxbook(ndDataList, row, thisYear);
            updateList.addAll(ndDataList);
        }
    }

    private void handleThisYearRow(DynamicObject thisYearRow, Long orgid, List<DynamicObject> saveList, List<DynamicObject> updateList) {
        String nd = thisYearRow.getString("nd");
        Date year = DateUtils.stringToDate((String)nd, (String)"yyyy");
        DynamicObject[] taxbookDatas = this.loadTaxbookData(orgid, Collections.singletonList(year));
        if (taxbookDatas.length == 0) {
            this.addTaxbook(thisYearRow, year, orgid, saveList);
        } else {
            this.modifyTaxbook(thisYearRow, year, orgid, taxbookDatas, saveList, updateList);
        }
    }

    private void modifyTaxbook(DynamicObject object, DynamicObject row, Date bndDate) {
        BigDecimal hj = row.getBigDecimal("hj");
        DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
        BigDecimal lossmoney = object.getBigDecimal("lossmoney");
        Optional<DynamicObject> mbnd = entryentity.stream().filter(e -> e.getDate("mbnd").compareTo(bndDate) == 0).findFirst();
        mbnd.ifPresent(arg_0 -> ((DynamicObjectCollection)entryentity).remove(arg_0));
        if (BigDecimal.ZERO.compareTo(hj) < 0) {
            DynamicObject newRow = entryentity.addNew();
            newRow.set("mbnd", (Object)bndDate);
            newRow.set("mbkslx", (Object)"mbks");
            newRow.set("mbzcksje", (Object)hj);
        }
        BigDecimal mbzcksjeSum = entryentity.stream().map(e -> e.getBigDecimal("mbzcksje")).reduce(BigDecimal.ZERO, BigDecimal::add);
        object.set("jydmbje", (Object)lossmoney.add(mbzcksjeSum));
        object.set("ljmbzcksje", (Object)mbzcksjeSum);
    }

    private void modifyTaxbook(List<DynamicObject> ndDataList, DynamicObject row, Date bndDate) {
        List<String> billnos = ndDataList.stream().map(e -> e.getString("billno")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> dgDataMap = this.getDgData(billnos);
        BigDecimal hj = row.getBigDecimal("hj");
        for (DynamicObject object : ndDataList) {
            String billno = object.getString("billno");
            List<DynamicObject> dynamicObjectList = dgDataMap.get(billno);
            if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
            DynamicObject dgData = dynamicObjectList.get(0);
            BigDecimal syjnsdmb = dgData.getBigDecimal("syjnsdmb");
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            BigDecimal lossmoney = object.getBigDecimal("lossmoney");
            if (BigDecimal.ZERO.compareTo(hj) >= 0) {
                Optional<DynamicObject> mbnd = entryentity.stream().filter(e -> e.getDate("mbnd").compareTo(bndDate) == 0).findFirst();
                mbnd.ifPresent(arg_0 -> ((DynamicObjectCollection)entryentity).remove(arg_0));
            }
            if (BigDecimal.ZERO.compareTo(syjnsdmb) < 0 && BigDecimal.ZERO.compareTo(hj) < 0) {
                DynamicObject newRow = entryentity.addNew();
                newRow.set("mbnd", (Object)bndDate);
                newRow.set("mbkslx", (Object)"mbks");
                newRow.set("mbzcksje", (Object)syjnsdmb);
            }
            BigDecimal mbzcksjeSum = entryentity.stream().map(e -> e.getBigDecimal("mbzcksje")).reduce(BigDecimal.ZERO, BigDecimal::add);
            object.set("jydmbje", (Object)lossmoney.add(mbzcksjeSum));
            object.set("ljmbzcksje", (Object)mbzcksjeSum);
        }
    }

    private void modifyTaxbook(DynamicObject thisYearRow, Date thisYear, Long orgid, DynamicObject[] taxbookDatas, List<DynamicObject> saveList, List<DynamicObject> updateList) {
        DynamicObject taxbookData;
        DynamicObjectCollection entryentity;
        BigDecimal knbkssd = thisYearRow.getBigDecimal("knbkssd");
        BigDecimal dnknbks = thisYearRow.getBigDecimal("dnknbks");
        BigDecimal nxbn = thisYearRow.getBigDecimal("nxbn");
        BigDecimal qsndyjbe = thisYearRow.getBigDecimal("qsndyjbe");
        String qsndynbe = thisYearRow.getString("qsndynbe");
        Optional<DynamicObject> jnsdObj = Arrays.stream(taxbookDatas).filter(e -> "jnsd".equals(e.getString("losstype"))).findFirst();
        if (BigDecimal.ZERO.compareTo(knbkssd) > 0) {
            int newYjjznx = this.getYjjznx(thisYear, qsndynbe);
            if (jnsdObj.isPresent()) {
                DynamicObject taxbookData2 = jnsdObj.get();
                DynamicObjectCollection entryentity2 = taxbookData2.getDynamicObjectCollection("entryentity");
                if (entryentity2.size() <= 0) {
                    taxbookData2.set("lossmoney", (Object)knbkssd);
                    taxbookData2.set("jydmbje", (Object)knbkssd);
                    taxbookData2.set("lossqiyetype", (Object)this.getLossCompnayType(qsndynbe));
                    taxbookData2.set("yjjznx", (Object)newYjjznx);
                    taxbookData2.set("ksdqnd", (Object)DateUtils.addYear((Date)thisYear, (int)newYjjznx));
                    updateList.add(taxbookData2);
                }
            } else {
                DynamicObject newAcc = this.getDynamicObject(thisYear, orgid, qsndynbe, "jnsd", knbkssd, newYjjznx);
                saveList.add(newAcc);
            }
        } else if (jnsdObj.isPresent() && (entryentity = (taxbookData = jnsdObj.get()).getDynamicObjectCollection("entryentity")).size() <= 0) {
            DeleteServiceHelper.delete((String)"tccit_mbyqks_acc", (QFilter[])new QFilter[]{new QFilter("id", "=", taxbookData.get("id"))});
        }
        Optional<DynamicObject> dnknbksObj = Arrays.stream(taxbookDatas).filter(e -> "zr".equals(e.getString("losstype"))).filter(e -> 5 == e.getInt("yjjznx")).findFirst();
        this.modifyOrAddTaxbook(thisYear, orgid, saveList, updateList, dnknbks, qsndynbe, dnknbksObj, 5);
        Optional<DynamicObject> nxbnObj = Arrays.stream(taxbookDatas).filter(e -> "zr".equals(e.getString("losstype"))).filter(e -> 8 == e.getInt("yjjznx")).findFirst();
        this.modifyOrAddTaxbook(thisYear, orgid, saveList, updateList, nxbn, qsndynbe, nxbnObj, 8);
        Optional<DynamicObject> qsndyjbeObj = Arrays.stream(taxbookDatas).filter(e -> "zr".equals(e.getString("losstype"))).filter(e -> 10 == e.getInt("yjjznx")).findFirst();
        this.modifyOrAddTaxbook(thisYear, orgid, saveList, updateList, qsndyjbe, qsndynbe, qsndyjbeObj, 10);
    }

    private void modifyOrAddTaxbook(Date thisYear, Long orgid, List<DynamicObject> saveList, List<DynamicObject> updateList, BigDecimal lossmoney, String qsndynbe, Optional<DynamicObject> dnknbksObj, int newYjjznx) {
        DynamicObject taxbookData;
        DynamicObjectCollection entryentity;
        if (BigDecimal.ZERO.compareTo(lossmoney) > 0) {
            if (dnknbksObj.isPresent()) {
                DynamicObject taxbookData2 = dnknbksObj.get();
                DynamicObjectCollection entryentity2 = taxbookData2.getDynamicObjectCollection("entryentity");
                if (entryentity2.size() <= 0) {
                    taxbookData2.set("lossmoney", (Object)lossmoney);
                    taxbookData2.set("jydmbje", (Object)lossmoney);
                    taxbookData2.set("lossqiyetype", (Object)this.getLossCompnayType(qsndynbe));
                    taxbookData2.set("ksdqnd", (Object)DateUtils.addYear((Date)thisYear, (int)newYjjznx));
                    updateList.add(taxbookData2);
                }
            } else {
                DynamicObject newAcc = this.getDynamicObject(thisYear, orgid, qsndynbe, "zr", lossmoney, newYjjznx);
                saveList.add(newAcc);
            }
        } else if (dnknbksObj.isPresent() && (entryentity = (taxbookData = dnknbksObj.get()).getDynamicObjectCollection("entryentity")).size() <= 0) {
            DeleteServiceHelper.delete((String)"tccit_mbyqks_acc", (QFilter[])new QFilter[]{new QFilter("id", "=", taxbookData.get("id"))});
        }
    }

    private void addTaxbook(DynamicObject row, Date thisYear, Long orgid, List<DynamicObject> saveList) {
        BigDecimal knbkssd = row.getBigDecimal("knbkssd");
        BigDecimal dnknbks = row.getBigDecimal("dnknbks");
        BigDecimal nxbn = row.getBigDecimal("nxbn");
        BigDecimal qsndyjbe = row.getBigDecimal("qsndyjbe");
        String qsndynbe = row.getString("qsndynbe");
        if (BigDecimal.ZERO.compareTo(knbkssd) > 0) {
            int newYjjznx = this.getYjjznx(thisYear, qsndynbe);
            DynamicObject newAcc = this.getDynamicObject(thisYear, orgid, qsndynbe, "jnsd", knbkssd, newYjjznx);
            saveList.add(newAcc);
        }
        if (BigDecimal.ZERO.compareTo(dnknbks) > 0) {
            DynamicObject newAcc = this.getDynamicObject(thisYear, orgid, qsndynbe, "zr", dnknbks, 5);
            saveList.add(newAcc);
        }
        if (BigDecimal.ZERO.compareTo(nxbn) > 0) {
            DynamicObject newAcc = this.getDynamicObject(thisYear, orgid, qsndynbe, "zr", nxbn, 8);
            saveList.add(newAcc);
        }
        if (BigDecimal.ZERO.compareTo(qsndyjbe) > 0) {
            DynamicObject newAcc = this.getDynamicObject(thisYear, orgid, qsndynbe, "zr", qsndyjbe, 10);
            saveList.add(newAcc);
        }
    }

    private DynamicObject getDynamicObject(Date thisYear, Long orgid, String qsndynbe, String losstype, BigDecimal lossmoney, int newYjjznx) {
        String billno = DeclareServiceHelper.generateSBBNo((String)"tccit_mbyqks_acc");
        DynamicObject newAcc = BusinessDataServiceHelper.newDynamicObject((String)"tccit_mbyqks_acc");
        newAcc.set("org", (Object)orgid);
        newAcc.set("billno", (Object)billno);
        newAcc.set("billstatus", (Object)"A");
        newAcc.set("happenyear", (Object)thisYear);
        newAcc.set("losstype", (Object)losstype);
        newAcc.set("lossqiyetype", (Object)this.getLossCompnayType(qsndynbe));
        newAcc.set("yjjznx", (Object)newYjjznx);
        newAcc.set("lossmoney", (Object)lossmoney);
        newAcc.set("ksdqnd", (Object)DateUtils.addYear((Date)thisYear, (int)newYjjznx));
        newAcc.set("jydmbje", (Object)lossmoney);
        return newAcc;
    }

    private Long getLossCompnayType(String qsndynbe) {
        DynamicObject qsndynbeObj = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef", (String)"entry_detail.id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"BKQYLX"), new QFilter("entry_detail.subnumber", "=", (Object)qsndynbe)});
        return Objects.nonNull(qsndynbeObj) ? qsndynbeObj.getLong("entry_detail.id") : 0L;
    }

    private DynamicObject[] loadTaxbookData(Long orgid, List<Date> ndDateList) {
        return BusinessDataServiceHelper.load((String)"tccit_mbyqks_acc", (String)"id,billno,lossqiyetype,ksdqnd,ljmbzcksje,org,happenyear,losstype,yjjznx,lossmoney,jydmbje,entryentity,entryentity.mbnd,entryentity.mbkslx,entryentity.mbzcksje", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("happenyear", "in", ndDateList)});
    }

    private int getYjjznx(Date ndDate, String lossqiyetype) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"ttc_valuerules", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CIT-KSJZ01")});
        DynamicObjectCollection valuerules_entry = object.getDynamicObjectCollection("valuerules_entry");
        List number = valuerules_entry.stream().filter(e -> e.getString("basicdatanumber").equals(lossqiyetype)).map(e -> e.getString("targetnumber")).collect(Collectors.toList());
        DynamicObject yjjznx = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1 as value", (QFilter[])new QFilter[]{new QFilter("number", "in", number), new QFilter("entryentity.startdate", "<=", (Object)ndDate), new QFilter("entryentity.enddate", ">=", (Object)ndDate).or("entryentity.enddate", "is null", null)});
        return yjjznx == null ? 0 : Integer.parseInt(yjjznx.getString("value"));
    }

    private Map<String, List<DynamicObject>> getDgData(List<String> billnos) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_dg_b105060_sum", (String)"billno,syjnsdmb,flzcje", (QFilter[])new QFilter[]{new QFilter("billno", "in", billnos)});
        return query.stream().collect(Collectors.groupingBy(e -> e.getString("billno")));
    }
}

