/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;

public class CaculateRulesTask
extends Task<List<DynamicObject>> {
    private DynamicObjectCollection list;
    private DynamicObject org;
    private boolean showdisable;

    public CaculateRulesTask(DynamicObjectCollection list, DynamicObject org, boolean showdisable) {
        this.list = list;
        this.org = org;
        this.showdisable = showdisable;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.list, (int)40);
    }

    public List<DynamicObject> executor(List<DynamicObject> ex) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ex.size());
        for (DynamicObject entry : ex) {
            String Id = entry.getString("id");
            String name = entry.getString("projname");
            String parentid = entry.getString("parentid");
            List<Long> childList = this.getChildList(Id);
            int currentunm = CaculateRulesTask.getrules(childList, this.org, this.showdisable).size();
            String num = String.valueOf(currentunm);
            entry.set("id", (Object)Id);
            entry.set("projname", (Object)name);
            entry.set("parentid", (Object)parentid);
            entry.set("rulesnum", (Object)num);
            list.add(entry);
        }
        return list;
    }

    private List<Long> getChildList(String id) {
        Long currentid = Long.parseLong(id);
        ArrayList<Long> list = new ArrayList<Long>();
        QFilter qFilter = new QFilter("entryid", "=", (Object)currentid);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"tccit_rule_nbchild", (String)"childid", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dyo : dyos) {
            long childid = dyo.getLong("childid");
            list.add(childid);
        }
        return list;
    }

    private static DynamicObjectCollection getrules(List<Long> number, DynamicObject org, boolean showdisable) {
        DynamicObjectCollection rules = new DynamicObjectCollection();
        if (null != org) {
            ArrayList yearlist = Lists.newArrayList((Object[])new String[]{"remincome", "remperiod", "remajust", "srajust", "zcajust", "dsale", "other", "ssyh", "tssx"});
            ArrayList<Long> ruleids = new ArrayList<Long>();
            ArrayList sbxPlanQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", org.get("id")).and(new QFilter("ruleentity.type", "in", (Object)yearlist))});
            DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tccit_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid,ruleentity.type as type", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
            for (DynamicObject sharingRule : sharingRules) {
                Long ruleid = sharingRule.getLong("ruleid");
                ruleids.add(ruleid);
            }
            for (Long id : number) {
                DynamicObjectCollection rule;
                QFilter qFilter3 = new QFilter("org", "=", org.get("id"));
                QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                QFilter qFilter5 = new QFilter("item", "=", (Object)id);
                QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                QFilter qFilter7 = new QFilter("id", "in", ruleids);
                if (showdisable) {
                    QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7).and(qFilter5)};
                    rule = QueryServiceHelper.query((String)"tccit_year_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])allfilter);
                    rules.addAll((Collection)rule);
                    continue;
                }
                QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7).and(qFilter5).and(qFilter6)};
                rule = QueryServiceHelper.query((String)"tccit_year_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])enalbefilter);
                rules.addAll((Collection)rule);
            }
        }
        return rules;
    }
}

