/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class CombineService {
    private static final String SOURCE_SYSTEM = "system";
    private static final Map<String, String> keyMapping1 = new HashMap<String, String>(){
        {
            this.put("kjyjjcz", "residualvalue");
            this.put("zjtxmethod", "amortizationmethod");
            this.put("kjzjtxqs", "amortizationperiods");
            this.put("kjdqzjtxw", "currentamount");
            this.put("kjbnzjtxe", "yearamount");
            this.put("kjljzjtxe", "cumulativeamount");
        }
    };
    private static final Map<String, String> keyMapping2 = new HashMap<String, String>(){
        {
            this.put("swzclb", "taxassetstype");
            this.put("acceleratedepretype", "acceleratedepretype");
            this.put("calctaxbase", "calctaxbase");
            this.put("swyjjcz", "taxresidualvalue");
            this.put("swjszjtxff", "taxactualmethod");
            this.put("swjszjtxqs", "integerfield");
            this.put("swjsdqzjtxe", "taxcurrentamount");
            this.put("swjsbnzjtxe", "taxyearamount");
            this.put("swjsljzjtxe", "taxcumulativeamount");
        }
    };
    private static final Map<String, String> keyMapping3 = new HashMap<String, String>(){
        {
            this.put("swybzjtxff", "taxamortizationmethod");
            this.put("swybzjtxqs", "taxamortizationperiods");
            this.put("swybdqzjtxe", "taxcurrentamount");
            this.put("swybbnzjtxe", "taxyearamount");
            this.put("swybljzjtxe", "taxcumulativeamount");
        }
    };

    public static List<Map<String, Object>> combine(Date accountingperiod, DynamicObjectCollection collection, DynamicObjectCollection collection1, DynamicObjectCollection collection2, DynamicObjectCollection collection3) {
        Map<String, DynamicObject> sourceMap1 = CombineService.collectionGroupBy(collection1);
        Map<String, DynamicObject> sourceMap2 = CombineService.collectionGroupBy(collection2);
        Map<String, DynamicObject> sourceMap3 = CombineService.collectionGroupBy(collection3);
        HashSet keySet = Sets.newHashSet();
        keySet.addAll(sourceMap1.keySet());
        keySet.addAll(sourceMap2.keySet());
        keySet.addAll(sourceMap3.keySet());
        Map assetMap = collection.parallelStream().collect(Collectors.toMap(s -> s.getString("taxorg") + "_" + s.getString("assetcode"), Function.identity(), (o1, o2) -> o1.getDate("startdate").compareTo(o2.getDate("startdate")) > 0 ? o1 : o2));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(32);
        for (String key : keySet) {
            Map<String, Object> targetMap = null;
            targetMap = CombineService.initMap(accountingperiod, key, keyMapping1, sourceMap1, targetMap);
            targetMap = CombineService.initMap(accountingperiod, key, keyMapping2, sourceMap2, targetMap);
            if ((targetMap = CombineService.initMap(accountingperiod, key, keyMapping3, sourceMap3, targetMap)) == null) continue;
            targetMap.put("nstz", BigDecimalUtil.subtractObject((Object)targetMap.get("kjbnzjtxe"), (Object)targetMap.get("swjsbnzjtxe")));
            targetMap.put("bnjszjyswzjcy", BigDecimalUtil.subtractObject((Object)targetMap.get("swjsbnzjtxe"), (Object)targetMap.get("swybbnzjtxe")));
            targetMap.put("dqjszjyswzjcy", BigDecimalUtil.subtractObject((Object)targetMap.get("swjsdqzjtxe"), (Object)targetMap.get("swybdqzjtxe")));
            targetMap.put("source", SOURCE_SYSTEM);
            DynamicObject asset = (DynamicObject)assetMap.get(key);
            if (EmptyCheckUtils.isNotEmpty((Object)asset)) {
                HashMap<String, Object> assetdata = new HashMap<String, Object>();
                assetdata.put("importprop", "id");
                assetdata.put("id", asset.getLong("id"));
                targetMap.put("assetdata", assetdata);
                targetMap.put("zctype", asset.get("assetclass"));
                targetMap.put("postingdate", asset.get("startdate"));
                targetMap.put("assetsvalue", asset.get("assetsvalue"));
                targetMap.put("assetuse", asset.get("assetuse"));
                targetMap.put("rdaddition", asset.get("rdaddition"));
                targetMap.put("assetstatus", asset.get("assetstatus"));
                targetMap.put("cleaningdate", asset.get("cleaningdate"));
                targetMap.put("initval", asset.get("initval"));
            }
            list.add(targetMap);
        }
        return list;
    }

    private static Map<String, Object> initMap(Date accountingperiod, String key, Map<String, String> keyMapping, Map<String, DynamicObject> sourceMap, Map<String, Object> targetMap) {
        DynamicObject sourceObject = sourceMap.get(key);
        if (sourceObject == null) {
            return targetMap;
        }
        if (targetMap == null) {
            targetMap = new HashMap<String, Object>(16);
            HashMap<String, Object> orgMap = new HashMap<String, Object>();
            orgMap.put("importprop", "id");
            orgMap.put("id", sourceObject.get("org"));
            targetMap.put("org", orgMap);
            targetMap.put("assetsnumber", sourceObject.get("assetcode"));
            targetMap.put("assetsname", sourceObject.get("assetname"));
            targetMap.put("accountingperiod", accountingperiod);
            targetMap.put("rdaddition", "0");
        }
        for (Map.Entry<String, String> entry : keyMapping.entrySet()) {
            boolean dateRange;
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)accountingperiod);
            boolean bl = dateRange = accountingperiod.compareTo(sourceObject.getDate("accountingperiod")) <= 0 && lastDateOfMonth.compareTo(sourceObject.getDate("accountingperiod")) >= 0;
            if (Lists.newArrayList((Object[])new String[]{"kjdqzjtxw", "swjsdqzjtxe", "swybdqzjtxe"}).contains(entry.getKey()) && !dateRange) {
                targetMap.put(entry.getKey(), 0L);
                continue;
            }
            if (Lists.newArrayList((Object[])new String[]{"swjsbnzjtxe", "kjbnzjtxe", "swybbnzjtxe"}).contains(entry.getKey()) && DateUtils.getYearOfDate((Date)accountingperiod) != DateUtils.getYearOfDate((Date)sourceObject.getDate("accountingperiod"))) {
                targetMap.put(entry.getKey(), 0L);
                continue;
            }
            targetMap.put(entry.getKey(), sourceObject.get(entry.getValue()));
        }
        return targetMap;
    }

    private static Map<String, DynamicObject> collectionGroupBy(DynamicObjectCollection collection) {
        return collection.parallelStream().collect(Collectors.toMap(s -> s.getString("org") + "_" + s.getString("assetcode"), Function.identity(), (o1, o2) -> o1.getDate("accountingperiod").compareTo(o2.getDate("accountingperiod")) > 0 ? o1 : o2));
    }
}

