/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class SaveDataTask
extends Task<List<Map<String, Object>>> {
    private static final String ENTITY_DIFF = "tccit_tax_acce_diff";
    private static final int BATCH_SAVE_SIZE = 500;
    private List<Map<String, Object>> data;

    public SaveDataTask(List<Map<String, Object>> data) {
        this.data = data;
    }

    public List<List<Map<String, Object>>> getValue() {
        return Lists.partition(this.data, (int)500);
    }

    public List<Map<String, Object>> executor(List<Map<String, Object>> data) {
        HashMap<String, Set<Object>> params = new HashMap<String, Set<Object>>(16);
        params.put("org.id", data.stream().map(s -> ((Map)s.get("org")).get("id")).collect(Collectors.toSet()));
        params.put("assetsnumber", data.stream().map(s -> s.get("assetsnumber")).collect(Collectors.toSet()));
        params.put("accountingperiod", data.stream().map(s -> s.get("accountingperiod")).collect(Collectors.toSet()));
        Object[] ids = QueryServiceHelper.query((String)ENTITY_DIFF, (String)"id", (QFilter[])new QFilter[]{this.buildKeyFilters(params)}).stream().map(s -> s.getLong("id")).toArray();
        DynamicObject[] existsIds = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY_DIFF));
        Map<String, DynamicObject> idMaps = Arrays.stream(existsIds).collect(Collectors.toMap(s -> this.formatKey(s.getDynamicObject("org").getString("id"), s.getString("assetsnumber"), DateUtils.format((Date)s.getDate("accountingperiod"))), s -> s));
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>();
        for (Map<String, Object> d : data) {
            this.convertToObj(d, idMaps, saves, updates);
        }
        if (saves.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        }
        if (updates.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
        return data;
    }

    public void convertToObj(Map<String, Object> row, Map<String, DynamicObject> idMaps, List<DynamicObject> saves, List<DynamicObject> updates) {
        String format = this.formatKey(((Map)row.get("org")).get("id"), (String)row.get("assetsnumber"), DateUtils.format((Date)((Date)row.get("accountingperiod"))));
        DynamicObject object = idMaps.get(format);
        if (object != null) {
            updates.add(this.getDynamicObject(row, object));
        } else {
            object = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_DIFF);
            saves.add(this.getDynamicObject(row, object));
        }
    }

    public DynamicObject getDynamicObject(Map<String, Object> row, DynamicObject object) {
        DataEntityPropertyCollection properties = object.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property.getName().equals("id")) continue;
            if (property.getName().equals("org") || property.getName().equals("org_id")) {
                object.set(property.getName(), Optional.ofNullable((Map)row.get("org")).map(s -> s.get("id")).orElseGet(() -> 0L));
                continue;
            }
            if (property.getName().equals("assetdata") || property.getName().equals("assetdata_id")) {
                object.set(property.getName(), Optional.ofNullable((Map)row.get("assetdata")).map(s -> s.get("id")).orElseGet(() -> 0L));
                continue;
            }
            if ("cleaningdate".equals(property.getName()) || "assetstatus".equals(property.getName())) {
                if (row.get("cleaningdate") != null && "clean".equals(String.valueOf(row.get("assetstatus")))) {
                    Date accountingperiod = (Date)row.get("accountingperiod");
                    Date cleaningdate = (Date)row.get("cleaningdate");
                    Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)cleaningdate);
                    if (firstDateOfMonth.compareTo(accountingperiod) > 0) {
                        object.set("assetstatus", (Object)"on");
                        continue;
                    }
                    object.set(property.getName(), row.get(property.getName()));
                    continue;
                }
                object.set(property.getName(), row.get(property.getName()));
                continue;
            }
            object.set(property.getName(), row.get(property.getName()));
        }
        return object;
    }

    private String formatKey(Object id, String assetsnumber, String accountingperiod) {
        return String.format("%s_%s_%s", id, assetsnumber, accountingperiod);
    }

    private QFilter buildKeyFilters(Map<String, Set<Object>> params) {
        QFilter filter = null;
        for (Map.Entry<String, Set<Object>> entry : params.entrySet()) {
            String fieldKey = entry.getKey();
            Set<Object> value = entry.getValue();
            if (filter == null) {
                filter = new QFilter(fieldKey, "in", value);
                continue;
            }
            filter.and(fieldKey, "in", value);
        }
        return filter;
    }
}

