/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.task;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tccit.business.task.CombineService;
import kd.taxc.tccit.business.task.SaveDataTask;
import org.apache.commons.collections.CollectionUtils;

public class SyncDataTask
extends Task<List<Long>> {
    private Log logger = LogFactory.getLog(SyncDataTask.class);
    private static final String ENTITY_ACCOUNT = "tdm_account_depreciation";
    private static final String ENTITY_ACTUAL = "tdm_actual_depreciation";
    private static final String ENTITY_TAX = "tdm_tax_depreciation";
    private static final int BATCH_ORG_SIZE = 1;
    private List<Long> orgList;
    private Date startDate;
    private Date endDate;

    public SyncDataTask(List<Long> orgList, Date startDate, Date endDate) {
        this.orgList = orgList;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public List<List<Long>> getValue() {
        return Lists.partition(this.orgList, (int)1);
    }

    public List<Long> executor(List<Long> orgids) {
        for (Long orgid : orgids) {
            this.syncData(orgid);
        }
        return orgids;
    }

    private void syncData(Long orgid) {
        long start = System.currentTimeMillis();
        DynamicObjectCollection collection = this.queryAssetData(orgid, this.endDate);
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        List<String> assetcodeList = collection.stream().map(e -> e.getString("assetcode")).collect(Collectors.toList());
        DynamicObjectCollection collection1 = this.queryData(orgid, ENTITY_ACCOUNT, assetcodeList);
        DynamicObjectCollection collection2 = this.queryData(orgid, ENTITY_ACTUAL, assetcodeList);
        DynamicObjectCollection collection3 = this.queryData(orgid, ENTITY_TAX, assetcodeList);
        Date accountingperiod = DateUtils.getFirstDateOfMonth((Date)this.endDate);
        List<Map<String, Object>> bills = CombineService.combine(accountingperiod, collection, collection1, collection2, collection3);
        ThreadPoolsService.getInstance().submit((Task)new SaveDataTask(bills));
    }

    private DynamicObjectCollection queryAssetData(Long orgid, Date endDate) {
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)endDate);
        QFilter q1 = new QFilter("taxorg", "=", (Object)orgid);
        QFilter q2 = new QFilter("startdate", "<=", (Object)endDate);
        QFilter q3 = new QFilter("enable", "=", (Object)"1");
        QFilter q4 = new QFilter("assetstatus", "in", Arrays.asList("on", "stop")).or(new QFilter("assetstatus", "=", (Object)"clean").and(new QFilter("cleaningdate", ">=", (Object)firstDateOfYear)));
        return QueryServiceHelper.query((String)"tdm_asset_data", (String)"id,taxorg,assetcode,assetclass,startdate,assetsvalue,assetuse,rdaddition,assetstatus,cleaningdate,initval", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    private DynamicObjectCollection queryData(Long orgid, String entity, List<String> assetcodeList) {
        QFilter q1 = new QFilter("org", "=", (Object)orgid);
        QFilter q2 = new QFilter("accountingperiod", "<=", (Object)DateUtils.getDayLast((Date)this.endDate));
        QFilter q3 = new QFilter("assetcode", "in", assetcodeList);
        return QueryServiceHelper.query((String)entity, (String)MetadataUtil.getAllFieldToQuery((String)entity), (QFilter[])new QFilter[]{q1, q2, q3});
    }
}

