/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.formplugin.taxbook.engine.BranchShareEngine;

public class BranchShareDialogService {
    private static final BranchShareEngine engine = new BranchShareEngine();
    private final List<String> fieldNameList = Arrays.asList("income", "salary", "asset");

    public void save(Date period, DynamicObjectCollection entryentity) {
        try (TXHandle handle = TX.required();){
            try {
                this.doSave(period, entryentity);
            }
            catch (Throwable throwable) {
                handle.markRollback();
                throw throwable;
            }
        }
    }

    public void doSave(Date period, DynamicObjectCollection entryentity) {
        Date year = DateUtils.addYear((Date)period, (int)-1);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)year);
        String skssqq = DateUtils.format((Date)firstDateOfYear);
        String skssqz = DateUtils.format((Date)lastDateOfYear);
        ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(entryentity.size());
        String date = DateUtils.formatHMS((Date)new Date());
        RequestContext context = RequestContext.get();
        for (DynamicObject dyo : entryentity) {
            long billid = dyo.getLong("billid");
            String orgid = dyo.getString("org.id");
            List<Object> sonOrgids = new ArrayList<Long>();
            DynamicObject orgGroupLatest = BusinessDataServiceHelper.loadSingle((Object)dyo.getLong("sumschemeid"), (String)"tctb_org_group_latest");
            DynamicObjectCollection orgrow = orgGroupLatest.getDynamicObjectCollection("orgrow");
            List<Long> rowOrgIds = orgrow.stream().map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
            List<Long> enableOrgIds = BranchTaxbookBusinessService.filterEnableOrg(rowOrgIds, DateUtils.addYear((Date)firstDateOfYear, (int)1));
            List enableOrg = orgrow.stream().filter(e -> enableOrgIds.contains(e.getLong("orgid.id"))).collect(Collectors.toList());
            Boolean isIndependentOrg = Objects.equals("0", dyo.getString("hbfnszt")) && "true".equals(dyo.getString("shareid"));
            String declaration = dyo.getString("declaration");
            Boolean isHeadOrg = "2".equals(declaration);
            if (isIndependentOrg.booleanValue()) {
                List<Long> independentAndSubOrg = this.getIndependentAndSubOrg(dyo.getLong("sumschemeid"), firstDateOfYear);
                sonOrgids.addAll(independentAndSubOrg);
            } else {
                if ("3".equals(declaration)) {
                    sonOrgids = enableOrg.stream().filter(o -> o.getLong("parentid.id") == dyo.getLong("org.id")).map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
                } else if (isHeadOrg.booleanValue()) {
                    List secondLevelOrg = enableOrg.stream().filter(o -> Boolean.FALSE.equals(o.getBoolean("shareid")) && o.getLong("parentid.id") == dyo.getLong("org.id")).map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
                    List list = enableOrg.stream().filter(o -> secondLevelOrg.contains(o.getLong("parentid.id"))).map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
                    sonOrgids.addAll(secondLevelOrg);
                    sonOrgids.addAll(list);
                }
                sonOrgids.add(Long.parseLong(orgid));
            }
            if (sonOrgids.size() > 0) {
                EngineModel engineModel = new EngineModel(orgid, skssqq, skssqz);
                engineModel.getCustom().put("taxorgids", sonOrgids);
                engineModel.getCustom().put("isIndependentOrg", isIndependentOrg);
                engineModel.getCustom().put("isHeadOrg", isHeadOrg);
                engine.deleteData(engineModel);
            }
            for (Long l : sonOrgids) {
                EngineModel engineModel = new EngineModel(isIndependentOrg != false || isHeadOrg != false ? l.toString() : orgid, skssqq, skssqz);
                engineModel.getCustom().put("taxorgid", l);
                engine.runEngine(engineModel);
            }
            QFilter taxorgFilter = new QFilter("taxorg", "in", sonOrgids);
            QFilter qFilter = new QFilter("skssqq", "=", (Object)firstDateOfYear);
            QFilter endFilter = new QFilter("skssqz", "=", (Object)lastDateOfYear);
            QFilter itemnumberFilter = new QFilter("itemnumber", "in", BranchShareEngine.ITEMNUMBERLIST);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"tccit_branch_share_bill");
            for (String fieldName : this.fieldNameList) {
                QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)fieldName);
                QFilter[] filters = new QFilter[]{taxorgFilter, qFilter, endFilter, entrytypeFilter, itemnumberFilter};
                DynamicObject[] deductTzDetails = BusinessDataServiceHelper.load((String)"tccit_branch_share_detail", (String)"amount,fetchamount", (QFilter[])filters);
                BigDecimal amount = Arrays.stream(deductTzDetails).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                amount = amount.setScale(2, 4);
                obj.set(fieldName, (Object)amount);
            }
            obj.set("datastatus", (Object)"1");
            obj.set("datasource", (Object)"1");
            obj.set("operator", (Object)context.getUserName());
            obj.set("operatetime", (Object)date);
            saveObjects.add(obj);
        }
        if (saveObjects.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])saveObjects.toArray(new DynamicObject[0]));
        }
    }

    public List<Long> getIndependentAndSubOrg(Object schemaId, Date firstDateOfYear) {
        if (schemaId == null) {
            return new ArrayList<Long>(0);
        }
        DynamicObject orgGroupLatest = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"tctb_org_group_latest");
        DynamicObjectCollection orgrow = orgGroupLatest.getDynamicObjectCollection("orgrow");
        List<Long> rowOrgIds = orgrow.stream().map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
        List<Long> enableOrgIds = BranchTaxbookBusinessService.filterEnableOrg(rowOrgIds, DateUtils.addYear((Date)firstDateOfYear, (int)1));
        List enableOrg = orgrow.stream().filter(e -> enableOrgIds.contains(e.getLong("orgid.id"))).collect(Collectors.toList());
        List collecnt = enableOrg.stream().filter(a -> "2".equals(a.getString("levelname")) && Boolean.TRUE.equals(a.getBoolean("shareid"))).map(s -> s.get("orgid.id")).collect(Collectors.toList());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", collecnt), new QFilter("istaxpayer", "=", (Object)"0")});
        List<Long> secondNoTaxpayerOrg = query.stream().map(s -> s.getLong("org.id")).collect(Collectors.toList());
        List thirdLevelOrg = enableOrg.stream().filter(o -> secondNoTaxpayerOrg.contains(o.getLong("parentid.id"))).map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
        secondNoTaxpayerOrg.addAll(thirdLevelOrg);
        return secondNoTaxpayerOrg;
    }

    public List<Long> getZjgFtzzList(Object schemaId, Date firstDateOfYear) {
        if (schemaId == null) {
            return new ArrayList<Long>(0);
        }
        DynamicObject orgGroupLatest = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"tctb_org_group_latest");
        DynamicObjectCollection orgrow = orgGroupLatest.getDynamicObjectCollection("orgrow");
        List<Long> rowOrgIds = orgrow.stream().map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
        List<Long> enableOrgIds = BranchTaxbookBusinessService.filterEnableOrg(rowOrgIds, DateUtils.addYear((Date)firstDateOfYear, (int)1));
        List enableOrg = orgrow.stream().filter(e -> enableOrgIds.contains(e.getLong("orgid.id"))).collect(Collectors.toList());
        Optional<Long> first = enableOrg.stream().filter(a -> "2".equals(a.getString("declaration")) && "1".equals(a.getString("levelname"))).map(s -> s.getLong("orgid.id")).findFirst();
        if (!first.isPresent()) {
            return new ArrayList<Long>(0);
        }
        Long head = first.get();
        List<Long> secondLevelOrg = enableOrg.stream().filter(o -> Boolean.FALSE.equals(o.getBoolean("shareid")) && head.equals(o.getLong("parentid.id"))).map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
        List thirdLevelOrg = enableOrg.stream().filter(o -> secondLevelOrg.contains(o.getLong("parentid.id"))).map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
        secondLevelOrg.addAll(thirdLevelOrg);
        secondLevelOrg.add(head);
        return secondLevelOrg;
    }
}

