/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orggroup.TaxcOrgGroupDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class BranchShareServiceHelper {
    private static final String TCCIT_BRANCH_SHARE = "tccit_branch_share";
    private static final String PERIOD = "period";
    private static final String ROOT_NODE_ID = "0";

    public static void addDataCollectLog(List<DynamicObject> showBillList) {
        for (DynamicObject object : showBillList) {
            String opName = BranchShareServiceHelper.getDataCollectOpName();
            String opDescription = BranchShareServiceHelper.getDataCollectOpDescription();
            OperatorDialogUtils.operateDialog((String)"qysds", (String)TCCIT_BRANCH_SHARE, (String)opName, (String)opDescription, (Long)object.getLong("org.id"));
        }
    }

    public static void addViewSumSchemeLog(String currentNode) {
        DynamicObject orgGroup;
        DynamicObjectCollection orgrow;
        Optional<Long> optional;
        TaxResult result = TaxcOrgGroupDataServiceHelper.queryOrgGroupByIds(Collections.singletonList(Long.parseLong(currentNode)), (String)"2");
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && (optional = (orgrow = (orgGroup = (DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("orgrow")).stream().filter(d -> "2".equals(d.getString("declaration"))).map(d -> d.getLong("orgid.id")).findFirst()).isPresent()) {
            String opName = BranchShareServiceHelper.getViewSumSchemeOpName();
            String opDescription = BranchShareServiceHelper.getViewSumSchemeOpDescription(orgGroup);
            OperatorDialogUtils.operateDialog((String)"qysds", (String)TCCIT_BRANCH_SHARE, (String)opName, (String)opDescription, (Long)optional.get());
        }
    }

    private static void addCalcShareLog(Long orgId, String orgGroupName) {
        String opName = BranchShareServiceHelper.getCalcShareOpName();
        String opDescription = BranchShareServiceHelper.getCalcShareOpDescription(orgGroupName);
        OperatorDialogUtils.operateDialog((String)"qysds", (String)TCCIT_BRANCH_SHARE, (String)opName, (String)opDescription, (Long)orgId);
    }

    private static String getDataCollectOpName() {
        return ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6", (String)"BranchShareServiceHelper_0", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    private static String getDataCollectOpDescription() {
        return ResManager.loadKDString((String)"\u6253\u5f00\u6570\u636e\u91c7\u96c6\u5f39\u7a97", (String)"BranchShareServiceHelper_1", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    private static String getViewSumSchemeOpName() {
        return ResManager.loadKDString((String)"\u67e5\u770b\u6c47\u603b\u65b9\u6848", (String)"BranchShareServiceHelper_2", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    private static String getViewSumSchemeOpDescription(DynamicObject orgGroup) {
        return String.format(ResManager.loadKDString((String)"\u67e5\u770b\u3010%s\u3011\u6c47\u603b\u65b9\u6848", (String)"BranchShareServiceHelper_3", (String)"taxc-tccit", (Object[])new Object[0]), orgGroup.getString("name"));
    }

    private static String getCalcShareOpName() {
        return ResManager.loadKDString((String)"\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b", (String)"BranchShareServiceHelper_4", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    private static String getCalcShareOpDescription(String orgGroupName) {
        return String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u3010%s\u3011\u6c47\u603b\u65b9\u6848\u7684\u5206\u914d\u6bd4\u4f8b", (String)"BranchShareServiceHelper_5", (String)"taxc-tccit", (Object[])new Object[0]), orgGroupName);
    }

    public static void doCalcShare(IFormView view, String nodeId, Date period) {
        Date lastDateOfYear;
        QFilter orgFilter;
        if (EmptyCheckUtils.isEmpty((Object)nodeId) || ROOT_NODE_ID.equals(nodeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\u7684\u5177\u4f53\u6c47\u603b\u65b9\u6848", (String)"BranchSharePlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        TaxResult result = TaxcOrgGroupDataServiceHelper.queryOrgGroupByIds(Collections.singletonList(Long.parseLong(nodeId)), (String)"2");
        if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return;
        }
        DynamicObject orgGroup = (DynamicObject)((List)result.getData()).get(0);
        DynamicObjectCollection orgrows = orgGroup.getDynamicObjectCollection("orgrow");
        Optional<Long> optional = orgrows.stream().filter(d -> "2".equals(d.getString("declaration"))).map(d -> d.getLong("orgid.id")).findFirst();
        Long hzOrgId = 0L;
        if (optional.isPresent()) {
            hzOrgId = optional.get();
        }
        if (OrgCheckUtil.orgAuth((String)String.valueOf(hzOrgId), (IFormView)view, null, (boolean)false)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\u6743\u9650\uff0c\u65e0\u6cd5\u5b8c\u6210\u8ba1\u7b97", (String)"BranchSharePlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        if (OrgCheckUtil.orgEnable((IFormView)view, (Long)hzOrgId, (boolean)true)) {
            return;
        }
        boolean participation = orgGroup.getBoolean("participation");
        ArrayList<Long> orgIdList = new ArrayList<Long>(orgrows.size());
        ArrayList<Long> updateOrgList = new ArrayList<Long>(orgrows.size());
        for (DynamicObject orgrow : orgrows) {
            long orgId = orgrow.getLong("orgid.id");
            String dc = orgrow.getString("declaration");
            String shareid = orgrow.getString("shareid");
            if (!"3".equals(dc) && !participation) continue;
            if ("true".equals(shareid)) {
                orgIdList.add(orgId);
                continue;
            }
            updateOrgList.add(orgId);
        }
        QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
        if (orgIdList.size() > 0) {
            orgFilter = new QFilter("org", "in", orgIdList).or(new QFilter("org", "=", (Object)hzOrgId).and(new QFilter("hbfnszt", "=", (Object)ROOT_NODE_ID)));
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
            lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
            QFilter groupFilter = new QFilter("sumscheme", "=", (Object)Long.parseLong(nodeId));
            QFilter periodFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tccit_branch_share_bill", (String)"id,org,income,salary,asset,sharerate,initsharerate,operator,operatetime", (QFilter[])new QFilter[]{orgFilter, periodFilter, usableFilter, groupFilter}, (String)"id");
            BranchShareServiceHelper.updateEntry(dynamicObjects, period, view);
        }
        if (updateOrgList.size() > 0) {
            orgFilter = new QFilter("org", "in", updateOrgList);
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
            lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
            QFilter periodFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tccit_branch_share_bill", (String)"id,sharerate,initsharerate", (QFilter[])new QFilter[]{orgFilter, periodFilter, usableFilter});
            Arrays.stream(dynamicObjects).forEach(bill -> {
                bill.set("sharerate", null);
                bill.set("initsharerate", null);
            });
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
        BranchShareServiceHelper.addCalcShareLog(hzOrgId, orgGroup.getString("name"));
    }

    private static BigDecimal getCalcRate(BigDecimal amount, BigDecimal total, BigDecimal rate, BigDecimal hundred) {
        if (total == null || total.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount.multiply(rate).divide(total.multiply(hundred), 15, 4);
    }

    private static void updateEntry(DynamicObject[] entryentity, Date period, IFormView view) {
        String sharerateStr;
        BigDecimal totalIncome = Arrays.stream(entryentity).map(e -> e.getBigDecimal("income")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal totalSalary = Arrays.stream(entryentity).map(e -> e.getBigDecimal("salary")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal totalAsset = Arrays.stream(entryentity).map(e -> e.getBigDecimal("asset")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal totalRate = BigDecimal.ZERO;
        DynamicObject maxRateDyo = null;
        String date = DateUtils.formatHMS((Date)new Date());
        for (DynamicObject bill : entryentity) {
            String orgId = bill.getString("org");
            BigDecimal income = bill.getBigDecimal("income");
            BigDecimal salary = bill.getBigDecimal("salary");
            BigDecimal asset = bill.getBigDecimal("asset");
            BigDecimal rateA = BranchShareServiceHelper.getRate(period, "FZJGYYSR", orgId);
            BigDecimal rateB = BranchShareServiceHelper.getRate(period, "FZJGZGXC", orgId);
            BigDecimal rateC = BranchShareServiceHelper.getRate(period, "FZJGZCZE", orgId);
            BigDecimal a = BranchShareServiceHelper.getCalcRate(income, totalIncome, rateA, hundred);
            BigDecimal b = BranchShareServiceHelper.getCalcRate(salary, totalSalary, rateB, hundred);
            BigDecimal c = BranchShareServiceHelper.getCalcRate(asset, totalAsset, rateC, hundred);
            BigDecimal rate = a.add(b).add(c).setScale(10, RoundingMode.HALF_UP);
            if (BigDecimal.ZERO.compareTo(rate) > 0 || BigDecimal.ONE.compareTo(rate) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff08\u7a0e\u52a1\u7ec4\u7ec7\uff09\u5f53\u524d\u5206\u914d\u6bd4\u4f8b\u8d85\u51fa\u6570\u503c\u8303\u56f4[0,1]\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u5206\u914d\u6bd4\u4f8b\u660e\u7ec6\u6570\u636e\u3002", (String)"BranchShareServiceHelper_6", (String)"taxc-tccit", (Object[])new Object[0]), bill.getString("org.name")));
            }
            if (maxRateDyo == null) {
                maxRateDyo = bill;
            } else {
                String sharerate = maxRateDyo.getString("sharerate");
                if (StringUtils.isNotBlank((CharSequence)sharerate) && rate.compareTo(new BigDecimal(sharerate)) > 0) {
                    maxRateDyo = bill;
                }
            }
            totalRate = totalRate.add(rate);
            RequestContext context = RequestContext.get();
            bill.set("sharerate", (Object)rate.toPlainString());
            bill.set("initsharerate", (Object)rate.toPlainString());
            bill.set("operator", (Object)context.getUserName());
            bill.set("operatetime", (Object)date);
        }
        if (maxRateDyo != null && totalRate.compareTo(BigDecimal.ONE) != 0 && StringUtils.isNotBlank((CharSequence)(sharerateStr = maxRateDyo.getString("sharerate")))) {
            BigDecimal sharerate = new BigDecimal(sharerateStr);
            sharerate = sharerate.add(BigDecimal.ONE).subtract(totalRate);
            maxRateDyo.set("sharerate", (Object)sharerate.toPlainString());
            maxRateDyo.set("initsharerate", (Object)sharerate.toPlainString());
        }
        SaveServiceHelper.save((DynamicObject[])entryentity);
    }

    private static BigDecimal getRate(Date period, String number, String orgId) {
        String skssqz;
        Date startDate = DateUtils.getFirstDateOfYear((Date)period);
        Date endDate = DateUtils.getLastDateOfYear((Date)period);
        String skssqq = DateUtils.format((Date)startDate);
        List deductionRateList = AssistService.queryAssistParams((String)number, (String)orgId, (String)skssqq, (String)(skssqz = DateUtils.format((Date)endDate)));
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0));
    }
}

