/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.pojo.DataResultVo;
import org.apache.commons.collections.CollectionUtils;

public class BranchTaxbookBusinessService {
    private static final Log LOGGER = LogFactory.getLog(BranchTaxbookBusinessService.class);
    private static final String ORG_GROUP_ENTITY_NAME = "tctb_org_group_latest";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String PERIOD = "period";
    private static String selectField = "id,org,hbfnszt,declaration,refreshtime,participation,shareid,taxoffice,taxorg,usable,billno,sumscheme,period,orgname,sharerate,initsharerate,income,salary,asset,billstatus,operator,operatetime";

    public static DataResultVo checkBrankShare(Long orgId, Date startdate, Date enddate) {
        String MSG = ResManager.loadKDString((String)"\u6c47\u603b\u65b9\u6848\u6709\u53d8\u66f4\uff0c\u8bf7\u5148\u66f4\u65b0\u5206\u652f\u673a\u6784\u7a0e\u6b3e\u5206\u644a\u53f0\u8d26\u3002", (String)"BranchTaxbookBusinessService_0", (String)"taxc-tccit", (Object[])new Object[0]);
        String MSG1 = ResManager.loadKDString((String)"\u6c47\u603b\u65b9\u6848\u5b58\u5728\u7ec4\u7ec7\u72b6\u6001\u53d8\u66f4\uff0c\u8bf7\u5148\u53bb\u540c\u6b65\u5230\u5206\u652f\u673a\u6784\u7a0e\u6b3e\u5206\u644a\u53f0\u8d26\u3002", (String)"BranchTaxbookBusinessService_1", (String)"taxc-tccit", (Object[])new Object[0]);
        String MSG2 = ResManager.loadKDString((String)"\u5b58\u5728\u5206\u644a\u6bd4\u4f8b\u4e3a\u7a7a\u7684\u5206\u652f\u673a\u6784\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u644a\u6bd4\u4f8b", (String)"BranchTaxbookBusinessService_2", (String)"taxc-tccit", (Object[])new Object[0]);
        String MSG3 = ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u503c\u4e0d\u7b49\u4e8e1\uff0c\u8bf7\u91cd\u65b0\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u644a\u6bd4\u4f8b", (String)"BranchTaxbookBusinessService_3", (String)"taxc-tccit", (Object[])new Object[0]);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)enddate).and(new QFilter("invaliddate", ">=", (Object)startdate).or(new QFilter("invaliddate", "=", null)));
        QFilter orgidFilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter rowOrgFilter = new QFilter("orgrow.orgid", "=", (Object)orgId);
        DynamicObject[] orgGroups = BusinessDataServiceHelper.load((String)ORG_GROUP_ENTITY_NAME, (String)"id,effectdate,modifytime,participation", (QFilter[])new QFilter[]{statusFilter, taxtypeFilter, dateFilter, billstatusFilter, rowOrgFilter});
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)startdate);
        Date lastDateOfYear = DateUtils.getLastDateOfYear1((Date)enddate);
        QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
        QFilter periodFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
        boolean exists1 = QueryServiceHelper.exists((String)"tccit_branch_share_bill", (QFilter[])new QFilter[]{orgidFilter, periodFilter, usableFilter});
        Optional<DynamicObject> maxDateGroupOption = Arrays.stream(orgGroups).max(Comparator.comparing(e -> e.getDate("effectdate")));
        if (!maxDateGroupOption.isPresent()) {
            return DataResultVo.ok();
        }
        DynamicObject maxDateGroup = maxDateGroupOption.get();
        DynamicObject orgGroup = BusinessDataServiceHelper.loadSingle((Object)maxDateGroup.getLong("id"), (String)ORG_GROUP_ENTITY_NAME);
        Optional<Long> totalOrgid = orgGroup.getDynamicObjectCollection("orgrow").stream().filter(e -> "2".equals(e.getString("declaration"))).map(e -> e.getDynamicObject("orgid").getLong("id")).findFirst();
        if (!totalOrgid.isPresent()) {
            return DataResultVo.ok();
        }
        String orgGroupName = orgGroup.getString("name");
        List thirdOrgList = orgGroup.getDynamicObjectCollection("orgrow").stream().filter(e -> "3".equals(e.getString("levelname"))).map(e -> e.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
        List<Long> totalEnableGroupList = BranchTaxbookBusinessService.filterEnableOrg(Collections.singletonList(totalOrgid.get()), firstDateOfYear);
        if (totalEnableGroupList.size() <= 0) {
            return DataResultVo.ok();
        }
        if (!exists1) {
            return DataResultVo.fail(MSG);
        }
        DynamicObjectCollection taxbookOrgs = QueryServiceHelper.query((String)"tccit_branch_share_bill", (String)"id,org,sharerate,refreshtime,declaration,shareid,hbfnszt", (QFilter[])new QFilter[]{new QFilter("sumscheme", "=", (Object)orgGroup.getLong("id")), periodFilter, usableFilter});
        if (taxbookOrgs.size() <= 0) {
            return DataResultVo.fail(MSG);
        }
        Date modifytime = orgGroup.getDate("modifytime");
        Date refreshtime = ((DynamicObject)taxbookOrgs.get(0)).getDate("refreshtime");
        if (Objects.nonNull(refreshtime) && modifytime.compareTo(refreshtime) > 0) {
            return DataResultVo.fail(MSG);
        }
        boolean participation = orgGroup.getBoolean("participation");
        if (participation) {
            List<Long> rowOrgs = orgGroup.getDynamicObjectCollection("orgrow").stream().map(e -> e.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
            List<Long> groupNsztOrg = BranchTaxbookBusinessService.getNsztOrg(rowOrgs);
            List<Long> enableGroupList = BranchTaxbookBusinessService.filterEnableOrg(groupNsztOrg, firstDateOfYear);
            Optional<DynamicObject> sharerateIsEmpty = taxbookOrgs.stream().filter(e -> e.getBoolean("shareid")).filter(e -> StringUtil.isBlank((CharSequence)e.getString("sharerate"))).findFirst();
            if (sharerateIsEmpty.isPresent()) {
                return DataResultVo.fail(MSG2);
            }
            BigDecimal sharerate = taxbookOrgs.stream().filter(e -> e.getBoolean("shareid")).map(e -> new BigDecimal(e.getString("sharerate"))).reduce(BigDecimal::add).get();
            if (sharerate.compareTo(BigDecimal.ONE) != 0) {
                return DataResultVo.fail(MSG3);
            }
            List notEnableOrgList = groupNsztOrg.stream().filter(e -> !enableGroupList.contains(e)).collect(Collectors.toList());
            Optional<Long> isContainsOtherOrg = notEnableOrgList.stream().filter(e -> !thirdOrgList.contains(e)).findFirst();
            if (isContainsOtherOrg.isPresent()) {
                List taxbookNsztOrg = taxbookOrgs.stream().filter(e -> "1".equals(e.getString("hbfnszt"))).map(e -> e.getLong("org")).collect(Collectors.toList());
                Optional<Long> first = taxbookNsztOrg.stream().filter(e -> !groupNsztOrg.contains(e)).findFirst();
                if (enableGroupList.size() != taxbookNsztOrg.size() || first.isPresent()) {
                    return DataResultVo.fail(MSG1);
                }
            } else if (notEnableOrgList.size() > 0) {
                return DataResultVo.success(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u4e0b\u7684\u4e09\u7ea7\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u5efa\u8bae\u7ef4\u62a4\u6c47\u603b\u65b9\u6848\uff0c\u5e76\u6838\u5b9e\u5206\u652f\u673a\u6784\u7a0e\u6b3e\u5206\u644a\u56e0\u7d20\u53f0\u8d26\u7684\u6570\u636e\u51c6\u786e\u6027", (String)"BranchTaxbookBusinessService_4", (String)"taxc-tccit", (Object[])new Object[0]), orgGroupName));
            }
        } else {
            List<Long> rowOrgs = orgGroup.getDynamicObjectCollection("orgrow").stream().filter(e -> "3".equals(e.getString("declaration"))).map(e -> e.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
            List<Long> groupNsztOrg = BranchTaxbookBusinessService.getNsztOrg(rowOrgs);
            List<Long> enableGroupList = BranchTaxbookBusinessService.filterEnableOrg(groupNsztOrg, firstDateOfYear);
            Optional<DynamicObject> sharerateIsEmpty = taxbookOrgs.stream().filter(e -> e.getBoolean("shareid")).filter(e -> "3".equals(e.getString("declaration"))).filter(e -> StringUtil.isBlank((CharSequence)e.getString("sharerate"))).findFirst();
            if (sharerateIsEmpty.isPresent()) {
                return DataResultVo.fail(MSG2);
            }
            Optional<BigDecimal> reduce = taxbookOrgs.stream().filter(e -> e.getBoolean("shareid")).filter(e -> "3".equals(e.getString("declaration"))).map(e -> new BigDecimal(e.getString("sharerate"))).reduce(BigDecimal::add);
            if (!reduce.isPresent() || reduce.get().compareTo(BigDecimal.ONE) != 0) {
                return DataResultVo.fail(MSG3);
            }
            List notEnableOrgList = groupNsztOrg.stream().filter(e -> !enableGroupList.contains(e)).collect(Collectors.toList());
            Optional<Long> isContainsOtherOrg = notEnableOrgList.stream().filter(e -> !thirdOrgList.contains(e)).findFirst();
            if (isContainsOtherOrg.isPresent()) {
                List taxbookNsztOrg = taxbookOrgs.stream().filter(e -> "1".equals(e.getString("hbfnszt"))).filter(e -> "3".equals(e.getString("declaration"))).map(e -> e.getLong("org")).collect(Collectors.toList());
                Optional<Long> first = taxbookNsztOrg.stream().filter(e -> !groupNsztOrg.contains(e)).findFirst();
                if (enableGroupList.size() != taxbookNsztOrg.size() || first.isPresent()) {
                    return DataResultVo.fail(MSG1);
                }
            } else if (notEnableOrgList.size() > 0) {
                return DataResultVo.success(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u4e0b\u7684\u4e09\u7ea7\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u5efa\u8bae\u7ef4\u62a4\u6c47\u603b\u65b9\u6848\uff0c\u5e76\u6838\u5b9e\u5206\u652f\u673a\u6784\u7a0e\u6b3e\u5206\u644a\u56e0\u7d20\u53f0\u8d26\u7684\u6570\u636e\u51c6\u786e\u6027", (String)"BranchTaxbookBusinessService_4", (String)"taxc-tccit", (Object[])new Object[0]), orgGroupName));
            }
        }
        return DataResultVo.ok();
    }

    public static List<DynamicObject> queryEnableOrgGroups(List<Long> hasPermOrgs, Date period) {
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)lastDateOfYear).and(new QFilter("invaliddate", ">=", (Object)firstDateOfYear).or(new QFilter("invaliddate", "=", null)));
        if (hasPermOrgs.size() > 0) {
            dateFilter.and(new QFilter("orgrow.orgid", "in", hasPermOrgs));
        }
        List<Object> enableOrgGroups = new ArrayList<DynamicObject>();
        DynamicObject[] orgGroupList = BusinessDataServiceHelper.load((String)ORG_GROUP_ENTITY_NAME, (String)"id,orgrow.orgid,orgrow.declaration,effectdate,name,number", (QFilter[])new QFilter[]{taxtypeFilter, statusFilter, dateFilter, billstatusFilter}, (String)"effectdate asc");
        if (orgGroupList.length <= 0) {
            return enableOrgGroups;
        }
        String names = Arrays.stream(orgGroupList).map(e -> e.getString("name")).collect(Collectors.joining(","));
        LOGGER.info("\u672a\u8fdb\u884c\u8fc7\u6ee4\u7684\u6c47\u603b\u65b9\u6848\u6570\u636e\uff1a{}", (Object)names);
        HashMap<Long, DynamicObject> filterOrgMap = new HashMap<Long, DynamicObject>();
        ArrayList<Long> filterOrgids = new ArrayList<Long>();
        for (DynamicObject orgGrp : orgGroupList) {
            DynamicObjectCollection orgrow = orgGrp.getDynamicObjectCollection("orgrow");
            Map<Long, DynamicObject> totalOrgMap = orgrow.stream().filter(e -> "2".equals(e.getString("declaration"))).collect(Collectors.toMap(k -> k.getDynamicObject("orgid").getLong("id"), v -> orgGrp));
            filterOrgMap.putAll(totalOrgMap);
            List orgList = orgrow.stream().map(e -> e.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
            filterOrgids.addAll(orgList);
        }
        List<Long> enableOrgList = BranchTaxbookBusinessService.filterEnableOrg(filterOrgids, firstDateOfYear);
        if (CollectionUtils.isEmpty(enableOrgList)) {
            return enableOrgGroups;
        }
        enableOrgGroups = filterOrgMap.entrySet().stream().filter(e -> enableOrgList.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        return enableOrgGroups;
    }

    public static String getDefaultOrgGroup(Long loginOrgId, List<DynamicObject> enableOrgGroups) {
        Optional<DynamicObject> first = enableOrgGroups.stream().filter(d -> {
            DynamicObjectCollection orgrow = d.getDynamicObjectCollection("orgrow");
            Optional<Long> optional = orgrow.stream().map(e -> e.getLong("orgid.id")).filter(f -> f.equals(loginOrgId)).findFirst();
            return optional.isPresent();
        }).findFirst();
        String defaultOrgGroup = first.isPresent() ? first.get().getString("id") : (EmptyCheckUtils.isNotEmpty(enableOrgGroups) ? enableOrgGroups.get(0).getString("id") : "0");
        return defaultOrgGroup;
    }

    public static List<Long> filterEnableOrg(List<Long> filterOrgids, Date firstDateOfYear) {
        List<Long> enableOrgList = new ArrayList<Long>(filterOrgids.size());
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(filterOrgids);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            enableOrgList = ((List)result.getData()).stream().filter(d -> d.getDate("registertime") != null && d.getDate("registertime").before(firstDateOfYear)).map(d -> d.getLong("taxorg.id")).collect(Collectors.toList());
        }
        return enableOrgList;
    }

    private static List<DynamicObject> filterEnableOrg(List<Long> filterOrgids) {
        List<Object> enableOrgList = new ArrayList<DynamicObject>(filterOrgids.size());
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(filterOrgids);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            enableOrgList = (List)result.getData();
        }
        return enableOrgList;
    }

    public static List<Long> getNsztOrg(List<Long> orgs) {
        DynamicObjectCollection nsztOrgList = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"org", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgs), new QFilter("istaxpayer", "=", (Object)"1")});
        return nsztOrgList.stream().map(e -> e.getLong("org")).collect(Collectors.toList());
    }

    public static DynamicObjectCollection getPeriodTaxbookData(Date period) {
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
        QFilter dateFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
        QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"tccit_branch_share_bill", (String)"id,sumscheme,org,sharerate,refreshtime,declaration,shareid,hbfnszt", (QFilter[])new QFilter[]{dateFilter, usableFilter});
    }

    public static DynamicObjectCollection getTaxbookData(Date period, Long sumscheme) {
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
        QFilter dateFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
        QFilter sumschemeFilter = new QFilter("sumscheme", "=", (Object)sumscheme);
        QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"tccit_branch_share_bill", (String)"id,sumscheme,org,sharerate,refreshtime,declaration,shareid,hbfnszt", (QFilter[])new QFilter[]{dateFilter, sumschemeFilter, usableFilter});
    }

    public static DynamicObject[] queryOrgGroup(List<Long> orgGroupId) {
        if (orgGroupId == null || orgGroupId.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)ORG_GROUP_ENTITY_NAME, (String)"id,orgrow.orgid,orgrow.declaration,orgrow.shareid,participation", (QFilter[])new QFilter[]{new QFilter("id", "in", orgGroupId), new QFilter("status", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orgGroupLatestHandle(String groupId, String operation, String entityNumber) {
        DLock lock = DLock.create((String)groupId);
        try {
            if (lock.tryLock(60000L)) {
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
                ArrayList<DynamicObject> updateUsableList = new ArrayList<DynamicObject>(16);
                DynamicObject groupObj = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)entityNumber);
                DynamicObject[] standingBookData = BusinessDataServiceHelper.load((String)"tccit_branch_share_bill", (String)selectField, (QFilter[])new QFilter[]{new QFilter("sumscheme", "=", (Object)Long.parseLong(groupId))});
                if (standingBookData.length <= 0) {
                    return;
                }
                BranchTaxbookBusinessService.orgGroupDataHandle(saveList, updateList, updateUsableList, groupObj, standingBookData, operation);
                BranchTaxbookBusinessService.dataStorage(saveList, updateList, updateUsableList);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static void orgGroupDataHandle(List<DynamicObject> saveList, List<DynamicObject> updateList, List<DynamicObject> updateUsableList, DynamicObject groupObj, DynamicObject[] standingBookData, String operation) {
        DynamicObjectCollection orgrows = groupObj.getDynamicObjectCollection("orgrow");
        List<Long> orgGroupOrgList = orgrows.stream().map(orgrow -> orgrow.getDynamicObject("orgid")).map(org -> org.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> enableOrgObjList = BranchTaxbookBusinessService.filterEnableOrg(orgGroupOrgList);
        Map<Date, List<DynamicObject>> periodGroup = Arrays.stream(standingBookData).collect(Collectors.groupingBy(e -> e.getDate(PERIOD)));
        for (Map.Entry<Date, List<DynamicObject>> dateListEntry : periodGroup.entrySet()) {
            Date period = dateListEntry.getKey();
            List<DynamicObject> periodStandingBooks = dateListEntry.getValue();
            BranchTaxbookBusinessService.orgGroupDataHandle(period, saveList, updateList, updateUsableList, groupObj, periodStandingBooks, enableOrgObjList, orgrows);
        }
    }

    private static void orgGroupDataHandle(Date period, List<DynamicObject> saveList, List<DynamicObject> updateList, List<DynamicObject> updateUsableList, DynamicObject orgGroup, List<DynamicObject> periodStandingBooks, List<DynamicObject> enableOrgObjList, DynamicObjectCollection orgrows) {
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        long groupId = orgGroup.getLong("id");
        boolean participation = orgGroup.getBoolean("participation");
        ArrayList<Long> enableOrgids = new ArrayList<Long>(8);
        ArrayList<Long> istaxpayerList = new ArrayList<Long>(8);
        StringBuilder istaxpayerOrgid = new StringBuilder();
        for (DynamicObject object : enableOrgObjList) {
            if (object.getDate("registertime") == null || !object.getDate("registertime").before(firstDateOfYear)) continue;
            long taxorgid = object.getLong("taxorg.id");
            enableOrgids.add(taxorgid);
            if (((DynamicObject)object.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity").get(0)).getBoolean("entry_istaxpayer")) continue;
            istaxpayerList.add(taxorgid);
            istaxpayerOrgid.append(taxorgid);
        }
        LOGGER.info(String.format("BranchTaxbookBusinessService: \u53ef\u7528\u975e\u7eb3\u7a0e\u7ec4\u7ec7orgid\uff1a%s", istaxpayerOrgid));
        if (CollectionUtils.isEmpty(enableOrgids)) {
            return;
        }
        List<DynamicObject> orgRowList = orgrows.stream().filter(org -> enableOrgids.contains(org.getDynamicObject("orgid").getLong("id"))).collect(Collectors.toList());
        BranchTaxbookBusinessService.deleteNonExistentDataAndUpdate(updateUsableList, participation, enableOrgids, periodStandingBooks);
        BranchTaxbookBusinessService.nsztOrgHandler(firstDateOfYear, saveList, updateList, updateUsableList, groupId, participation, orgRowList, periodStandingBooks, istaxpayerList);
        BranchTaxbookBusinessService.fnsztOrgHandler(firstDateOfYear, saveList, updateList, updateUsableList, groupId, orgRowList, periodStandingBooks, istaxpayerList.size() > 0);
    }

    private static void deleteNonExistentDataAndUpdate(List<DynamicObject> updateUsableList, boolean participation, List<Long> orgGroupOrgList, List<DynamicObject> periodStandingBooks) {
        Optional<DynamicObject> first;
        List<DynamicObject> disableList = periodStandingBooks.stream().filter(e -> !orgGroupOrgList.contains(e.getDynamicObject("org").getLong("id"))).collect(Collectors.toList());
        disableList.forEach(e -> e.set("usable", (Object)"0"));
        updateUsableList.addAll(disableList);
        if (!participation && (first = periodStandingBooks.stream().filter(o -> "2".equals(o.getString("declaration"))).findFirst()).isPresent()) {
            DynamicObject dynamicObject = first.get();
            dynamicObject.set("sharerate", (Object)BigDecimal.ZERO);
            dynamicObject.set("initsharerate", (Object)BigDecimal.ZERO);
            dynamicObject.set("income", (Object)"0");
            dynamicObject.set("salary", (Object)"0");
            dynamicObject.set("asset", (Object)"0");
            dynamicObject.set("billstatus", (Object)"A");
            updateUsableList.add(dynamicObject);
        }
    }

    private static void nsztOrgHandler(Date firstDateOfYear, List<DynamicObject> saveList, List<DynamicObject> updateList, List<DynamicObject> updateUsableList, long groupId, boolean participation, List<DynamicObject> orgrows, List<DynamicObject> periodStandingBooks, List<Long> istaxpayerList) {
        Map<Long, DynamicObject> inDbMap = periodStandingBooks.stream().filter(s -> Objects.equals("1", s.getString("hbfnszt"))).collect(Collectors.toMap(k -> k.getDynamicObject("org").getLong("id"), v -> v, (v1, v2) -> v1));
        for (DynamicObject orgrow : orgrows) {
            DynamicObject dyo;
            String declaration;
            boolean taxpayer;
            DynamicObject object;
            DynamicObject org = orgrow.getDynamicObject("orgid");
            long orgId = org.getLong("id");
            boolean istaxpayer = istaxpayerList.contains(orgId);
            if (istaxpayer && Boolean.TRUE.equals(orgrow.getBoolean("shareid")) && (object = inDbMap.get(orgId)) != null) {
                object.set("usable", (Object)"0");
                updateUsableList.add(object);
            }
            if (!(taxpayer = ("2".equals(declaration = orgrow.getString("declaration")) || "3".equals(declaration)) && !istaxpayer)) continue;
            if (!inDbMap.containsKey(orgId)) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)"tccit_branch_share_bill");
                long longId = DBUtils.getLongId((String)"tccit_branch_share_bill");
                dyo.set("id", (Object)longId);
                dyo.set("billno", (Object)String.valueOf(longId));
                dyo.set("org", (Object)org);
                dyo.set("sumscheme", (Object)groupId);
                dyo.set(PERIOD, (Object)firstDateOfYear);
                dyo.set("billstatus", (Object)"A");
                dyo.set("datastatus", (Object)"2");
                dyo.set("datasource", (Object)"1");
                dyo.set("hbfnszt", (Object)"1");
                dyo.set("usable", (Object)"1");
                saveList.add(dyo);
            } else {
                dyo = inDbMap.get(orgId);
                dyo.set("sumscheme", (Object)groupId);
                String billno = dyo.getString("billno");
                if (StringUtil.isBlank((CharSequence)billno)) {
                    dyo.set("billno", (Object)dyo.getString("id"));
                }
                dyo.set("usable", (Object)"1");
                updateList.add(dyo);
            }
            dyo.set("operator", (Object)RequestContext.get().getUserName());
            dyo.set("operatetime", (Object)DateUtils.formatHMS((Date)new Date()));
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                dyo.set("taxorg", ((DynamicObject)result.getData()).get("taxorg.id"));
                dyo.set("taxoffice", ((DynamicObject)result.getData()).get("taxoffice.id"));
            }
            dyo.set("shareid", orgrow.get("shareid"));
            dyo.set("participation", (Object)participation);
            dyo.set("refreshtime", (Object)new Date());
            if (!Objects.equals("1", dyo.get("hbfnszt"))) continue;
            dyo.set("declaration", orgrow.get("declaration"));
        }
    }

    private static void fnsztOrgHandler(Date firstDateOfYear, List<DynamicObject> saveList, List<DynamicObject> updateList, List<DynamicObject> updateUsableList, long groupId, List<DynamicObject> orgrows, List<DynamicObject> periodStandingBooks, Boolean istaxpayer) {
        DynamicObject object;
        List collect = periodStandingBooks.stream().filter(s -> Objects.equals("0", s.get("hbfnszt"))).collect(Collectors.toList());
        Optional<DynamicObject> declaration = orgrows.stream().filter(s -> "2".equals(s.get("declaration"))).findFirst();
        String firstLevelOrgName = "";
        if (declaration.isPresent()) {
            firstLevelOrgName = declaration.get().getString("orgid.name");
        }
        if (istaxpayer.booleanValue() && CollectionUtils.isEmpty(collect)) {
            if (declaration.isPresent()) {
                object = declaration.get();
                BranchTaxbookBusinessService.buildObject(firstDateOfYear, saveList, groupId, object, firstLevelOrgName);
            }
        } else if (CollectionUtils.isNotEmpty(collect)) {
            for (DynamicObject dynamicObject : collect) {
                dynamicObject.set("orgname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8\uff09", (String)"BranchShareListPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), firstLevelOrgName));
                dynamicObject.set("refreshtime", (Object)new Date());
                dynamicObject.set("usable", (Object)"1");
                dynamicObject.set("operator", (Object)RequestContext.get().getUserName());
                dynamicObject.set("operatetime", (Object)DateUtils.formatHMS((Date)new Date()));
                updateList.add(dynamicObject);
            }
        }
        if (!istaxpayer.booleanValue() && collect.size() > 0) {
            object = (DynamicObject)collect.get(0);
            object.set("usable", (Object)"0");
            updateUsableList.add(object);
        }
    }

    private static void buildObject(Date firstDateOfYear, List<DynamicObject> saveList, long groupId, DynamicObject object, String firstLevelOrgName) {
        DynamicObject org = object.getDynamicObject("orgid");
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"tccit_branch_share_bill");
        long longId = DBUtils.getLongId((String)"tccit_branch_share_bill");
        dyo.set("id", (Object)longId);
        dyo.set("billno", (Object)String.valueOf(longId));
        dyo.set("org", (Object)org);
        dyo.set("sumscheme", (Object)groupId);
        dyo.set(PERIOD, (Object)firstDateOfYear);
        dyo.set("billstatus", (Object)"A");
        dyo.set("datastatus", (Object)"2");
        dyo.set("datasource", (Object)"1");
        dyo.set("hbfnszt", (Object)"0");
        dyo.set("refreshtime", (Object)new Date());
        saveList.add(dyo);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            dyo.set("taxorg", ((DynamicObject)result.getData()).get("taxorg.id"));
            dyo.set("taxoffice", ((DynamicObject)result.getData()).get("taxoffice.id"));
        }
        dyo.set("declaration", (Object)"3");
        dyo.set("usable", (Object)"1");
        dyo.set("shareid", object.get("shareid"));
        dyo.set("orgname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8\uff09", (String)"BranchShareListPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), firstLevelOrgName));
        dyo.set("operator", (Object)RequestContext.get().getUserName());
        dyo.set("operatetime", (Object)DateUtils.formatHMS((Date)new Date()));
    }

    public static void newData(String currentNode, Date period) {
        DynamicObject[] orgGroups;
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear1((Date)period);
        List<Long> nodeList = Arrays.stream(currentNode.split(",")).map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        DynamicObject[] standingBookData = BusinessDataServiceHelper.load((String)"tccit_branch_share_bill", (String)selectField, (QFilter[])new QFilter[]{new QFilter("sumscheme", "in", nodeList), new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear)});
        Map<Long, List<DynamicObject>> periodGroup = Arrays.stream(standingBookData).collect(Collectors.groupingBy(e -> e.getDynamicObject("sumscheme").getLong("id")));
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> updateUsableList = new ArrayList<DynamicObject>(8);
        for (DynamicObject orgGroup : orgGroups = BranchTaxbookBusinessService.queryOrgGroup(nodeList)) {
            DynamicObjectCollection orgrows = orgGroup.getDynamicObjectCollection("orgrow");
            List<Long> orgGroupOrgList = orgrows.stream().map(orgrow -> orgrow.getDynamicObject("orgid")).map(org -> org.getLong("id")).collect(Collectors.toList());
            List<DynamicObject> enableOrgObjList = BranchTaxbookBusinessService.filterEnableOrg(orgGroupOrgList);
            BranchTaxbookBusinessService.orgGroupDataHandle(period, saveList, updateList, updateUsableList, orgGroup, periodGroup.getOrDefault(orgGroup.getLong("id"), new ArrayList()), enableOrgObjList, orgrows);
        }
        BranchTaxbookBusinessService.dataStorage(saveList, updateList, updateUsableList);
    }

    private static void dataStorage(List<DynamicObject> saveList, List<DynamicObject> updateList, List<DynamicObject> updateUsableList) {
        if (CollectionUtils.isNotEmpty(saveList)) {
            LOGGER.info(String.format("BranchTaxbookBusinessService: \u65b0\u589e\u6570\u636eid\uff1a%s", saveList.stream().map(e -> e.getString("id")).collect(Collectors.joining(","))));
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            LOGGER.info(String.format("BranchTaxbookBusinessService: \u4fee\u6539\u6570\u636e\uff0c\u53causable\u72b6\u6001\uff1a%s", updateList.stream().map(e -> e.getString("id") + "-" + e.getString("usable")).collect(Collectors.joining(","))));
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isNotEmpty(updateUsableList)) {
            LOGGER.info(String.format("BranchTaxbookBusinessService: \u7f6e\u4e3a\u4e0d\u53ef\u7528\u6570\u636e\uff0c\u53causable\u72b6\u6001\uff1a%s", updateUsableList.stream().map(e -> e.getString("id") + "-" + e.getString("usable")).collect(Collectors.joining(","))));
            SaveServiceHelper.update((DynamicObject[])updateUsableList.toArray(new DynamicObject[0]));
        }
    }
}

