/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DevelopJjkcService {
    public static QFilter createYjdeductionTypeFilter(Date year) {
        QFilter q1 = new QFilter("start", "<=", (Object)DateUtils.getLastDateOfYear((Date)year)).and(new QFilter("end", ">=", (Object)DateUtils.getLastDateOfYear((Date)year)).or(new QFilter("end", "is null", null)));
        QFilter q2 = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"JJKC031"}));
        QFilter q3 = new QFilter("longnumber", "like", (Object)"%YJ-JJKC2021%");
        return q1.and(q2).and(q3);
    }

    public static Boolean existsValidData(Date year, String number) {
        if (year == null || StringUtil.isBlank((CharSequence)number)) {
            return Boolean.FALSE;
        }
        QFilter typeFilter = DevelopJjkcService.createYjdeductionTypeFilter(year);
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"tpo_discount_tree", (QFilter[])new QFilter[]{typeFilter, numberFilter});
    }

    public static List<ComboItem> initList(Function<DynamicObject, String> id) {
        QFilter q1 = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"YJ-JJKC2021", "JJKC031", "JJKC025"}));
        QFilter q2 = new QFilter("longnumber", "like", (Object)"%YJ-JJKC2021%");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"id,name,number", (QFilter[])new QFilter[]{q1, q2});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new ArrayList<ComboItem>();
        }
        return query.stream().map(s -> new ComboItem(new LocaleString(s.getString("name")), (String)id.apply((DynamicObject)s))).collect(Collectors.toList());
    }

    public static List<String> queryjjkcMethod(Date year) {
        QFilter listFilter = new QFilter("number", "in", (Object)new String[]{"110", "121", "122"});
        listFilter.and(new QFilter("bizdef.number", "=", (Object)"CIT-YFJJKC"));
        listFilter.and(new QFilter("validfrom", "<=", (Object)year).and(new QFilter("expired", ">=", (Object)year).or(new QFilter("expired", "is null", null))));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tpo_tccit_bizdef_entry", (String)"number", (QFilter[])new QFilter[]{listFilter});
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return new ArrayList<String>();
        }
        return objects.stream().map(s -> s.getString("number")).collect(Collectors.toList());
    }

    public static boolean isExists(String number, Date year, String declaretype, String deductiontype) {
        QFilter q1 = new QFilter("org.number", "=", (Object)number);
        QFilter q2 = new QFilter("year", "=", (Object)DateUtils.getFirstDateOfYear((Date)year));
        QFilter q3 = new QFilter("declaretype", "=", (Object)declaretype);
        QFilter q4 = new QFilter("deductiontype", "=", (Object)deductiontype);
        if ("1".equals(deductiontype)) {
            q4.or(new QFilter("deductiontype", "=", (Object)"2"));
        }
        if ("2".equals(deductiontype)) {
            q4.or(new QFilter("deductiontype", "=", (Object)"1"));
        }
        return QueryServiceHelper.exists((String)"tccit_develop_jjkc", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }
}

