/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class GovSubsidyDeferService {
    private static final String S_AMOUNT = "s_amount";
    private static final String J_AMOUNT = "j_amount";

    public void saveGovDeferMiddle(DynamicObjectCollection rec, DynamicObjectCollection cfl, Function<Integer, DynamicObject> function) {
        Map cflMap;
        BigDecimal ljsdbz = BigDecimal.ZERO;
        BigDecimal ljjzsy = BigDecimal.ZERO;
        int first = -1;
        int last = -1;
        HashMap<Integer, DynamicObject> map = new HashMap<Integer, DynamicObject>(16);
        Map yearMap = rec.stream().collect(Collectors.groupingBy(r -> DateUtils.getYearOfDate((Date)r.getDate("s_bookeddate")), Collectors.toList()));
        if (!yearMap.isEmpty()) {
            List sorted = yearMap.keySet().stream().sorted().collect(Collectors.toList());
            last = (Integer)sorted.get(sorted.size() - 1);
            first = (Integer)sorted.get(0);
        }
        if (!(cflMap = cfl.stream().collect(Collectors.groupingBy(r -> DateUtils.getYearOfDate((Date)r.getDate("j_bookeddate")), Collectors.toList()))).isEmpty()) {
            List sortedYears = cflMap.keySet().stream().sorted().collect(Collectors.toList());
            int lastYear = (Integer)sortedYears.get(sortedYears.size() - 1);
            last = lastYear > last ? lastYear : last;
            int firstYear = (Integer)sortedYears.get(0);
            int n = first = firstYear < first ? firstYear : first;
        }
        if (first > 0 && first <= last) {
            for (int year = first; year <= last; ++year) {
                DynamicObject middle = function.apply(year);
                BigDecimal dnsdbz = yearMap.getOrDefault(year, Collections.emptyList()).stream().map(o -> o.getBigDecimal(S_AMOUNT)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                middle.set("dnsdbz", (Object)dnsdbz);
                ljsdbz = ljsdbz.add(dnsdbz);
                middle.set("ljsdbz", (Object)ljsdbz);
                BigDecimal dnjzsy = cflMap.getOrDefault(year, Collections.emptyList()).stream().map(o -> o.getBigDecimal(J_AMOUNT)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                middle.set("dnjzsy", (Object)dnjzsy);
                ljjzsy = ljjzsy.add(dnjzsy);
                middle.set("ljjzsy", (Object)ljjzsy);
                map.put(year, middle);
            }
        }
        DynamicObject[] objects = (DynamicObject[])map.values().stream().peek(d -> d.set("syjzsyje", (Object)d.getBigDecimal("ljsdbz").subtract(d.getBigDecimal("ljjzsy")))).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])objects);
    }

    public DynamicObject queryByUnionKey(String orgNumber, String billNo) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"tccit_gov_subsidy_defer", (String)"id", (QFilter[])new QFilter[]{new QFilter("org.number", "=", (Object)orgNumber), new QFilter("billno", "=", (Object)billNo)});
        return Optional.ofNullable(object).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getLong("id"), (String)"tccit_gov_subsidy_defer")).orElseGet(() -> null);
    }
}

