/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.business.taxbook;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class NotTaccrualBasisService {
    private static final String SS_AMOUNT = "ss_amount";
    private static final String ZZ_AMOUNT = "zz_amount";

    public void saveNotTaccrualMiddle(DynamicObjectCollection tir, DynamicObjectCollection bir, Function<Integer, DynamicObject> function) {
        Map cflMap;
        BigDecimal ljsssr = BigDecimal.ZERO;
        BigDecimal ljzzsr = BigDecimal.ZERO;
        int first = -1;
        int last = -1;
        HashMap<Integer, DynamicObject> map = new HashMap<Integer, DynamicObject>(16);
        Map yearMap = tir.stream().collect(Collectors.groupingBy(r -> DateUtils.getYearOfDate((Date)r.getDate("ss_bookeddate")), Collectors.toList()));
        if (!yearMap.isEmpty()) {
            List sorted = yearMap.keySet().stream().sorted().collect(Collectors.toList());
            last = (Integer)sorted.get(sorted.size() - 1);
            first = (Integer)sorted.get(0);
        }
        if (!(cflMap = bir.stream().collect(Collectors.groupingBy(r -> DateUtils.getYearOfDate((Date)r.getDate("zz_bookeddate")), Collectors.toList()))).isEmpty()) {
            List sortedYears = cflMap.keySet().stream().sorted().collect(Collectors.toList());
            int lastYear = (Integer)sortedYears.get(sortedYears.size() - 1);
            last = lastYear > last ? lastYear : last;
            int firstYear = (Integer)sortedYears.get(0);
            int n = first = firstYear < first ? firstYear : first;
        }
        if (first > 0 && last >= first) {
            for (int year = first; year <= last; ++year) {
                DynamicObject middle = function.apply(year);
                BigDecimal dnsssr = yearMap.getOrDefault(year, Collections.emptyList()).stream().map(o -> o.getBigDecimal(SS_AMOUNT)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                middle.set("dnsssr", (Object)dnsssr);
                ljsssr = ljsssr.add(dnsssr);
                middle.set("ljsssr", (Object)ljsssr);
                BigDecimal dnzzsr = cflMap.getOrDefault(year, Collections.emptyList()).stream().map(o -> o.getBigDecimal(ZZ_AMOUNT)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                middle.set("dnzzsr", (Object)dnzzsr);
                ljzzsr = ljzzsr.add(dnzzsr);
                middle.set("ljzzsr", (Object)ljzzsr);
                map.put(year, middle);
            }
        }
        DynamicObject[] objects = (DynamicObject[])map.values().stream().peek(d -> d.set("syjzje", (Object)d.getBigDecimal("ljsssr").subtract(d.getBigDecimal("ljzzsr")))).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])objects);
    }
}

